#ifndef __SEEED_DHT__
#define __SEEED_DHT__

#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif

// 8 MHz(ish) AVR ---------------------------------------------------------
#if (F_CPU >= 7400000UL) && (F_CPU <= 9500000UL)
#define COUNT 3
// 16 MHz(ish) AVR --------------------------------------------------------
#elif (F_CPU >= 15400000UL) && (F_CPU <= 19000000L)
#define COUNT 6
#else
#error "CPU SPEED NOT SUPPORTED"
#endif

/* DHT library

MIT license
written by Adafruit Industries
*/

// how many timing transitions we need to keep track of. 2 * number bits + extra
#define MAXTIMINGS 85

#define DHT11 11
#define DHT22 22
#define DHT21 21
#define AM2301 21


class DHT {
    
private:
    uint8_t data[6];
    uint8_t _pin, _type, _count;
    boolean read(void);
    unsigned long _lastreadtime;
    boolean firstreading;

public:
    DHT(uint8_t pin, uint8_t type, uint8_t count=COUNT);
    
    void begin(void);
    float readTemperature(bool S=false);
    float convertCtoF(float);
    float readHumidity(void);
    
public:         // api for seeed graphical programming project
    
    DHT();
    
    /*
     * Function Name: TemperatureHumidityRead
     * Input - PinName: pin to connect
     *         th - chanel choose
     *              'T' - read temperature
     *              'H' - read humidity
     * Return - temperature or humidity
     */
    float TemperatureHumidityRead(int PinName, char th)
    {
        _pin = PinName;
        
        switch(th)
        {
            case 'T':       // temperature
            return readTemperature();

            case 'H':       // humidity
            return readHumidity();
        }
    }

};
#endif
