'use strict';

goog.provide('Blockly.Arduino.modules');
goog.require('Blockly.Arduino');


Blockly.Arduino['module_set_4_digital_display'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'tm1637_' + pin.toLowerCase();


    Blockly.Arduino.addInclude('tm1637', '#include "TM1637.h"');
    Blockly.Arduino.addDeclaration(varname, 'TM1637 ' + varname + ';');

    var code = varname + '.DigitDisplayWrite(' + pin + ', ' + pin2 + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_set_lcd_reg_backlight'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var color = Blockly.Arduino.valueToCode(block, 'COLOR', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var text1 = Blockly.Arduino.valueToCode(block, 'TEXT1', Blockly.Arduino.ORDER_ATOMIC) || '""';
    var text2 = Blockly.Arduino.valueToCode(block, 'TEXT2', Blockly.Arduino.ORDER_ATOMIC) || '""';
    var varname = "lcd_" + pin.toLowerCase();
    
    Blockly.Arduino.addInclude('wire_h', '#include "Wire.h"');
    Blockly.Arduino.addInclude('lcd_reg_backlight', '#include "Seeed_LCDRGBBacklight.h"');

    if (block.hardwareI2C) {
        Blockly.Arduino.addDeclaration(varname, 'LCDRGBBacklight ' + varname + ';');
    } else {
        Blockly.Arduino.addDeclaration(varname, 'LCDRGBBacklight ' + varname + '(' + pin + ', ' + pin2 + ');');
    }
    
    var setupCode = 'Serial.begin(9600);';
    Blockly.Arduino.addSetup('serial', setupCode, true);
    setupCode = varname + '.Init();';
    Blockly.Arduino.addSetup('lcd_reg_backlight_init' + pin, setupCode, true);
	
    setupCode = varname + '.setColor(' + color + ');';
    Blockly.Arduino.addSetup('lcd_reg_backlight_color' + pin, setupCode, true);


    var code = varname + '.setColor(' + color + ');\n'+ varname + '.Print(0, ' + text1 + ');\n' + varname + '.Print(1, ' + text2 + ');\n';
    return code;
};


Blockly.Arduino['module_set_chainable_rgb_led'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var red = Blockly.Arduino.valueToCode(block, 'RED', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var green = Blockly.Arduino.valueToCode(block, 'GREEN', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var blue = Blockly.Arduino.valueToCode(block, 'BLUE', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'chainable_led_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('chainable_led', '#include "ChainableLED.h"');
    Blockly.Arduino.addDeclaration(varname, 'ChainableLED ' + varname + ';');

    var code = varname + '.ChainableRGBLEDWrite(' + pin + ', ' + pin2 + ', 1, ' + red + ', ' + green + ', ' + blue + ');\n';
    return code;
};


Blockly.Arduino['module_read_thumb_joystick'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var axis = block.getFieldValue('AXIS');
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = '';
    if (axis==='X'){
        code = 'analogRead(' + pin + ')';
    }else if (axis==='Y') {
        if (pin[1] === '0')
            code = 'analogRead(' + 'A1' + ')' ;
        else if (pin[1] === '1')
            code = 'analogRead(' + 'A2' + ')' ;
        else if (pin[1] === '2')
            code = 'analogRead(' + 'A3' + ')' ;
        else if (pin[1] === '5')
            code = 'analogRead(' + 'A4' + ')' ;
    }

    return [code, Blockly.Arduino.ORDER_ATOMIC];
};


Blockly.Arduino['module_set_speaker'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var tone = Blockly.Arduino.valueToCode(block, 'TONE', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'speaker_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('speaker', '#include "Speaker.h"');
    Blockly.Arduino.addDeclaration(varname, 'grove_speaker_g ' + varname + ';');

    var code = varname + '.SpeakerWrite(' + pin + ', ' + tone + ');\n';
    return code;
};


Blockly.Arduino['module_read_button'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('button' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_read_infrared_reciver'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var varname = 'IR';

    Blockly.Arduino.addInclude('InfraredReceiver', '#include "Seeed_InfraredReceiver.h"');
    Blockly.Arduino.addDeclaration(varname, 'InfraredReceiver ' + varname + '(' + pin +');');

    var setupCode = 'Serial.begin(115200);';
    Blockly.Arduino.addSetup('serial', setupCode, true);
	
    setupCode =  varname + '.Init();';
    Blockly.Arduino.addSetup('init', setupCode, true);	

    var code = varname + '.InfraredReceiverRead()';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_read_rotary_angle_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    setupCode =  'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('rotary_angle_sensor' + pin, setupCode, true);

    var code = 'analogRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};


Blockly.Arduino['module_read_temperature_and_humidity_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var type = block.getFieldValue('TYPE');
    var varname = 'dht_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('dht', '#include "SeeedDHT.h"');
    Blockly.Arduino.addDeclaration(varname, 'DHT ' + varname + ';');

    var setupCode = 'Serial.begin(115200);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = null;
    code = varname + '.TemperatureHumidityRead(' + pin + ", '" + type + "')";

    return [code, Blockly.Arduino.ORDER_ATOMIC];
};


Blockly.Arduino['module_set_servo'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var angle = Blockly.Arduino.valueToCode(block, 'ANGLE', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'servo_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('servo', '#include "Servo.h"');
    Blockly.Arduino.addDeclaration(varname, 'Servo ' + varname + ';');

    var setupCode = varname + '.attach(' + pin + ');';
    Blockly.Arduino.addSetup(varname, setupCode, true);

    var code = varname + '.write(' + angle + ');\n';

    return code;
};


Blockly.Arduino['module_read_ultrasonic_ranger'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var varname = 'ultrasonic_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('ultrasonic', '#include "Ultrasonic.h"');
    Blockly.Arduino.addDeclaration(varname, 'Ultrasonic ' + varname + ';');

    var setupCode = 'Serial.begin(115200);';
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = varname + '.UltrasonicRangerRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_read_temperature_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');


    Blockly.Arduino.addInclude('Seeed_temperature_sensor', '#include "Seeed_temperature_sensor.h"');


    var code = 'get_data_temperature(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};



Blockly.Arduino['module_set_mini_motor_driver'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var motor = Blockly.Arduino.valueToCode(block, 'MOTOR', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var action = Blockly.Arduino.valueToCode(block, 'ACTION', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = "miniI2CMotorDriver_" + pin.toLowerCase();
    
    Blockly.Arduino.addInclude('miniI2CMotorDriver', '#include "Seeed_MiniI2CMotorDriver.h"');

    if (block.hardwareI2C) {
        Blockly.Arduino.addDeclaration(varname, 'MiniI2CMotorDriver ' + varname + ';');
    } else {
        Blockly.Arduino.addDeclaration(varname, 'MiniI2CMotorDriver ' + varname + '(' + pin + ', ' + pin2 + ');');
    }
    
    var setupCode = 'Serial.begin(115200);';
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = varname + '.Driver(' + motor + ', ' + action + ');\n';
    return code;
};

Blockly.Arduino['module_set_car_motor_driver'] = function(block) {
    var motor_num = Blockly.Arduino.valueToCode(block, 'MOTOR', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var speed = Blockly.Arduino.valueToCode(block, 'ACTION', Blockly.Arduino.ORDER_ATOMIC) || '0';
 
    Blockly.Arduino.addInclude('Alphabot_Motor_Driver', '#include "Alphabot_Motor_Driver.h"');


    
    var setupCode = 'car_init();';
    Blockly.Arduino.addSetup('car_init', setupCode, true);

    var code = 'motor_control(' + motor_num + ', ' + speed + ');\n';
    return code;
};


Blockly.Arduino['module_set_buzzer'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('buzzer' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_set_recorder'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('recorder' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_set_relay'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('relay' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_read_line_finder'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('line_finder' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_read_sunlight_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    setupCode =  'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('sunlight_sensor' + pin, setupCode, true);

    var code = 'analogRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};



Blockly.Arduino['module_read_tilt_switch'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('tilt_switch' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_set_el_driver'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('el_driver' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_set_vibration_motor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('vibration_motor' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_read_water_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('water_sensor' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_read_slide_potentiometer'] = function(block) {
    var pin = block.getFieldValue('PIN');
    
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    setupCode =  'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('rotary_angle_sensor' + pin, setupCode, true);

    var code = 'analogRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_set_electromagnet'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('electromagnet' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_set_dc_motor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('dc_motor' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_read_magnetic_switch'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('magnetic_switch' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_read_pir_motion_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('pir_motion_sensor' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_set_flexi_strip_led'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var id = Blockly.Arduino.valueToCode(block, 'ID', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var red = Blockly.Arduino.valueToCode(block, 'RED', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var green = Blockly.Arduino.valueToCode(block, 'GREEN', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var blue = Blockly.Arduino.valueToCode(block, 'BLUE', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'wsRGBLED_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('flexi_strip_led', '#include "Seeed_WS2812RGBLED.h"');
    Blockly.Arduino.addDeclaration(varname, 'WS2812RGBLED ' + varname + ';');

    var code = varname + '.Ws2812WriteData(' + pin + ', ' + id + ', ' + red + ', ' + green + ', ' + blue + ');\n';
    return code;
};

Blockly.Arduino['module_read_pressure_vibration_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    setupCode =  'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('pressure_vibration_sensor' + pin, setupCode, true);

    var code = 'analogRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_read_loudness_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    setupCode =  'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('loudness_sensor' + pin, setupCode, true);

    var code = 'analogRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_read_moisture_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    setupCode =  'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('moisture_sensor' + pin, setupCode, true);

    var code = 'analogRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_set_led_bar'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'ledBar_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('ledBar', '#include "Seeed_LEDBar.h"');
    Blockly.Arduino.addDeclaration(varname, 'LEDBarClass ' + varname + ';');

    var code = varname + '.LEDBarWriteData(' + pin + ', ' + pin2 + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_read_flame_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('flame_sensor' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_set_cicular_led'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'circularLED_' + pin.toLowerCase();

    Blockly.Arduino.addInclude('ledBar', '#include "Seeed_CircularLed.h"');
    Blockly.Arduino.addDeclaration(varname, 'CircularLedClass ' + varname + ';');

    var code = varname + '.CircularLedWriteData(' + pin + ', ' + pin2 + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_read_collision_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('collision_sensor' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_set_red_led'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var digit = Blockly.Arduino.valueToCode(block, 'DIGIT', Blockly.Arduino.ORDER_ATOMIC) || '0';

    var setupCode = 'pinMode(' + pin + ', OUTPUT);';
    Blockly.Arduino.addSetup('red_led' + pin, setupCode, true);

    var code = 'digitalWrite(' + pin + ', ' + digit + ');\n';
    return code;
};

Blockly.Arduino['module_read_touch_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('touch_sensor' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_read_hall_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
       
    var setupCode = 'pinMode(' + pin + ', INPUT);';
    Blockly.Arduino.addSetup('hall_sensor' + pin, setupCode, true);

    var code = 'digitalRead(' + pin + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];;
};

Blockly.Arduino['module_read_3_axis_accelerometer'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var axis = block.getFieldValue('AXIS');
    var varname = 'adx_' + pin.toLowerCase();

    var setupCode = varname + '.init();';
    Blockly.Arduino.addSetup('3_axis_accelerometer' + pin, setupCode, true);
    setupCode = 'Serial.begin(115200);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    Blockly.Arduino.addInclude('wire_h', '#include "Wire.h"');
    Blockly.Arduino.addInclude('3_axis_accelerometer', '#include "ADXL345.h"');
    Blockly.Arduino.addDeclaration(varname, 'ADXL345 ' + varname + ';');

    var code = varname + '.AxisDigitalAccelerometerRead(5, \'' + axis + '\')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_read_i2c_touch_sensor'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');
    var channel = Blockly.Arduino.valueToCode(block, 'CHANNEL', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var varname = 'i2cTouch_' + pin.toLowerCase();

    var setupCode = varname + '.Init();';
    Blockly.Arduino.addSetup('i2c_touch_sensor' + pin, setupCode, true);
    setupCode = 'Serial.begin(115200);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    Blockly.Arduino.addInclude('wire_h', '#include "Wire.h"');
    Blockly.Arduino.addInclude('i2c_touch_sensor', '#include "Seeed_I2CTouchSensor.h"');
    Blockly.Arduino.addDeclaration(varname, 'I2CTouch ' + varname + ';');

    var code = varname + '.I2CTouchRead(' + channel + ')';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['module_read_gesture'] = function(block) {
    var pin = block.getFieldValue('PIN');
    var pin2 = block.getFieldValue('PIN2');

    var varname = 'gesture_' + pin.toLowerCase();

    var setupCode = varname + '.Init();';
    Blockly.Arduino.addSetup('gesture' + pin, setupCode, true);
    setupCode = 'Serial.begin(115200);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    Blockly.Arduino.addInclude('wire_h', '#include "Wire.h"');
    Blockly.Arduino.addInclude('gesture', '#include "Seeed_Gesture.h"');
    Blockly.Arduino.addDeclaration(varname, 'Gesture ' + varname + ';');

    var code = varname + '.GestureRead()';
    return [code, Blockly.Arduino.ORDER_ATOMIC];
};