'use strict';

goog.provide('Blockly.Arduino.ext');
goog.require('Blockly.Arduino');


Blockly.Arduino['write_eeprom'] = function(block) {
    var addr = Blockly.Arduino.valueToCode(block, 'ADDR', Blockly.Arduino.ORDER_ATOMIC) || '0';
    var value = Blockly.Arduino.valueToCode(block, 'VALUE', Blockly.Arduino.ORDER_ATOMIC) || '0';

    Blockly.Arduino.addInclude('eeprom', '#include <EEPROM.h>');

    var code = "EEPROM.write(" + addr + ", " + value + ");\n";
    return code;
};

Blockly.Arduino['read_eeprom'] = function(block) {
    var addr = Blockly.Arduino.valueToCode(block, 'ADDR', Blockly.Arduino.ORDER_ATOMIC) || '0';

    Blockly.Arduino.addInclude('eeprom', '#include <EEPROM.h>');

    var code = 'EEPROM.read(' + addr + ')';

    return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['logic_level'] = function(block) {
  var code = (block.getFieldValue('LEVEL') == 'HIGH') ? 'HIGH' : 'LOW';
  return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino['set_code_check_flag'] = function(block) {
    var no = block.getFieldValue('ID');

    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = "Serial.write(" + no + ");\n";
    return code;
};

Blockly.Arduino['clear_code_check_flag'] = function(block) {
    var setupCode = 'Serial.begin(9600);'
    Blockly.Arduino.addSetup('serial', setupCode, true);

    var code = "Serial.write(0x5F);\n";
    return code;
};