'use strict'

goog.provide('Blockly.Blocks.ext')

goog.require('Blockly.Blocks');
goog.require('Blockly.Types');

/**
 * Common HSV hue for all blocks in this category.
 */
Blockly.Blocks.ext.HUE = 210;

Blockly.Blocks['write_eeprom'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("写入EEPROM");
    this.appendValueInput("ADDR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("地址（0~1023）");
    this.appendValueInput("VALUE")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("值（0~255）");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour("#FFC758");
    this.setTooltip('');
    this.setHelpUrl('http://www.seeedstudio.com/wiki');
  }
};

Blockly.Blocks['read_eeprom'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("读取EEPROM");
    this.appendValueInput("ADDR")
        .setCheck("Number")
        .setAlign(Blockly.ALIGN_RIGHT)
        .appendField("地址（0~1023）");
    this.setInputsInline(true);
    this.setOutput(true, "Number");
    this.setColour("#FFC758");
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  },
    getBlockType: function() {
    return Blockly.Types.NUMBER;
  }
};

Blockly.Blocks['logic_level'] = {
  init: function() {
    this.appendDummyInput()
        .appendField(new Blockly.FieldDropdown([["高电平", "HIGH"], ["低电平", "LOW"]]), "LEVEL");
    this.setOutput(true, "Number");
    this.setColour("#7365CF");
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['set_code_check_flag'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("点亮代码检查旗帜")
        .appendField("编号")
        .appendField( new Blockly.FieldDropdown([["1", "1"], ["2", "2"], ["3", "3"], ["4", "4"], ["5", "5"], ["6", "6"], ["7", "7"]]), "ID");

    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour("#FFC758");
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};

Blockly.Blocks['clear_code_check_flag'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("清空所有代码检查旗帜");

    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour("#FFC758");
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};