// This file is a part of MPDN Extensions.
// https://github.com/zachsaw/MPDN_Extensions
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 3.0 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library.
// 
sampler SourceSampler: register(s0);
sampler SmallSampler: register(s2);
float4 srcConsts : register(c0);
float4 dstConsts : register(c1);
#define srcSize (srcConsts.xy)
#define srcPixSize (srcConsts.zw)
#define dstSize (dstConsts.xy)
#define dstPixSize (dstConsts.zw)
#define factor (dstSize.y / srcSize.y)
#define taps 1
#define sqr(value) ((value)*(value))
// #define ConvertSpace(pix) (pix)

float4 main(float2 tex : TEXCOORD0) : COLOR
{
  float small = ConvertSpace(tex2D(SmallSampler, tex).rgb);
  float result = 0;
  float weightSum = 0;
  int low  = ceil ((tex.y - taps * dstPixSize.y) * srcSize.y - 0.5);
  int high = floor((tex.y + taps * dstPixSize.y) * srcSize.y - 0.5);
  [loop] [fastopt] for (int k = low; k <= high; k++)
  {
    float  pos    = srcPixSize.y * (k + 0.5);
    float  offset = abs((tex.y - pos) * dstSize.y);
    float  weight = saturate(0.5 + (0.5 - abs(offset)) / factor);
    float2 src    = tex2Dlod(SourceSampler, float4(tex.x, pos, 0, 0));
    result += weight * (src.y + sqr(src.x - small));
    weightSum += weight;
  }
  return float4(small, result / weightSum, 0, 0);  // x = Image; y = ImageVariance
}
