﻿// JavaScript Document

if(!UT){ var UT = {};}
UT.analysisArray = function(arr){
		var arry = arr.replace(/(^\s)|(\s$)/, "").replace(/[\r\n]/g, "");
		return eval('(' + arry + ')');
};
UT.URLToParams = function (params) {
	try {
		var paramsUrl = params.substring(params.indexOf("?") + 1).replace(/\&amp;/g, "&");
		var serverUrl = params.substring(0, params.indexOf("?"));
		var cmdMap = paramsUrl.split("&"), cmdParams = [], temp;
		for (var i = 0; i < cmdMap.length; i++) {
			temp = cmdMap[i].split("=");
			cmdParams[temp[0]] = temp[1];
		}
		var length = cmdParams.length;
		cmdParams["server"] = serverUrl;
		return cmdParams;
	}
	catch (e) {
		e.report(LV.localRes["paramModifyError"], "1206");
		return [];
	}
};
UT.URLDecode = function (Str) {
	if (Str == null || Str == "") {
		return "";
	}
	var newStr = "";

	function toCase(sStr) {
		return sStr.toString(16).toUpperCase();
	};
	for (var i = 0, ichar, len = Str.length; i < len;) {
		if (Str.charAt(i) == "%") {
			ichar = Str.charAt(i + 1);
			if (ichar.toLowerCase() == "e") {
				newStr += String.fromCharCode(((parseInt("0x" + Str.substr(i + 1, 2)) - 0xE0) * 0x1000) + ((parseInt("0x" + Str.substr(i + 4, 2)) - 0x80) * 0x40) + (parseInt("0x" + Str.substr(i + 7, 2)) - 0x80));
				i += 9;
			} else if (ichar.toLowerCase() == "c" || ichar.toLowerCase() == "d") {
				newStr += String.fromCharCode(((parseInt("0x" + Str.substr(i + 1, 2)) - 0xC0) * 0x40) + parseInt("0x" + Str.substr(i + 4, 2)) - 0x80);
				i += 6;
			} else {
				newStr += String.fromCharCode(parseInt("0x" + Str.substr(i + 1, 2)));
				i += 3;
			}
		} else {
			newStr += Str.charAt(i).replace(/\+/, " ");
			i++;
		}
	}
	return newStr;
};
UT.URLEncode = function (Str) {
	if (Str == null || Str == "") {
		return "";
	}
	var newStr = "";
	var toCase = function (sStr) {
		return sStr.toString(16).toUpperCase();
	};
	for (var i = 0, icode, len = Str.length; i < len; i++) {
		icode = Str.charCodeAt(i);
		if (icode < 0x10) {
			newStr += "%0" + icode.toString(16).toUpperCase();
		} else if (icode < 0x80) {
			if (icode == 0x20) {
				newStr += "+";
			} else if ((icode >= 0x30 && icode <= 0x39) || (icode >= 0x41 && icode <= 0x5A) || (icode >= 0x61 && icode <= 0x7A)) {
				newStr += Str.charAt(i);
			} else {
				newStr += "%" + toCase(icode);
			}
		} else if (icode < 0x800) {
			newStr += "%" + toCase(0xC0 + (icode >> 6));
			newStr += "%" + toCase(0x80 + icode % 0x40);
		} else {
			newStr += "%" + toCase(0xE0 + (icode >> 12));
			newStr += "%" + toCase(0x80 + (icode >> 6) % 0x40);
			newStr += "%" + toCase(0x80 + icode % 0x40);
		}
	}
	return newStr;
};
UT.addEvent = function(element, eventName, eventFunction){
	try {
		if (document.attachEvent) {
			element.attachEvent("on" + eventName, eventFunction);
		}
		else {
			element.addEventListener(eventName, eventFunction, false);
		}
	} 
	catch (e) {
	}
};
UT.getTime = function(time){
	var time = eval(time);
	var hour = new Date(time).getHours();
	if (hour < 10) {
		hour = "0" + hour;
	}
	var minute = new Date(time).getMinutes();
	if (minute < 10) {
		minute = "0" + minute;
	}
	var second = new Date(time).getSeconds();
	if (second < 10) {
		second = "0" + second;
	}
	var time = hour+":"+minute+":"+second;
	return time;
};
dom = (function() {
		var fixAttr = {
			tabindex: 'tabIndex',
			readonly: 'readOnly',
			'for': 'htmlFor',
			'class': 'className',
			maxlength: 'maxLength',
			cellspacing: 'cellSpacing',
			cellpadding: 'cellPadding',
			rowspan: 'rowSpan',
			colspan: 'colSpan',
			usemap: 'useMap',
			frameborder: 'frameBorder',
			contenteditable: 'contentEditable'
		},
		div = document.createElement( 'div' );
		div.setAttribute('class', 't');
		var supportSetAttr = div.className === 't';
	
		return {
			setAttr : function(el, name, val) {
				el.setAttribute(supportSetAttr ? name : (fixAttr[name] || name), val);
			},
			getAttr : function(el, name) {
				return el.getAttribute(supportSetAttr ? name : (fixAttr[name] || name));
			}
		};
	})();
UT.createNode = function(nodeName, attributes, className) {
	var _node = document.createElement(nodeName);
	if (className) {
		_node.className = className;
	}
	for ( var name in attributes) {
		dom.setAttr(_node, name, attributes[name]);//_node.setAttribute(name, attributes[name]);
	}
	return _node;
};
/**
	fromHistoryTab是用于历史对话记录查询的。如果是访客对话将不传该值。
	appendId用于打印内容的Id

*/
UT.appendHtmlToHistory = function(html,fromHistoryTab,appendId){
	if(fromHistoryTab){
		$("#"+appendId).append(html);
	}else{
		$("#history").append(html);
		UT.scrollToBottom();
	}
};
UT.showInfo = function(info){
	$("#xiaoxi").append(info);
}

UT.scrollToBottomTimer;
UT.scrollToBottom = function(info){
	//make sure to scroll only once time
	if(UT.scrollToBottomTimer){
		clearTimeout(UT.scrollToBottomTimer);
	}
	UT.scrollToBottomTimer=setTimeout('UT.scrollToBottomReal()',200);
}
UT.scrollToBottomReal = function(){
	window.scrollTo(0,document.body.scrollHeight);
}
//
if(!LV){ var LV = {};}
LV.init = {
	loadVoice:function(that,mediaUrl,sendBy){
		$("object[class='icoVoice']").each(function(i){
			$(this).replaceWith("<span id='voice"+new Date().getTime()+"' class='icoVoice stop'></span>");
		});
		var mediaUrl = UT.URLEncode(mediaUrl)//UT.URLToParams(mediaUrl);//此处由于不能将一个地址直接传给Flash，所以必须分开组装后再传递。
		var flashvars = {"server":mediaUrl,"sender":sendBy,"callBack":"callBack"};
		var params = {"movie":"voice/voicePlayer.swf","wmode":"transparent","allowScriptAccess":"always","allowNetworking":"all","bgcolor":"#000000"};
		var attributes = {"id":"voice","name":"voice","class":"icoVoice"};
		swfobject.embedSWF("voice/voicePlayer.swf", $(that).find(".icoVoice").attr("id"), "19", "21", "10.0.0", "../js/assets/expressInstall.swf",flashvars, params, attributes);
	},
	loadVideo:function(that,mediaUrl,mediaTime){
		var mediaUrl = UT.URLEncode(mediaUrl);//UT.URLToParams(mediaUrl);//此处由于不能将一个地址直接传给Flash，所以必须分开组装后再传递。
		var flashvars = {"server":mediaUrl,"callBack":"callBack"};
		var params = {"movie":"video/playVideo.swf","wmode":"transparent","allowScriptAccess":"always","allowNetworking":"all","bgcolor":"#000000"};
		var attributes = {"id":"video","name":"video","url":mediaUrl,"mediaTime":mediaTime};
		swfobject.embedSWF("video/playVideo.swf", $(that).parent(".flashContent").attr("id"), "320", "240", "10.0.0", "../js/assets/expressInstall.swf",flashvars, params, attributes);
	},
	getSWF:function(movieName){
		if (navigator.appName.indexOf("Microsoft") != -1){
			return window[movieName];
		} else {
			return document[movieName];
		}
	},
	endVoice:function(){
		
	}
};
LV.playVideo = function(that){
	var mediaUrl = $(that).attr("url");
	var mediaTime = $(that).attr('time')
	$(that).parents(".cloudBody").css('width','340');
	$(that).parents(".videoPanel").children(".wxVideoBoxAction").children('.video_switch').unbind().bind('click',function(){
		LV.stopVideo(this);
	});
	$(that).parents(".videoPanel").children(".wxVideoBoxAction").css('display','block');
	LV.init.loadVideo(that,mediaUrl,mediaTime);
};
LV.stopVideo = function(that){
	var mediaImgUrl = $(that).attr('imgUrl');
	$(that).parent().hide();
	$(that).parents(".cloudBody").css('width','180');
	var wxVideoBoxAction = UT.createNode("div",{style:"display:none"},"wxVideoBoxAction");
	$(wxVideoBoxAction).css("display","none");
	var wxVideoBoxFold = UT.createNode("a",{id:"wxVideoBoxFold",imgUrl:mediaImgUrl},"video_switch");
	$(wxVideoBoxFold).unbind().bind("click",function(){
		LV.stopVideo(this);
	});
	wxVideoBoxFold.innerHTML="<i class='icon14_common switch_gray'></i>收起";
	wxVideoBoxAction.appendChild(wxVideoBoxFold);
	var flashContent = UT.createNode("div",{id:"video"+new Date().getTime()},"flashContent");
	var imageBorder = UT.createNode("img",{width:"160",height:"100",src:mediaImgUrl},"imageBorder");
	$(imageBorder).css({width:"160",height:"100"});
	var wx_ico_video = UT.createNode("span",{url:UT.URLDecode($(that).parent().next().attr('url'))},"wx_ico_video");
	$(wx_ico_video).unbind().bind("click",function(){
		LV.playVideo(this);
	});
	var wx_video_duration = UT.createNode("div",{},"wx_video_duration");
	wx_video_duration.innerHTML = $(that).parent().next().attr('time');
	flashContent.appendChild(imageBorder);
	flashContent.appendChild(wx_ico_video);
	flashContent.appendChild(wx_video_duration);
	$(that).parent().parent().empty().append(wxVideoBoxAction).append(flashContent);
};
LV.playVoice = function(that){
	if($(that).find("object").length<=0){
		var mediaUrl = $(that).attr("url");
		var sendBy = $(that).attr("sendBy");
		var mediaTime = $(that).attr("time");
		LV.init.loadVoice(that,mediaUrl,sendBy);
		$(that).find(".noPlayed").remove();
		setTimeout(function(){
			$(that).find(".icoVoice").replaceWith("<span id='voice"+new Date().getTime()+"' class='icoVoice stop'></span>");
		},eval(mediaTime*1000)+1600);
	}else{
		$(that).find(".icoVoice").replaceWith("<span id='voice"+new Date().getTime()+"' class='icoVoice stop'></span>");
	}
};
/*

1.msgContent 消息内容 
2.type 文字消息类型  0 :{type:"0",msgContent:{senderType:"0",msgType:"0",name:"xxx",cont:"dsad",time:"12:12:12"}}
		1.senderType 发送着类型： 0 访客 1 客服
		1.msgType 0 纯文字 1 图片 2 链接
		2.cont 消息内容 “文字,链接地址/图片地址” {text:"",url:"",width:"",height:""}
		3.name 发送者名字
		4.time 消息发送时间
	媒体消息类型 1
		1.senderType 发送着类型： 0 访客 1 客服
		1.msgType 	0 语音 1 视频 2 音乐
		2.cont	"语音图片地址，语音时间，语音地址,..." {type:"1",msgContent:{senderType:"0",msgType:"0",name:"xxx",cont:{mediaImgUrl:"",mediaName:"",mediaUrl:"",mediaTime:""},time:"12:12:12"}}
		3.name 发送者名字
		4.time 消息发送时间
	图文消息类型 2 :{type:"2",msgContent:{senderType:"0",msgType:"0",name:"刘ll",cont:{imgTextNum:"2",imgText1:{text:"xzssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssx",imgUrl:"http://multi.live800.com/live800/faqMaterials/800_20140320105133510.jpg",url:"http://www.baidu.com"},imgText2:{text:"xzssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssx",imgUrl:"http://multi.live800.com/live800/faqMaterials/800_20140320105133510.jpg"}},time:"1970-01-01 13:56:00"}}
		1.senderType 发送着类型： 0 访客 1 客服
		1.msgType 0 默认是0，目前只有一种
		2.cont 数组 {imgTextNum:"",imgText1:{text:"",imgUrl:""},imgText2:{}}
		3.name 发送者名字
		4.time 消息发送时间
		
		fromHistoryTab是用于历史对话记录查询的。如果是访客对话将不传该值。
*/
LV.sendMessage = function(cont,fromHistoryTab){
	var params = null;	
	if(fromHistoryTab){
		params = UT.analysisArray(cont);
	}else{
		params = cont;//UT.analysisArray(cont);
	}
	var messageType = params['type'];
	var content = params['msgContent'];
	switch (messageType) {
	case "0":
		LV.SendWord(content);
		break;
		
	case "1":
		LV.SendMedia(content,fromHistoryTab);
		break;
		
	case "2":		
		LV.SendImageText(content);
		break;

	default:
		break;
	}
};

LV.setOperatorFont = function(content){
	
	try{
		var contet_json = UT.analysisArray(content);
		var mechattext = $(".me > .chatText");
		if(mechattext && mechattext.length!=0 && contet_json){
			mechattext.css("font-size",contet_json["fontSize"]+"px");
			mechattext.css("color",contet_json["fontColor"]);
			mechattext.css("font-family",contet_json["fontName"]);
			mechattext.css("font-style",contet_json["fontStyle"]);
			mechattext.css("font-weight",contet_json["fontWeight"]);
		}
	}catch(e){
	alert("catch");
	}
}

LV.SendWord= function(content){
	var sendBy = "", html= "";
	var messageType = content['msgType'];//文字消息类型：0 纯文字 ，1 为图片，2为链接
	var lan = content['language'];
	var name = content['name'];//发送着姓名
	var msgCont = content['cont'];//文字内容 （数组类型）
	var time = content['time'];//消息发送时间

	if(content['senderType']==0){
		sendBy = "you";
	}else if(content['senderType']==1){
		sendBy = "me";
	}

	if(content['senderType']==2){
		html ="<div class=\"system\"><img src=\"notice.png\"><span>"+time+"</span><div>";
	}
	else if(content['senderType']==3){
		html = "";
	}
	else{
		html ="<div class='chatContent'>"+
				"<div class='chatItem "+sendBy+"'>"+
					"<div class='chatItemInfo'><span class='name'>"+name+"</span><label class='time'>"+time+"</label></div>";
	}

	if(messageType=="0"){
		html+="<div class='chatText'>"+msgCont['text']+"</div>";
	} else if(messageType=="1"){
		html+="<div class='chatText'><img data-role='external' src='img/loading.gif' imgUrl='"+msgCont['url']+"' width='32' height='32' style='cursor: pointer;' onload='LV.loadImg(this);'/></div>";
	} else if(messageType=="2"){
		html+="<div class='chatText'><a href='"+msgCont['url']+"' target='_blank'>"+msgCont['text']+"</a></div";
	} else {
		alert("对不起！没有该文字类型！");
	}
	html+="</div></div>";

	UT.appendHtmlToHistory(html);
};

LV.SendMedia= function(content,fromHistoryTab){
	var sendBy = content['senderType']=="0"?"you":"me";//谁发的消息
	var messageType = content['msgType'];//文字消息类型：0 语音, 1 视频, 2 音乐
	var name = content['name'];//发送着姓名
	var msgCont = content['cont'];//消息内容 （数组类型）
	var time = content['time'];//消息发送时间
	var urlParams = UT.URLToParams(msgCont["mediaUrl"]);
	var voice_long = eval(msgCont['mediaTime']*5+60);
	var appendId = "";
	if(voice_long>360){
		voice_long = 360;
	}
	var chatContent = UT.createNode("div",{},"chatContent");
	var chatItem = UT.createNode("div",{},"chatContent "+sendBy);
	var chatText = UT.createNode("div",{},"chatText");
	if(messageType=="0"){
		var cloudBody = UT.createNode("div",{"id":"cloudBody","url":msgCont['mediaUrl'],"sendBy":sendBy,"time":msgCont['mediaTime']},"cloudBody forVoice");
		cloudBody.innerHTML = "<div class='cloud_bg top'><div class='cloud_bg_l'></div><div class='cloud_bg_m'></div><div class='cloud_bg_r'></div></div>"+
								"<div class='cloud_bg middle cloudContent'><em class='jiao'></em> <span id='voice"+new Date().getTime()+"' class='icoVoice stop'></span> <span class='voice_long'>"+msgCont['mediaTime']+"\"</span><em class='noPlayed'></em></div>"+
								"<div class='cloud_bg bottom'><div class='cloud_bg_l'></div><div class='cloud_bg_m'></div><div class='cloud_bg_r'></div></div>"
		$(cloudBody).css("width",voice_long);
		$(cloudBody).unbind().bind("click",function(){
				LV.playVoice(this);
			}
		);
		appendId = "voice_" + urlParams['id'];
	} else if(messageType=="1"){
		var mediaImgUrl = msgCont['mediaImgUrl'].replace(/\&amp;/g, "&");
		var cloudBody = UT.createNode("div",{id:"cloudBody"},"cloudBody forVideo");
		var cloud_bg_top = UT.createNode("div",{},"cloud_bg top");
		cloud_bg_top.innerHTML = "<div class='cloud_bg_l'></div><div class='cloud_bg_m'></div><div class='cloud_bg_r'></div>";
		
		var cloud_bg_mid = UT.createNode("div",{},"cloud_bg middle cloudContent");
		cloud_bg_mid.innerHTML = "<em class='jiao'></em>";
		var video = UT.createNode("div",{id:"video"},"videoPanel");
		var wxVideoBoxAction = UT.createNode("div",{style:"display:none"},"wxVideoBoxAction");
		$(wxVideoBoxAction).css("display","none");
		var wxVideoBoxFold = UT.createNode("a",{id:"wxVideoBoxFold",imgUrl:mediaImgUrl},"video_switch");
		$(wxVideoBoxFold).bind("click",function(){
			LV.stopVideo(this);
		});
		wxVideoBoxFold.innerHTML="<i class='icon14_common switch_gray'></i>收起";
		wxVideoBoxAction.appendChild(wxVideoBoxFold);
		var flashContent = UT.createNode("div",{id:"video"+new Date().getTime()},"flashContent");
		var imageBorder = UT.createNode("img",{style:"width:160px;height100px;",src:mediaImgUrl,width:"160",height:"100"},"imageBorder");
		var wx_ico_video = UT.createNode("span",{url:msgCont["mediaUrl"],time:msgCont["mediaTime"]},"wx_ico_video");
		$(wx_ico_video).bind("click",function(){
			LV.playVideo(this);
		});
		var wx_video_duration = UT.createNode("div",{},"wx_video_duration");
		wx_video_duration.innerHTML = msgCont['mediaTime'];
		flashContent.appendChild(imageBorder);
		flashContent.appendChild(wx_ico_video);
		flashContent.appendChild(wx_video_duration);
		video.appendChild(wxVideoBoxAction);
		video.appendChild(flashContent);
		cloud_bg_mid.appendChild(video);
		
		var cloud_bg_bot = UT.createNode("div",{},"cloud_bg bottom");
		cloud_bg_bot.innerHTML="<div class='cloud_bg_l'></div><div class='cloud_bg_m'></div><div class='cloud_bg_r'></div>";
		cloudBody.appendChild(cloud_bg_top);
		cloudBody.appendChild(cloud_bg_mid);
		cloudBody.appendChild(cloud_bg_bot);
		appendId = "video_" + urlParams['id'];
	} else if(messageType=="2"){
		//播放音乐暂时没做
	} else {
		alert("对不起！没有该文字类型！");
	}
	chatText.appendChild(cloudBody);
	if(name&&name.length>0){
		chatItem.innerHTML = "<div class='chatItemInfo'><span class='name'>"+name+"</span><label class='time'>"+time+"</label></div>";
	}
	chatItem.appendChild(chatText);
	chatContent.appendChild(chatItem);
	
	UT.appendHtmlToHistory(chatContent,fromHistoryTab,appendId);
	};

LV.SendImageText= function(content){
	var sendBy = content['senderType']=="0"?"you":"me";//谁发的消息
	var messageType = content['msgType'];//文字消息类型：0 语音, 1 视频, 2 音乐
	var name = content['name'];//发送着姓名
	var msgCont = content['cont'];//消息内容 （数组类型）
	var time = content['time'];//消息发送时间
	var imgTextNum = msgCont['imgTextNum'];//图文行数
	var html = "<div class='chatContent'>"+
				"<div class='chatItem "+sendBy+" imgText'>"+
					"<div class='chatItemInfo'><span class='name'>" + name + "</span><label class='time'>" + time + "</label></div>";
		html+="<div class='chatText'><div class='cloudBody'><div class='top'><div class='top_l_radius'></div><div class='top_r_radius'></div><div class='top_m_radius'></div></div><div class='imgText_content'><div class='imgText_time'>"+time+"</div>";
		
	for(var i = 1;i<=imgTextNum;i++){
		var item = msgCont['imgText'+i]['type'];
		var itemImgUrl = msgCont['imgText'+i]['imgUrl'];
		var itemText = msgCont['imgText'+i]['text'];
		var itemUrl = msgCont['imgText'+i]['url'];
		
		if(i==1){
			html += "<div class='cover_appmsg_item'><a href='"+itemUrl+"' onclick='"+(itemUrl=="javascript:void(0)"?"return false;":"")+"' target='_blank'><img class='imageBorder' src='"+itemImgUrl+"' width='280' height='150'   data-role='external'/></a>"+
		  			"<h4 class='appmsg_title'><a href='"+itemUrl+"' onclick='"+(itemUrl=="javascript:void(0)"?"return false;":"")+"' target='_blank'>"+itemText+"</a></h4></div>";
		}else{
			html += "<div class='appmsg_item'><a href='"+itemUrl+"' onclick='"+(itemUrl=="javascript:void(0)"?"return false;":"")+"' target='_blank'><img class='imageBorder appmsg_thumb' src='"+itemImgUrl+"' width='40' height='40' data-role='external'/></a>"+
					"<h4 class='appmsg_title'><a href='"+itemUrl+"' onclick='"+(itemUrl=="javascript:void(0)"?"return false;":"")+"' target='_blank'>"+itemText+"</a></h4></div>";
		}
	}
	html+="</div><div class='bottom'><div class='bottom_l_radius'></div><div class='bottom_r_radius'></div><div class='bottom_m_radius'></div></div></div></div>";
	html+="</div></div>";
	UT.appendHtmlToHistory(html);
};

window.onload = function(){
	$('.wx_ico_video').unbind().bind("click",function(){
		LV.playVideo(this);
	});
	$('.video_switch').unbind().bind("click",function(){
		LV.stopVideo(this);
	});
	$('.forVoice').unbind().bind("click",function(){
		LV.playVoice(this);
	});
	/*文字类*/
	/*var s = '{type:"0",msgContent:{senderType:"0",msgType:"1",name:"wechat42198792",cont:{text:"",url:"http://multi.live800.com/im/interface/service?cmd=1003&cid=800&pt=wechat&mt=image&id=7ca3d4841c0c45529afc7c9d0b0209b7cebdf10e23e94bc78202644387583845"},time:"2014-03-20 14:27:54"}}';
	setTimeout(function(){LV.sendMessage(s)},2000);*/
	/*图文类*/
	/*var ss = '{type:"2",msgContent:{senderType:"1",msgType:"0",name:"刘ll",cont:{imgTextNum:"2",imgText1:{text:"xzssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssx",imgUrl:"http://multi.live800.com/live800/faqMaterials/800_20140320105133510.jpg",url:"http://www.baidu.com"},imgText2:{text:"xzssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssssx",imgUrl:"http://multi.live800.com/live800/faqMaterials/800_20140320105133510.jpg"}},time:"1970-01-01 13:56:00"}}';
	LV.sendMessage(ss,true);*/
	/*多媒体*/
	var a = '{type:"1",msgContent:{senderType:"1",msgType:"0",name:"张三",cont:{mediaUrl:"http://multi.live800.com/im/interface/service?cmd=1003&cid=800&pt=wechat&mt=voice&id=0a5e107f744c42318f0bc5d0f7661ecceb14a7ee8cf74c34815d19a6ff10acb1",mediaTime:"12"},time:"1325302987"}}';
	var b = '{type:"1",msgContent:{senderType:"0",msgType:"0",name:"李四",cont:{mediaUrl:"http://multi.live800.com/im/interface/service?cmd=1003&cid=800&pt=wechat&mt=voice&id=2bbdd503ddff458ba272932bceb57a3960711797b91d4ab18c1f5f96cda8f670",mediaTime:"60"},time:"1368900801313"}}';
	//LV.sendMessage(a);
	//LV.sendMessage(b);
	
	var c = '{type:"1",msgContent:{senderType:"1",msgType:"1",name:"刘林",cont:{mediaImgUrl:"http://www.baidu.com/img/bdlogo.gif",mediaUrl:"http://multi.live800.com/im/interface/service?cmd=1003&cid=800&pt=wechat&mt=video&id=3b45a0306cc64b0b9db5ee90b749f3f36cdadc620d4243eb988fd10ea211dd29",mediaTime:"12"},time:"1368900801313"}}';
	var d = '{type:"1",msgContent:{senderType:"1",msgType:"1",name:"刘林",cont:{mediaImgUrl:"http://www.baidu.com/img/bdlogo.gif",mediaUrl:"http://multi.live800.com/im/interface/service?cmd=1003&cid=800&pt=wechat&mt=video&id=de99d70e7af84cbca75f76332cde621f85920c9fa2b147c0a24313a40680cd12",mediaTime:"12"},time:"1368900801313"}}';
	//LV.sendMessage(c);
	//LV.sendMessage(d);
	//UT.scrollToBottom();
};
LV.loadImg = function(that){
	var url = that.getAttribute("imgUrl");
	
	if(typeof url == "undefined"||url==""){
		return;
	}
	// 使用占位方式快速获取大小
	LV.imgReady(url, function (width, height) {
		var win_width = (!!(window.attachEvent)||document.compatMode=="CSS1Compat")?document.documentElement.clientWidth:document.body.clientWidth;
		var win_height = (!!(window.attachEvent)||document.compatMode=="CSS1Compat")?document.documentElement.clientHeight:document.body.clientHeight;
		
		this.that = that;
		
		if(width>160){
			var height2 = 160*height/width;
			this.that.setAttribute("width","160");
			this.that.setAttribute("height",height2);
		}else{
			this.that.setAttribute("width",width);
			this.that.setAttribute("height",height);
		}
		this.that.setAttribute("actualsize",width + "," + height);
		this.that.onload=null;
		this.that.src=url;
		
		UT.scrollToBottom();
	}, function () {
		this.that = that;
		this.that.onload=null;
		this.that.src="img/loaderro.png";
		this.that.style.width="63";
		this.that.style.height="48";
		this.that.setAttribute("actualsize", "63,48");
		UT.scrollToBottom();
	});
};
LV.changeSize = function(that){
	var reSize = that.getAttribute("attrResize");
	if(!reSize||"0"==reSize){
		that.setAttribute("attrResize","1");
		var url = that.getAttribute("imgUrl");
		if(typeof url == "undefined"||url==""){
			return;
		}
		// 使用占位方式快速获取大小
		LV.imgReady(url, function (width, height) {
			this.that = that;
			if(width>160&&width<=700){
				this.that.setAttribute("width",width);
				this.that.setAttribute("height",height);
			}else if(width>700){
				var height2 = 700*height/width;
				this.that.setAttribute("width","700");
				this.that.setAttribute("height",height2);
			}
			this.that.onload=null;
			this.that.src=url;
		}, function () {
			this.that = that;
			this.that.onload=null;
		});
	} else if("1"==reSize){
		var width = that.getAttribute("width");
		that.setAttribute("attrResize","0");
		if(width<=160){
			return;
		}
		var height = that.getAttribute("height");
		var height2 = 160*height/width;
		that.setAttribute("width","160");
		that.setAttribute("height",height2);
	}
};
LV.imgReady =function(url, callback, error) {
	var img = new Image(),
		body = document.body;
		
	img.src = url;
	
	// 从缓存中读取
	if (img.complete) {
		return callback(img.width, img.height);
	};
	
	// 加载完毕后方式获取
	img.onload = function () {
		callback(img.width, img.height);
		img.onload = img.onerror = null;
		//body && img.parentNode.removeChild(img);
	};
	
	// 图片加载错误
	img.onerror = function () {
		error && error();
		//body && img.parentNode.removeChild(img);
	};
	
};

function setElementClass(selector,className){
	if(!selector || !className) return;
	var el = $(selector) ;
	if(el && el.length!=0){
		$(el).addClass(className);
	}	
}
//setElementClass("body","over")
