﻿var WorkFlowNo = "";
var trId = "";
var isAdd = true;

function EditWorkFlow(WorkFlowNo) {  
    isAdd = false;

    clearForm(isAdd);

    $.ajax({
        url: "/System/GetWorkFlow",
        type: 'GET',
        cache: false,
        data: { WorkFlowNo: WorkFlowNo },
        success: function (result) {
            if (result.code == 0) {
                $("#WorkFlowNo").val(result.data.WorkFlowNo);
                $("#WorkFlowName").val(result.data.WorkFlowName);
                $("#WorkFlowDescription").val(result.data.WorkFlowDescription);
                if (result.data.IsActive) {
                    $("#IsActive").prop("checked", false);
                }
                else {
                    $("#IsActive").prop("checked", true);
                }
                showWorkFlow();
                $("#WorkFlowName").focus();
            }
            else {
                $("#errorMessage").text(result.message);
            }

        },
        error: function (e) {
            $("#errorMessage").text("查找信息失败");
        }
    });

    return false;
}

function DeleteWorkFlow(WorkFlowNo, WorkFlowName) {

    synConfirm('确定删除流程 [' + WorkFlowName + '] 吗？', function () {
        $.ajax({
            url: "/System/DeleteWorkFlow",
            type: 'POST',
            cache: false,
            data: { WorkFlowNo: WorkFlowNo },
            success: function (result) {
                if (result.code == 0) {
                    location.href = '/System/WorkFlow';
                }
                else {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('流程已有业务数据，无法删除');
            }
        });
    });

    return false;
}

function setTrColor() {
    var spans = $("#tWorkFlow tr span");
    $(spans).each(function (i, v) {
        if ($(v).text() == "已禁用") {
            $(v).parent().parent().css("background-color", "#ddd");
        }
    });
}

$(function () {

    setOperationBtns();

    SetSpanColor();

    setTrColor();

    TdRowOverOut("tWorkFlow");

    //$("#tWorkFlow tr td").click(function () {
    //    if ($(this).index() < 2) {
    //        location.href = '/System/WorkFlowDetail?WorkFlowNo=' + $(this).parent().attr("id");
    //    }
    //});

    $('#divWorkFlow').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#divCanvas').dialog({
        width: 820,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#btnNew').click(function () {
        isAdd = true;
        clearForm(isAdd);
        showWorkFlow();
    });

    $('#btnCancel').click(function () {
        $('#divWorkFlow').dialog('close');
    });
  
    $('#btnSave').click(function () {

        if (isAdd) {
            if (checkRequired('divWorkFlow', 'errorMessage') == false) {
                return;
            }

            $.ajax({
                url: "/System/AddWorkFlow",
                type: 'POST',
                cache: false,
                data: { WorkFlowNo: $("#WorkFlowNo").val(), WorkFlowName: $("#WorkFlowName").val(), WorkFlowDescription: $("#WorkFlowDescription").val(), IsActive: $("#IsActive").prop("checked") },
                success: function (result) {
                    if (result.code == 0) {
                        closeWorkFlow();
                        location.href = "/System/WorkFlow";
                    }
                    else {
                        $("#errorMessage").text(result.message);
                    }
                },
                error: function (e) {
                    $("#errorMessage").text("保存失败.");
                }
            });
        }
        else {
            if (!checkRequired('divWorkFlow', 'errorMessage')) {
                return;
            }
            if (confirm('确定保存修改吗？')) {
                $.ajax({
                    url: "/System/UpdateWorkFlow",
                    type: 'POST',
                    cache: false,
                    data: { WorkFlowNo: $("#WorkFlowNo").val(), WorkFlowName: $("#WorkFlowName").val(), WorkFlowDescription: $("#WorkFlowDescription").val(), IsActive: $("#IsActive").prop("checked") },
                    success: function (result) {
                        if (result.code == 0) {
                            closeWorkFlow();
                            location.href = "/System/WorkFlow";
                        }
                        else {
                            $("#errorMessage").text(result.message);
                        }
                    },
                    error: function (e) {
                        $("#errorMessage").text("保存失败.");
                    }
                });
            }
        }
    });
});

function btnDelete() {
    ClearMessage();
    if (SelectedNumber() == 0) {
        $('.errorSpan').html('请先选择一条纪录');
        return;
    }

    if (SelectedNumber() > 1) {
        $('.errorSpan').html('请只选择一条纪录');
        return;
    }

    DeleteWorkFlow(GetSelectedId());
}

function btnEdit() {
    ClearMessage();
    if (SelectedNumber() == 0) {
        $('.errorSpan').html('请先选择一条纪录');
        return;
    }

    if (SelectedNumber() > 1) {
        $('.errorSpan').html('请只选择一条纪录');
        return;
    }

    EditWorkFlow(GetSelectedId());
}

function btnConfig() {
    ClearMessage();
    if (SelectedNumber() == 0) {
        $('.errorSpan').html('请先选择一条纪录');
        return;
    }

    if (SelectedNumber() > 1) {
        $('.errorSpan').html('请只选择一条纪录');
        return;
    }

    location.href = '/System/WorkFlowDetail?WorkFlowNo=' + GetSelectedId();
}

function ConfigWorkFlow(workFlowNo) {
    location.href = '/System/WorkFlowDetail?WorkFlowNo=' + workFlowNo;
}

function showWorkFlow() {
    $('#divWorkFlow').dialog('open');
}

function closeWorkFlow() {
    $('#divWorkFlow').dialog('close');
}

function clearForm(isAdd) {
    $("input").removeClass("redBorder");
    $("input[type=text]").val("");
    $("textarea").val("");  
    $(".errorSpan").html("");
    if (isAdd) {
        $("#WorkFlowNo").attr("disabled", false);
        $("#WorkFlowNo").focus();
        $("#WorkFlowNo").val($("#AutoNo").val());
    }
    else {
        $("#WorkFlowNo").attr("disabled", true);
        $("#WorkFlowName").focus();
    }   
}

function showCanvas(workflowNo) {
    WorkFlowNo = workflowNo;
    $.ajax({
        url: "/System/GetWorkFlowDetail",
        type: 'POST',
        cache: false,
        data: { WorkFlowNo: workflowNo },
        success: function (result) {
            if (result.code == 0) {
                $('#divCanvas').dialog('open');
                DrawWorkFlowCanvas('canvas', result.data);
            }
            else {
                alert(result.message);
                location.herf = "/System/WorkFlow";
            }
        },
        error: function (e) {
            alert("获取数据失败，请稍后重试");
        }
    });
}


function GotoDetail() {
    location.href = "/System/WorkFlowDetail?WorkFlowNo=" + WorkFlowNo;
}