﻿var Id = "";
var trId = "";
var isAdd = true;

function EditToDo(Id) {
    isAdd = false;

    clearForm(isAdd);

    $.ajax({
        url: "/MySpace/GetToDo",
        type: 'GET',
        cache: false,
        data: { Id: Id },
        success: function (result) {
            if (result.Id != "") {
                console.log(result)
                $("input[name='Status']").prop("checked", false);  //根据Value值设置Radio为选中状态

                $("input[name='Status'][value='" + result.Status + "']").prop("checked", true);  //根据Value值设置Radio为选中状态

                $("#Title").val(result.Title);
                $("#ExecuteDate").val(result.ExecuteDateStr);
                $("#Memo").val(result.Memo);

                $("#Id").val(result.Id);
                showToDo();
            }

        },
        error: function (e) {
        }
    });

    return false;
}



function CompleteToDo(Id) {

    $.ajax({
        url: "/MySpace/CompleteToDo",
        type: 'POST',
        cache: false,
        data: { Id: Id },
        success: function (result) {
            if (result.code == 0) {
                location.href = location.href;
            }
            else {
                alert(result.message);
            }

        },
        error: function (e) {
            alert('操作失败');
        }
    });

    return false;
}

function DeleteToDo(Id) {
    if (!confirm('确定删除吗？')) {
        return;
    }
    $.ajax({
        url: "/MySpace/DeleteToDo",
        type: 'POST',
        cache: false,
        data: { Id: Id },
        success: function (result) {
            if (result.code == 0) {
                location.href = location.href;
            }
            else {
                alert(result.message);
            }

        },
        error: function (e) {
            alert('删除失败');
        }
    });

    return false;
}

$(function () {

    setOperationBtns();
    //AlternativeRow('tToDo');
    setRowColor('tToDo');

    $("#ExecuteDate").datepicker({ dateFormat: 'yy-mm-dd' });
    $("#sb").datepicker({ dateFormat: 'yy-mm-dd' });
    $("#se").datepicker({ dateFormat: 'yy-mm-dd' });

    $("#sb,#se").dblclick(function () {
        $(this).val("");
    });

    $('#divToDo').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#btnNew').click(function () {
        isAdd = true;
        clearForm(isAdd);
        showToDo();
        $("#ToDoName").focus();
    });

    $('#btnCancel').click(function () {
        $('#divToDo').dialog('close');
    });


    $('#btnSave').click(function () {

        if (isAdd) {
            if (checkRequired('divToDo', 'errorMessage') == false) {
                return;
            }

            $.ajax({
                url: "/MySpace/AddToDo",
                type: 'POST',
                cache: false,
                data: $('form').serialize(),
                success: function (result) {
                    if (result.code == 0) {
                        closeToDo();
                        location.reload();
                    }
                    else {
                        $("#errorMessage").text(result.message);
                    }
                },
                error: function (e) {
                    $("#errorMessage").text("保存失败.");
                }
            });
        }
        else {
            if (!checkRequired('divToDo', 'errorMessage')) {
                return;
            }
            if (confirm('确定保存修改吗？')) {
                $.ajax({
                    url: "/MySpace/UpdateToDo",
                    type: 'POST',
                    cache: false,
                    data: $('form').serialize(),
                    success: function (result) {
                        console.log(result);
                        if (result.code == 0) {
                            closeToDo();                            
                            location.reload();                            
                        }
                        else {
                            $("#errorMessage").text(result.message);
                        }
                    },
                    error: function (e) {
                        $("#errorMessage").text("保存失败.");
                    }
                });
            }
        }
    });
});

function setRowColor(t) {
    trs = $("#" + t).find("tr");
    $(trs).each(function (i, v) {
        if (i == 0) {
            return;
        }
        console.log(v);
        console.log($(v).find("td")[3]);
        if ($($(v).find("td")[3]).text() == "待办") {
            $($(v).find("td")[3]).addClass("todo-status-1");
        }
        else if ($($(v).find("td")[3]).text() == "已完结") {
            $($(v).find("td")[3]).addClass("todo-status-2");
        }
    });
}
function showToDo() {
    $('#divToDo').dialog('open');
}

function closeToDo() {
    $('#divToDo').dialog('close');
}

function clearForm() {
    $("input").removeClass("redBorder");
    $("#ExecuteDate").val("");
    $("#Title").val("");
    $("#Memo").val("");
    $(".errorSpan").html("");
    $("input[name='Status'][value=1]").prop("checked", true);  //根据Value值设置Radio为选中状态
}
