﻿var nowDay = new Date();
var cMonth = nowDay.getMonth();
var cYear = nowDay.getYear() + 1900;

function addToDo(date) {
    showToDo(date);
}


$(function () {
    changeMonth();

    $("#ExecuteDate").datepicker({ dateFormat: 'yy-mm-dd' });

    $('#divToDo').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    //$("#btnSearch").click(function () {
    //    location.href = "/MySpace/ToDoList";
    //});

    $("#btnNew").click(function () {
        location.href = "/MySpace/ToDoList";
    });

    $('#btnCancel').click(function () {
        $('#divToDo').dialog('close');
    });

    $('#btnSave').click(function () {
        console.log(1);
        if (checkRequired('divToDo', 'errorMessage') == false) {

            return;
        }

        $.ajax({
            url: "/MySpace/AddToDo",
            type: 'POST',
            cache: false,
            data: $('form').serialize(),
            success: function (result) {
                if (result.code == 0) {
                    closeToDo();
                    changeMonth();
                }
                else {
                    $("#errorMessage").text(result.message);
                }
            },
            error: function (e) {
                $("#errorMessage").text("保存失败.");
            }
        });


    });
});

function preMonth() {
    if (cMonth == 0) {
        cYear--;
        cMonth = 11;
    }
    else {
        cMonth--;
    }

    changeMonth();
}

function nextMonth() {
    if (cMonth == 11) {
        cYear++;
        cMonth = 0;
    }
    else {
        cMonth++;
    }

    changeMonth();
}

function changeMonth() {
    $("#calendar").calendarWidget({
        month: cMonth,
        year: cYear
    });
}


function showToDo(date) {
    clearForm();
    $("#ExecuteDate").val(date);
    $('#divToDo').dialog('open');
}

function closeToDo() {
    $('#divToDo').dialog('close');
}

function clearForm() {
    $("input").removeClass("redBorder");
    $("#ExecuteDate").val("");
    $("#Title").val("");
    $("#Memo").val("");
    $(".errorSpan").html("");
    $("input[name='Status'][value=1]").prop("checked", true);  //根据Value值设置Radio为选中状态
}

