﻿function EditTechnic(Id, Name,Memo) {

    ClearErrorMsg();    
    $("#Name").val(Name);
    $("#Id").val(Id);
    $("#Memo").val(Memo);
    showTechnic();  
}

function DeleteTechnic(Id) {

    ClearErrorMsg();     

    synConfirm("确定删除吗？", function () {
        $.ajax({
            url: "/Warehouse/DeleteTechnic",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    $("#tTechnic").find("tr[id='" + Id + "']").remove();
                }
                else if (result.code==1) {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('删除失败：该工艺已和材料关联，无法删除');
            }
        });
    });    

    return false;
}

$(function () {

    setOperationBtns();
   
    TdRowOverOutSpecify("tTechnic");
    TdRowOverOut("tTechnic");

    $('#divTechnic').dialog({
        width:460,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#btnNew').click(function () {
        $("#Name").val('');
        $("#Id").val('');
        $("#Memo").val('');
        showTechnic();        
    });

    


    $('#btnSave').click(function () {

        if (!$("#Id").val()) {
            if (checkRequired('divTechnic', 'errorMessage') == false) {
                return;
            }
 
            synConfirm("确定保存吗？", function () {

                $.ajax({
                    url: "/Warehouse/TechnicAdd",
                    type: 'POST',
                    cache: false,
                    data: {
                        Name: $("#Name").val(),
                        Memo: $("#Memo").val()

                    },
                    success: function (result) {
                        if (result.code == 0) {
                            closeTechnic();                          
                            location.href = "/Warehouse/Technic";
                        }
                        else {
                            SetErrorMsg(result.message,"divTechnic");
                        }
                    },
                    error: function (e) {                        
                        SetErrorMsg("保存失败", "divTechnic");
                    }
                })
            });     
        }
        else {
            if (!checkRequired('divTechnic', 'errorMessage')) {
                return;
            }

            synConfirm("确定保存修改吗？", function () {
                $.ajax({
                    url: "/Warehouse/TechnicUpdate",
                    type: 'POST',
                    cache: false,
                    data: {
                        Id: $("#Id").val(),
                        Name: $("#Name").val(),
                        Memo: $("#Memo").val()
                    },
                    success: function (result) {
                        if (result.code == 0) {
                            closeTechnic();
                            location.href = "/Warehouse/Technic";
                        }
                        else {
                            SetErrorMsg(result.message, "divTechnic");                             
                        }
                    },
                    error: function (e) {
                        SetErrorMsg("保存失败.","divTechnic");
                    }
                });
            });

           
        }
    });
});

function showTechnic() {
    ClearErrorMsg();
    $('#divTechnic').dialog('open');
}

function closeTechnic() {
    $('#divTechnic').dialog('close');
}
 
 