﻿function EditSupplier(Id) {

    clearForm();

    $.ajax({
        url: "/Warehouse/GetSupplier",
        type: 'GET',
        cache: false,
        data: { Id: Id },
        success: function (result) {
            if (result.code == 0) {
                $("#Id").val(result.data.Id);
                $("#Name").val(result.data.Name);
                $("#Contact").val(result.data.Contact);
                $("#Phone").val(result.data.Phone);
                $("#Mobile").val(result.data.Mobile);
                $("#Email").val(result.data.Email);
                $("#Memo").val(result.data.Memo);
                $("#Bank").val(result.data.Bank);
                $("#BankAccount").val(result.data.BankAccount);
                $("#BankAccountName").val(result.data.BankAccountName);


                showSupplier();
            }

        },
        error: function (e) {
        }
    });

    return false;
}



function DeleteSupplier(Id) {

    ClearErrorMsg();

    synConfirm("确定删除吗？", function () {
        $.ajax({
            url: "/Warehouse/DeleteSupplier",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    $("#tSupplier").find("tr[id='" + Id + "']").remove();
                }
                else {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('删除失败：该供应商已产生业务数据，无法删除');
            }
        });
    });

    return false;
}

$(function () {

    setOperationBtns();

    TdRowOverOut("tSupplier");

    $('#divSupplier').dialog({
        width: 600,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });


    $('#btnNew').click(function () {
        clearForm();

        showSupplier();
    });




    $('#btnSave').click(function () {


        if (checkRequired('divSupplier', 'errorMessage') == false) {
            return;
        }


        synConfirm("确定保存吗？", function () {

            $.ajax({
                url: "/Warehouse/SaveSupplier",
                type: 'POST',
                cache: false,
                data: {
                    Id: $("#Id").val(),
                    Name: $("#Name").val(),
                    Contact: $("#Contact").val(),
                    Phone: $("#Phone").val(),
                    Mobile: $("#Mobile").val(),
                    Email: $("#Email").val(),
                    Memo: $("#Memo").val(),
                    Bank: $("#Bank").val(),
                    BankAccount: $("#BankAccount").val(),
                    BankAccountName: $("#BankAccountName").val()
                },
                success: function (result) {
                    if (result.code == 0) {
                        closeSupplier();
                        location.href = location.href.replace("#", "");
                    }
                    else {
                        SetErrorMsg(result.message, "divSupplier");
                    }
                },
                error: function (e) {
                    SetErrorMsg("保存失败", "divSupplier");
                }
            })
        });


    });
});

function showSupplier() {
    $('#divSupplier').dialog('open');
}

function closeSupplier() {
    $('#divSupplier').dialog('close');
}

function clearForm() {
    ClearErrorMsg();
    $("#divSupplier input").removeClass("redBorder");
    $("#divSupplier input[type=text]").val("");
    $("#divSupplier textarea").val("");
    $("#divSupplier input[type=checkbox]").prop("checked", true);
    $("#Id").val("");
}


function downExcel() {
    location.href = "/Warehouse/GetSupplierExcel?sKeywords=" + $("#sKeywords").val();
}