﻿var allMaterial = [];
var stockOutDetails = [];

function constructDetail() {

    if ($("#StockOutDetails").val()) {
        var oDetails = eval($("#StockOutDetails").val());

        $(oDetails).each(function (i, v) {

            eval("var d=" + v.Detail + ";");
            stockOutDetails.push({
                Id: v.Id,
                MaterialId: v.MaterialId,
                Number: v.Number,
                Memo: v.Memo,
                UnitName: v.UnitName
            });
        });

        generateDetailTable();
    }
}

function addStockOutDetailRow(rowData) {

    if (rowData == null) {
        rowData = {
            Id: '0',
            MaterialId: '',
            Number: '',
            Memo: '',
            UnitName: ''
        };
    }

    var tBody = $("#simpleStockOutTr");
    var tr, td, input, select, hidden;

    tr = $("<tr></tr>");

    $("<td><input type='hidden' id='Id' value='" + rowData.Id + "'></input></td>").appendTo(tr);

    select = $("#Material").clone();
    select.attr("id", "MaterialId");
    select.val(rowData.MaterialId);
    td = $("<td></td>");
    select.appendTo(td);
    td.appendTo(tr);


    td = $("<td id='UnitName' class='text-center'></td>");
    td.html(rowData.UnitName);

    td.appendTo(tr);

    input = $("<input type='text' id='Number' class='number' value='" + rowData.Number + "'></input>");
    td = $("<td></td>");
    input.appendTo(td);
    td.appendTo(tr);

    input = $("<input type='text' id='Memo' value='" + rowData.Memo + "'></input>");
    td = $("<td></td>");
    input.appendTo(td);
    td.appendTo(tr);

    tr.appendTo(tBody);

    bindEvents();
}

function copyDetail() {
    var trs = $("#simpleStockOutTr .tr-selected");
    if ($(trs).length == 0) {
        alert("请先选择要复制的行");
        return;
    }

    var tr = trs.clone();
    var td = tr.find("td:eq(1)");
    var sel = td.find("select");
    console.log(sel);
    td.empty();
    $(sel).appendTo(td);
    $(tr).appendTo($("#simpleStockOutTr")); 

    $($("#simpleStockOutTr tr").last()).attr("id", "0");
    $($("#simpleStockOutTr tr").last()).removeClass("tr-selected");

    bindEvents();

    calcRealAmount();
}

function deleteDetail() {

    if ($("#simpleStockOutTr tr").length == 1) {
        alert("订单至少必须包含一个明细，无法删除。");
        return;
    }

    var trs = $("#simpleStockOutTr .tr-selected");
    if ($(trs).length == 0) {
        alert("请先选择要删除的行");
        return;
    }

    $(trs).remove();

    calcRealAmount();
}

function generateDetailTable() {
    var tBody = $("#simpleStockOutTr");
    tBody.empty();

    $(stockOutDetails).each(function (i, v) {
        addStockOutDetailRow(v);
    });
}

function bindEvents() {

    $(".number").inputmask({ 'mask': "9{0,9}[.9{0,2}]", greedy: false });

    // select a row
    $("#simpleStockOutDetail td").unbind("click").click(function () {
        $("#simpleStockOutDetail .tr-selected").removeClass("tr-selected");
        $(this).parent().addClass("tr-selected");
    });

    $("#simpleStockOutDetail #MaterialId").unbind("change").change(function () {
        MaterialChange(this);
    });

    $("#simpleStockOutDetail #MaterialId").select2();

    // when the column is narrow,it is usefual to show the tip
    $("#simpleStockOutDetail #Memo").hover(function () {
        $(this).attr("title", $(this).val());
    });
}

function GetMaterialAndUnit() {

    $.blockUI({ message: '<h5>加载中...</h5>' });

    $.ajax({
        url: "/Warehouse/GetGroupedMaterial?stockOutId=" + $("#stock #Id").val(),
        type: 'GET',
        cache: false,
        dataType: 'json',
        async: false,
        success: function (result) {
            console.log(result.data);
            var selMaterial = $("#Material");
            $("<option value=''>&nbsp;</option>").appendTo(selMaterial);
            var optGroup, opt;
            $(result.data).each(function (i, v) {

                optGroup = $("<optgroup label='排序'></optgroup>");
                optGroup.attr("label", v.Name);

                $(v.List).each(function (i, v) {
                    opt = $("<option></option>");
                    opt.text(v.Name);
                    opt.attr("value", v.Id);
                    opt.appendTo(optGroup);

                    allMaterial.push({ Id: v.Id, UnitName: v.UnitName });
                });

                optGroup.appendTo(selMaterial);

            });
            $.unblockUI();
        },
        error: function (e) {
            $.unblockUI();
        }
    });
}

$(function () {

    $("#simpleStockOutDetail").resizableColumns({
        store: window.store
    });

    GetMaterialAndUnit();
    constructDetail();
    generateDetailTable();

    $(".number,.amount,.price").each(function () {

        if ($(this).val() == "0") {
            $(this).val("");
        }
    });

    $('#btnNewDetail').click(function () {
        addStockOutDetailRow(null);
    });

    $('#btnCopyDetail').click(function () {
        copyDetail(null);
    });

    $('#btnDeleteDetail').click(function () {
        deleteDetail();
    });

    if ($("#stock #Id").val() == "0") {
        $("#trPrePaid").css("display", '');
    }

    $(".text-date").attr("readonly", "readonly");
    $(".text-date").datepicker({ dateFormat: 'yy-mm-dd' });


    $('#divSupplier').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#divMaterial').dialog({
        width: 600,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#btnCancel').click(function () {

        synConfirm("确定要放弃修改吗？", function () {
            window.history.go(-1);
        });
    });

    $('#btnSave').click(function () {

        ClearErrorMsg();

        if (checkRequired('divStockOut', 'errorMessage') == false) {
            return;
        }

        var tbody = $("#simpleStockOutTr tr");

        if (tbody.length < 1) {
            return SetErrorMsg('至少应该包含1个明细');
        }


        var checkResult = true;
        tbody.each(function (i, v) {
            if (!$(v).find("#MaterialId").val()) {
                $(v).find("#MaterialId").addClass("redBorder");
                checkResult = false;
            }

            if (!$(v).find("#Number").val()) {
                $(v).find("#Number").addClass("redBorder");
                checkResult = false;
            }

        });

        if (!checkResult) {
            return SetErrorMsg_Required();
        }

        var stockOutDetails = GetStockOutDetails();


        $.blockUI({ message: '<h5>保存中，请稍候...</h5>' });

        if ($("#stock #Id").val() == "0") {

            $.ajax({
                url: "/Warehouse/StockOutAdd",
                type: 'POST',
                cache: false,
                dataType: 'json',
                data: { BasicInfo: GetBasicInfo(), stockOutDetails: JSON.stringify(stockOutDetails) },
                success: function (result) {
                    $.unblockUI();
                    if (result.code == 0) {
                        if ($("#BackURL").val()) {
                            location.href = $("#BackURL").val();
                        }
                        else {
                            location.href = "/Warehouse/StockOut";
                        }
                    }
                    else if (result.code == 1) {
                        SetErrorMsg(result.message);
                    }
                    else {
                        return SetErrorMsg_Save_Failed();
                    }
                },
                error: function (e) {
                    $.unblockUI();
                    return SetErrorMsg_Save_Failed();
                }
            });

        }
        else {
            var additonMessage = "";

            $.ajax({
                url: "/Warehouse/StockOutUpdate",
                type: 'POST',
                cache: false,
                dataType: 'json',
                data: { BasicInfo: GetBasicInfo(), stockOutDetails: JSON.stringify(stockOutDetails) },
                success: function (result) {
                    $.unblockUI();
                    if (result.code == 0) {
                        if ($("#BackURL").val()) {
                            location.href = $("#BackURL").val();
                        }
                        else {
                            location.href = "/Warehouse/StockOut";
                        }
                    }
                    else if (result.code == 1) {
                        SetErrorMsg(result.message);
                    }
                    else {
                        return SetErrorMsg_Save_Failed();
                    }
                },
                error: function (e) {
                    $.unblockUI();
                    return SetErrorMsg_Save_Failed();
                }
            });
        }
    });

    $('#divMaterial #btnSaveMaterial').click(function () {

        SaveQuickMaterial();
    });

    if ($("#stock #Id").val() == "0" && $("#simpleStockOutTr tr").length < 1) {      
        addStockOutDetailRow(null);
    }

    $('#divMaterial #Id').val("0");
});

function MaterialChange(m) {

    var materialId = $(m).val();

    if (materialId) {
        $(allMaterial).each(function (i, v) {
            if (v.Id == materialId) {
                $(m).parent().parent().find("#UnitName").html(v.UnitName);
                return false;
            }
        });
    }
} 

function GetStockOutDetails() {
    var result = [];
    $("#simpleStockOutTr tr").each(function (i, v) {

        result.push({
            Id: $(v).find("#Id").val(),
            MaterialId: $(v).find("#MaterialId").val(),
            Number: $(v).find("#Number").val(),
            Memo: $(v).find("#Memo").val(),
        });

    });

    return result;
}

function GetBasicInfo() {
    var result = {};
    result.Id = $("#stock #Id").val();
    result.Type = $("#Type").val();
    result.StockOutTime = $("#StockOutTime").val();
    result.Operator = $("#Operator").val();
    result.Memo = $("TextArea[id='Memo']").val();

    return JSON.stringify(result);
}

function newId() {
    var guid = "g";
    for (var i = 1; i <= 32; i++) {
        var n = Math.floor(Math.random() * 16.0).toString(16);
        guid += n;
        if ((i == 8) || (i == 12) || (i == 16) || (i == 20))
            guid += "";
    }
    return guid;
}