﻿var Id;

function EditStockOut(Id) {
    location.href = "/Warehouse/StockOutEdit?id=" + Id + "&GoBackURL=" + GetGoBackUrl();    
}

function ApproveStockOut(Id) {
    synConfirm("确定审核吗？<br/>提示：审核后库存信息将被自动更新。", function () {
        $.ajax({
            url: "/Warehouse/ApproveStockOut",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {                    
                    location.reload();
                }
                else {
                    alert(result.message);
                }
            },
            error: function (e) {
                alert('审核失败，请稍后再试');
            }
        });
    });   
}

function UnApproveStockOut(Id) {
    synConfirm("确定反审核吗？<br/>提示：反审核后库存信息将被自动更新。", function () {
        $.ajax({
            url: "/Warehouse/UnApproveStockOut",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    location.reload();
                }
                else {
                    alert(result.message);
                }
            },
            error: function (e) {
                alert('反审核失败，请稍后再试');
            }
        });
    });     
}

function GetGoBackUrl() {
    var url = {};
    url.root = "/Warehouse/StockOut";
    url.paras = [];
    
    if ($("#sType").val() != "") {
        url.paras.push({ name: "sType", value: $("#sType").val() });
    }
    if ($("#sStatus").val() != "") {
        url.paras.push({ name: "sStatus", value: $("#sStatus").val() });
    }
    if ($("#sEndDate").val() != "") {
        url.paras.push({ name: "sEndDate", value: $("#sEndDate").val() });
    }
    if ($("#sBeginDate").val() != "") {
        url.paras.push({ name: "sBeginDate", value: $("#sBeginDate").val() });
    }
    if ($("#sKeywords").val() != "") {
        url.paras.push({ name: "sKeywords", value: $("#sKeywords").val() });
    }

    return JSON.stringify(url);
}

function DeleteStockOut(Id) {

    ClearErrorMsg();     

    synConfirm("确定删除吗？<br/>提示：与该出库单相关的其它记录将一并删除。", function () {
        $.ajax({
            url: "/Warehouse/DeleteStockOut",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    $("#tStockOut").find("tr[id='" + Id + "']").remove();
                }
                else {
                    alert(result.message);
                }
            },
            error: function (e) {
                alert('删除失败，请稍后再试');
            }
        });
    });    

    return false;
}

$(function () {

    setOperationBtns();

    TdRowOverOut("tStockOut");     
    SetSpanColor("tStockOut");

    $("#tStockOut tr td").click(function () {
        if ($(this).hasClass("td-last") || $(this).hasClass("td-checkbox")) {
            return;
        }
        else {
            ShowStockOutDetail($(this).parent().attr("id"));
        }
    }); 

    $('#btnNew').click(function () {       
        location.href = "/Warehouse/StockOutEdit?GoBackURL=" + GetGoBackUrl();     
    });

    GetGroupedMaterial("sMaterial", $("#hiddenMaterial").val());
    $("#sMaterial").select2();
});