﻿$(function () {

    $("#companyName").focus();  
  

    $("#btnSave").click(function () {
        ClearErrorMsg();
        if (!$("#companyName").val()) {
            $("#companyName").addClass("redBorder");
            return SetErrorMsg("请填写公司名称");
        }

        if (!$("#userName").val()) {
            $("#userName").addClass("redBorder");
            return SetErrorMsg("请填写您的姓名");
        }

        if (!$("#email").val()) {
            $("#email").addClass("redBorder");
            return SetErrorMsg("请填写您的Email");
        }

        if (!IsEmail($("#email").val())) {
            $("#email").addClass("redBorder");
            return SetErrorMsg("Email格式错误");
        }

        if (!$("#password").val()) {
            $("#password").addClass("redBorder");
            return SetErrorMsg("请填写登录密码");
        }

        if ($("#password").val().length < 6) {
            $("#password").addClass("redBorder");
            return SetErrorMsg("密码至少6位字符");
        }
 
        $.blockUI({ message: '<h5>处理中，请稍候...</h5>' });
        //$("#btnRegister").attr('disabled', 'disabled');
        $.ajax({
            url: "/Account/Register2",
            type: 'POST',
            cache: false,
            data: {
                companyName: $("#companyName").val(),
                userName: $("#userName").val(),
                email: $("#email").val(),
                password: $("#password").val()
            },
            success: function (result) {
                $.unblockUI();
                if (result.code == 0) {
                    location.href = "/Account/Login?id=" + $("#loginId").html() + "&welcome=1";

                }
                else if (result.code == 1) {
                    SetErrorMsg(result.message);
                }
                else {
                    SetErrorMsg("注册失败，请稍后再试");
                }
            },
            error: function (e) {
                SetErrorMsg("注册失败，请稍后再试");
                $.unblockUI();
            }
        });
    });    
}); 