﻿var smsTimeRemain = 60;
var smsInterval = null;

$(function () {

    $("#mobile").focus();
   
    $("#agree").change(function () {
        if ($("#agree").prop("checked")) {
            $("#btnNext").removeAttr("disabled");
            $("#btnNext").removeClass("btn-disabled");
        }
        else {
            $("#btnNext").attr("disabled", "disabled");
            $("#btnNext").addClass("btn-disabled");
           
        }
    });

    $("#btnSend").click(function () {
        
        ClearErrorMsg();
        if (!$("#mobile").val()) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("请输入手机号");
        }

        if (!IsMobile($("#mobile").val())) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("手机号格式不对");
        }

        $("#btnSend").prop("disabled", "disabled");
        $.ajax({
            url: "/Home/GetValidateCode",
            type: 'POST',
            cache: false,
            data: { mobile: $("#mobile").val(), type: 1 },
            success: function (result) {
                $("#btnSend").removeAttr("disabled");
                if (result.code == 0) {
                    
                    smsTimeRemain = 60; 
                    $("#btnSend").prop("disabled", "disabled");                    

                    smsInterval = setInterval(
                        function () {
                            if (smsTimeRemain == 1) {                               
                                $("#btnSend").text("发送验证码");
                                $("#btnSend").removeAttr("disabled");
                                if (smsInterval != null) {
                                    clearInterval(smsInterval);
                                }
                            }
                            else {
                                smsTimeRemain--;                              
                                $("#btnSend").text(smsTimeRemain + "秒后重发");
                            }
                            

                        }, 1000);


                    $("#btnSend").prop("disabled", "disabled");
                    $("#btnSend").text("60秒后重发");
                }
                else if (result.code == 1) {
                    SetErrorMsg("手机号已被注册");
                }
                else if (result.code == 2) {
                    SetErrorMsg("验证码发送失败，请稍后再试");
                }

            },
            error: function (e) {
                $("#btnSend").removeAttr("disabled");
                SetErrorMsg("验证码发送失败，请稍后再试");
                $.unblockUI();
            }
        });

    });    

    $("#refMobile").blur(function () {
        ClearErrorMsg();
        
        var mobile = $("#refMobile").val();
        if (mobile == "") {
            return;
        }

        if (!IsMobile(mobile)) {
            $("#refMobile").addClass("redBorder");
            return SetErrorMsg("推荐人手机号格式不对");
        }

        $.ajax({
            url: "/Home/GetPartnerNameByMobile",
            type: 'GET',
            data: mobile,
            cache: false,
            dataType: 'json',
            async: false,
            success: function (result) {
                if (result.code == 0) {                   
                }
                else {                    
                    $("#refMobile").addClass("redBorder");
                    SetErrorMsg("推荐人手机号不存在");
                }
            },
            error: function (e) {
                 
            }
        });
    });

    $("#btnNext").click(function () {
        ClearErrorMsg();
        if (!$("#mobile").val()) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("请输入手机号");
        }

        if (!IsMobile($("#mobile").val())) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("手机号格式不对");
        }

        if (!$("#code").val()) {
            $("#code").addClass("redBorder");
            return SetErrorMsg("请输入验证码");
        }
            $.blockUI({ message: '<h5>处理中，请稍候...</h5>' });
            //$("#btnRegister").attr('disabled', 'disabled');
            $.ajax({
                url: "/Account/Register",
                type: 'POST',
                cache: false,
                data: { mobile: $("#mobile").val(), code: $("#code").val(), refMobile: $("#refMobile").val()},
                success: function (result) {
                    $.unblockUI();
                    if (result.code == 0) {
                        location.href = "/Account/Register2";
                       
                    }
                    else if (result.code == 1) {
                        SetErrorMsg("手机号已被注册");
                    }
                    else if (result.code==2) {
                        SetErrorMsg("验证码错误");
                    }
                    else if (result.code == 3) {
                        SetErrorMsg("推荐人手机号不存在");
                    }
                },
                error: function (e) {
                    SetErrorMsg("注册失败，请联系9平米管理员");
                    $.unblockUI();
                }
            });        
    });
}); 