﻿var trId = "";
var isAdd = true;

function EditPriceUnit(Id) {
    ClearErrorMsg();
    isAdd = false;
    clearForm(isAdd, "divPriceUnit");
    $.ajax({
        url: "/System/GetPriceUnit",
        type: 'GET',
        cache: false,
        data: { Id: Id },
        success: function (result) {
            if (result.code == 0) {
                $("#Name").val(result.data.Name);
                $("#PriceType").val(result.data.PriceType);
                $("#Id").val(result.data.Id);
                showPriceUnit();
            }

        },
        error: function (e) {
        }
    });

    return false;
}

function DeletePriceUnit(Id) {

    synConfirm("确定删除吗？", function () {
        $.ajax({
            url: "/System/DeletePriceUnit",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    location.href = '/System/PriceUnit';
                }
                else {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('删除失败：该数据已被引用，无法删除');
            }
        });
    });

    return false;
}

$(function () {

    setOperationBtns();

    TdRowOverOut("tPriceUnit");

    $('#divPriceUnit').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#btnPriceUnitNew').click(function () {
        isAdd = true;
        $("#Id").val("");
        clearForm(isAdd, "divPriceUnit");
        showPriceUnit();
    });
 
    $('#btnPriceUnitCancel').click(function () {
        $('#divPriceUnit').dialog('close');
    });

    $('#btnPriceUnitSave').click(function () {
        ClearErrorMsg();
        if (isAdd) {
            if (checkRequired('divPriceUnit', 'errorMessagePriceUnit') == false) {
                return;
            }
           
            $.ajax({
                url: "/System/AddPriceUnit",
                type: 'POST',
                cache: false,
                data: $('#formPriceUnit').serialize(),
                success: function (result) {
                    if (result.code == 0) {
                        closePriceUnit();
                        location.href = "/System/PriceUnit";
                    }
                    else {
                        SetErrorMsg(result.message, "divPriceUnit");
                    }
                },
                error: function (e) {
                    SetErrorMsg("保存失败", "divPriceUnit");
                }
            });
        }
        else {
            if (!checkRequired('divPriceUnit', 'errorMessagePriceUnit')) {
                return;
            }

            synConfirm("确定保存修改吗？", function () {
                $.ajax({
                    url: "/System/UpdatePriceUnit",
                    type: 'POST',
                    cache: false,
                    data: $('#formPriceUnit').serialize(),
                    success: function (result) {
                        if (result.code == 0) {
                            closePriceUnit();
                            location.href = "/System/PriceUnit";
                        }
                        else {
                            SetErrorMsg(result.message, "divPriceUnit");
                        }
                    },
                    error: function (e) {
                        SetErrorMsg("保存失败", "divPriceUnit");
                    }
                });
            });


        }
    });
      

});

function showPriceUnit() {
    $('#divPriceUnit').dialog('open');
}

function closePriceUnit() {
    $('#divPriceUnit').dialog('close');
}


function clearForm(isAdd, div) {
    $("#" + div).find("input").removeClass("redBorder");
    $("#" + div).find("input[type=text]").val("");
    $("#" + div).find("textarea").val("");

    ClearErrorMsg();
}

