﻿$(function () {

    $(".amount").inputmask({ 'mask': "-{0,1}9{0,9}[.9{0,2}]", greedy: false });

    $('#divCalculate').dialog({
        width: 400,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#divPerformance').dialog({
        width: 400,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#divAdjust').dialog({
        width: 400,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $("#btnCalculate").click(function () {
        $("#calculateMonth").text($("#sMonthSn").val());
        $('#divCalculate').dialog("open");
    });

    $("#btnDownload").click(function () {
        location.href = "/HR/GetPayrollExcel?MonthSn=" + $("#sMonthSn").val();
    });

});

function ChangePerformance(id, employeeName, amount) {
    $("#Id").val(id);
    $("#pEmployeeName").text(employeeName);
    $("#pCalculateMonth").text($("#sMonthSn").val());
    $("#pAmount").val(amount);
    $('#divPerformance').dialog("open");

}
function ChangeAdjust(id, employeeName, adjustReason, adjustAmount) {
    $("#Id").val(id);(id);
    $("#aEmployeeName").text(employeeName);
    $("#aCalculateMonth").text($("#sMonthSn").val());
    $("#aReason").val(adjustReason);
    $("#aAmount").val(adjustAmount);
    $('#divAdjust').dialog("open");
}

function SetPerformance() {
    ClearErrorMsg("divPerformance");

    if (checkRequired('divPerformance', 'error-msg') == false) {
        return;
    }

    $.ajax({
        url: "/HR/SetPerformance",
        type: 'POST',
        cache: false,
        data: {
            id: $("#Id").val(), amount: $("#pAmount").val() },
        success: function (result) {
       
            if (result.code == 0) {
                location.href = "/HR/Payroll?sMonthSn=" + $("#sMonthSn").val() + "&page=" + $("#nspagerselect").val() ;
            }
            else {
                SetErrorMsg("保存失败，请稍后再试","divPerformance");
            }

        },
        error: function (e) {           
            SetErrorMsg("保存失败，请稍后再试", "divPerformance");
        }
    });
}

function Delete(id, employeeName) {
    if (!confirm("确定删除 " + employeeName + " 的工资记录吗？")) {
        return;
    }

    $.ajax({
        url: "/HR/DeleteEmployeeSalary",
        type: 'POST',
        cache: false,
        data: {
            id: id
        },
        success: function (result) {

            if (result.code == 0) {
                location.href = "/HR/Payroll?sMonthSn=" + $("#sMonthSn").val() + "&page=" + $("#nspagerselect").val();
            }
            else {
                SetErrorMsg("删除失败，请稍后再试", "divAdjust");
            }

        },
        error: function (e) {
            SetErrorMsg("删除失败，请稍后再试", "divAdjust");
        }
    });
}


function SetAdjust() {
    ClearErrorMsg("divAdjust");

    if (checkRequired('divAdjust', 'error-msg') == false) {
        return;
    }

    if ($("#aAmount").val() != "" && $("#aReason").val() == "") {
        $("#aReason").addClass("redBorder");
        SetErrorMsg("请输入调整原因", "divAdjust");
        return;
    }

    $.ajax({
        url: "/HR/SetAdjust",
        type: 'POST',
        cache: false,
        data: {
            id: $("#Id").val(), reason: $("#aReason").val(), amount: $("#aAmount").val()
        },
        success: function (result) {

            if (result.code == 0) {
                location.href = "/HR/Payroll?sMonthSn=" + $("#sMonthSn").val() + "&page=" + $("#nspagerselect").val() ;
            }
            else {
                SetErrorMsg("保存失败，请稍后再试", "divAdjust");
            }

        },
        error: function (e) {
            SetErrorMsg("保存失败，请稍后再试", "divAdjust");
        }
    });
}

function CalculateSalary() {
    ClearErrorMsg();
    $('#divCalculate').dialog("close");

    $.blockUI({ message: '<h5>计算中...</h5>' });

    $.ajax({
        url: "/HR/GeneratePayroll",
        type: 'POST',
        cache: false,
        data: { month: $("#sMonthSn").val(), type: $("input[name='calculateType']:checked").val() },
        success: function (result) {
            $.unblockUI();
            if (result.code == 0) {  
                location.href = "/HR/Payroll?sMonthSn=" + $("#sMonthSn").val()+"&message=" + result.data;
            }
            else {
                SetErrorMsg("工资计算错误，请稍后再试");
            }
                
            
        },
        error: function (e) {
            $.unblockUI();
            SetErrorMsg("工资计算错误，请稍后再试", "divCalculate");
        }
    });

}

