﻿$(function () {
    var sProvince = $("#province");
    var sCity = $("#city");
    $(cityList).each(function (i, v) {        
        var option = $("<option value='" + v.pc + "'>" + v.pn + "</option>");
        option.appendTo(sProvince);
    });

    sProvince.change(function () {
        sCity.empty();
        $("<option value=''>市/区</option>").appendTo(sCity);

        var province = sProvince.val();
        if (province != "") {
            $(cityList).each(function (i, v) {
                if (v.pc == province) {

                    $(v.cs).each(function (j, s) {
                        var option = $("<option value='" + s.cc + "'>" + s.cn + "</option>");
                        option.appendTo(sCity);

                    });

                    return false;
                }               
            });
        }
    });    
    
    $("#referenceMobile").blur(function () {
        ClearErrorMsg();
        $("#mobileCheck").css("display", "none");
        var mobile = $("#referenceMobile").val();
        if (mobile == "") {
            return;
        }

        if (!IsMobile(mobile)) {
            $("#referenceMobile").addClass("redBorder");
            return SetErrorMsg("推荐人手机号格式不对");
        }

        $.ajax({
            url: "/Home/GetPartnerNameByMobile",
            type: 'GET',
            data: { mobile: mobile },
            cache: false,
            dataType: 'json',
            async: false,
            success: function (result) {
                if (result.code == 1) {                  
                    $("#mobileCheck").css("display", "inline-block");
                }
                else {
                    $("#mobileCheck").css("display", "none");
                    $("#referenceMobile").addClass("redBorder");
                    SetErrorMsg("推荐人手机号错误，请核对。");
                }
            },
            error: function (e) {
                $("#mobileCheck").css("display", "none");
            }
        });
    });

    $("#btnSend").click(function () {

        ClearErrorMsg();

        if (!$("#mobile").val()) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("请输入手机号");
        }

        if (!IsMobile($("#mobile").val())) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("手机号格式不对");
        }

        $("#btnSend").prop("disabled", "disabled");
        $.ajax({
            url: "/Home/GetPartnerValidateCode",
            type: 'POST',
            cache: false,
            data: { mobile: $("#mobile").val(), type: 1 },
            success: function (result) {
                $("#btnSend").removeAttr("disabled");
                if (result.code == 0) {

                    smsTimeRemain = 60;
                    $("#btnSend").prop("disabled", "disabled");

                    smsInterval = setInterval(
                        function () {
                            if (smsTimeRemain == 1) {
                                $("#btnSend").text("发送验证码");
                                $("#btnSend").removeAttr("disabled");
                                if (smsInterval != null) {
                                    clearInterval(smsInterval);
                                }
                            }
                            else {
                                smsTimeRemain--;
                                $("#btnSend").text(smsTimeRemain + "秒后重发");
                            }

                        }, 1000);


                    $("#btnSend").prop("disabled", "disabled");
                    $("#btnSend").text("60秒后重发");
                }
                else if (result.code == 1) {
                    SetErrorMsg("手机号已被注册");
                }
                else if (result.code == 2) {
                    SetErrorMsg("验证码发送失败，请稍后再试");
                }
            },
            error: function (e) {
                $("#btnSend").removeAttr("disabled");
                SetErrorMsg("验证码发送失败，请稍后再试");
                $.unblockUI();
            }
        });
    });

    $("#btnNext").click(function () {
        ClearErrorMsg();

        if ($("#referenceMobile").val() && $("#mobileCheck").css("display") == "none") {
            $("#referenceMobile").addClass("redBorder");
            return SetErrorMsg("推荐人手机号不对，请核对");
        }

        if (!$("#province").val()) {
            $("#province").addClass("redBorder");
            return SetErrorMsg("请选择省份");
        }

        if (!$("#city").val()) {
            $("#city").addClass("redBorder");
            return SetErrorMsg("请选择城市");
        }

        if (!$("#userName").val()) {
            $("#userName").addClass("redBorder");
            return SetErrorMsg("请选择城市");
        }


        if (!$("#email").val()) {
            $("#email").addClass("redBorder");
            return SetErrorMsg("请选择城市");
        }

        if (!$("#mobile").val()) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("请输入手机号");
        }

        if (!IsMobile($("#mobile").val())) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("手机号格式不对");
        }

        if (!$("#code").val()) {
            $("#code").addClass("redBorder");
            return SetErrorMsg("请输入验证码");
        }

        $.blockUI({ message: '<h5>处理中，请稍候...</h5>' });        
        var data = {
            referenceMobile: $("#referenceMobile").val(),
            province: $("#province").val(),
            city: $("#city").val(),
            provinceName: $("#province").find("option:selected").text(),
            cityName: $("#city").find("option:selected").text(),
            userName: $("#userName").val(),
            email: $("#email").val(),
            mobile: $("#mobile").val(),
            password: $("#password").val(),
            code: $("#code").val()
        };
        $.ajax({
            url: "/Home/ApplyPartner",
            type: 'POST',
            cache: false,
            data: data,
            success: function (result) {
                $.unblockUI();
                if (result.code == 0) {
                    location.href = "http://partner.9pm2.com/account/login?type=1&mobile="+data.mobile;
                }
                else if (result.code == 1) {
                    $("#code").addClass("redBorder");
                    SetErrorMsg("验证码错误");
                }
                else if (result.code == 2) {
                    $("#mobile").addClass("redBorder");
                    SetErrorMsg("该手机号已被注册，请更换。");
                }
                else if (result.code == 3) {
                    $("#email").addClass("redBorder");
                    SetErrorMsg("该邮箱已被注册，请更换。");
                }
                else if (result.code == 4) {
                    $("#referenceMobile").addClass("redBorder");
                    SetErrorMsg("推荐人手机号不存在");
                }

            },
            error: function (e) {
                SetErrorMsg("注册失败，请联系9平米管理员");
                $.unblockUI();
            }
        });
    });
});