﻿var DetailArray = new Array();  
var orderTemplate = {};
var allUnits = [];
var trPriceCss;
var allCategory;

function showHistory() {
    $("#divHistory").dialog("open");
}

function getTemplate(type) {

    if (type == 1) {
        trPriceCss = "tr-show";
    }
    else {
        trPriceCss = "tr-hide";
    }

    $.blockUI({ message: '<h5>加载中，请稍后...</h5>' });    
    
    $.ajax({
        url: "/System/GetOriginalTemplate",
        type: 'GET',
        cache: false,
        async: true,
        data: { type: type, historyType:$("#type").val() },
        success: function (result) {           
            if (result.code == 0) {
                DetailArray = result.data;
                allUnits = result.units;
                allCategory = result.allCategory;

                GenerateTemplate();
                  
                generateHistory(result.history);
            }
            else {
                alert("获取模板信息失败");
            }
            $.unblockUI();
        },
        error: function (e) {
            $.unblockUI();
            alert("获取模板信息失败");
        }
    });
}

function generateHistory(data) {
    var list = $("#HistoryList");
    list.empty();
    var tr, td, a;
    $(data).each(function (i, v) {
        
        tr = $("<tr></tr>");
        tr.attr("id", v.No);

        td = $("<td></td>");
        td.html(v.Creator);
        td.appendTo(tr);

        td = $("<td></td>");
        td.html(v.CreateDate);
        td.appendTo(tr);

        td = $("<td></td>");
        a = $("<a href='javascript:void(0)'>恢复到此版本</a>");
        a.click(function () {
            getHistory($("#type").val(), $(this).parent().parent().attr("id"));
        });
        a.appendTo(td);
        
        td.appendTo(tr);

        tr.appendTo(list);
    });
}

function getHistory(type, no) {
   
    $("#divHistory").dialog("close");

    $.blockUI({ message: '<h5>恢复中，请稍后...</h5>' });

    $.ajax({
        url: "/System/GetHistoryTemplate",
        type: 'GET',
        cache: false,
        async: true,
        data: { type: type,no:no },
        success: function (result) {
            if (result.code == 0) {
                DetailArray = result.data;
                allUnits = result.units;
                allCategory = result.allCategory;

                GenerateTemplate();
               
                generateHistory(result.history);
            }
            else {
                alert("恢复模板信息失败");
            }
            $.unblockUI();
        },
        error: function (e) {
            $.unblockUI();
            alert("恢复模板信息失败");
        }
    });

}
 
function setPriceMask() {
    $(".price").inputmask({ 'mask': "9{0,9}[.9{0,4}]", greedy: false });
}

$(function () {   

    if ($("#type").val() == "2") {
        $("#btnCopy").show();
    }


    $('#divHistory').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    getTemplate($("#type").val(),$("#type").val());   

    $('#btnAddCategory').click(function () {
        var divContainer = $("#divCategories");
        var table = CreateNewCategory();
        var li = $("<li></li>");
        table.appendTo(li);

        li.prependTo($("#divCategories"));

        BindEvents();

        $(".btn-add").button({ icons: { primary: "ui-icon-plus" } });
        $(".btn-delete").button({ icons: { primary: "ui-icon-delete" } });

        setPriceMask();
    });
    
    $("#btnCopy").click(function () {
        getTemplate(1);
    });

    $("#btnHistory").click(function () {
        showHistory();
    });

    $('#btnSave').click(function () {

        if (CheckInput()) {
            GetTemplateObject();
            if (DetailArray == null || DetailArray.length == 0) {
                SetErrorMsg('至少应该包含一个分类信息');
                return;
            }

            var i = 0;
            var j = 0;
            var k = 0;
            for (i = 0; i < DetailArray.length - 1; i++) {
                for (j = i + 1; j < DetailArray.length; j++) {
                    if (DetailArray[i].id == DetailArray[j].id) {
                        SetErrorMsg('错误：业务类型 [' + DetailArray[i].text + '] 重复，请核对！');
                        return;
                    }
                }
            }

            for (i = 0; i < DetailArray.length; i++) {
                for (j = 0; j < DetailArray[i].fields.length - 1; j++) {
                    for (k = j + 1; k < DetailArray[i].fields.length; k++) {
                        if (DetailArray[i].fields[j].id == DetailArray[i].fields[k].id) {
                            SetErrorMsg('错误：分类 [' + DetailArray[i].text + '] 中，字段名 [' + DetailArray[i].fields[j].label + '] 重复，请核对！');
                            return;
                        }
                    }
                }
            }

            synConfirm("确定保存模板吗？", function () {

                var unitAndPrice = getUnitAndPrice();

                $.ajax({
                    url: "/System/UpdateOrderTemplate",
                    type: 'POST',
                    cache: false,
                    dataType: 'json',
                    data: { data: JSON.stringify(DetailArray), type: $("#type").val(), unitAndPrice: unitAndPrice },
                    success: function (result) {
                        if (result.code == 0) {
                            location.href = "/System/OrderTemplate?type=" + $("#type").val() + "&welcome=1";
                        }
                        else {
                            SetErrorMsg(result.message);
                        }
                    },
                    error: function (e) {
                        SetErrorMsg("保存失败");
                    }
                });
            });

        }
        else {
            if ($('.error-msg').css('display') == "none") {
                SetErrorMsg("数据填写不完整，请展开所有分类并检查带有红色边框的字段");
            }
        }
    });      
 
});

var comapre = function (x, y) {
    return x.id.localeCompare(y.id); 
}

function getUnitAndPrice() {
    return "";     
}

function BindEvents() {

    $("#btnToggle1").unbind("click").click(function () {
        $('#divCategories').find(".imgToggle").each(
            function () {
                if ($(this).parent().parent().parent().parent().find("tbody").css('display') != "none") {
                    $(this).click();
                }
            }
        );
    });

    $("#btnToggle2").unbind("click").click(function () {
        $('#divCategories').find(".imgToggle").each(
            function () {
                if ($(this).parent().parent().parent().parent().find("tbody").css('display') == "none") {
                    $(this).click();
                }
            }
        );
    });

    $(".imgToggle").unbind("click").click(function () {
        
        if ($(this).attr("src").toLocaleLowerCase().indexOf("contractedblock.gif")>=0) {
            $(this).attr("src", "../../Images/grid/ExpandedBlockStart.gif");
            $(this).parent().parent().parent().parent().find("tbody").show();
        }
        else {
            $(this).attr("src", "../../Images/grid/ContractedBlock.gif");
            $(this).parent().parent().parent().parent().find("tbody").hide();
        }
    });

    $(".chkCategory").unbind("click").click(function () {
        SelectCategory(this);
    });

    $(".selectAllCategory").unbind("click").click(function () {
        if ($(this).prop("checked") == true) {
            $(this).parent().parent().find(".chkCategory").prop("checked", true);
            $(this).parent().parent().find(".chkCategory").parent().parent().find("td").addClass("trSelected");
        }
        else {
            $(this).parent().parent().find(".chkCategory").prop("checked", false);
            $(this).parent().parent().find(".chkCategory").parent().parent().find("td").removeClass("trSelected");
        }
    });

    $(".chkSubTable").unbind("click").click(function () {
        SelectAll(this);
    });
    
    $(".chkField").unbind("click").click(function () {
        SelectOne(this);
    });

    $(".btnDeleteFields").unbind("click").click(function () {
        deleteField(this);

    });

    $("#btnDeleteCategory").unbind("click").click(function () {

        var num = GetSelectedCategory(this);

        if (num == 0) {
            return SetErrorMsg("请选择需要删除的分类");;
        }

        synConfirm("警告：确定要删除选中的 " + num + " 个分类吗？", function () {
            $(".chkCategory").each(function (i, r) {
                if ($(r).prop("checked") == true) {
                    $(r).parent().parent().parent().parent().remove();
                }
            });

        }.bind(this));
    });

    $(".categoryUp").unbind("click").click(function () {
        var categoryLi = $(this).parent().parent().parent().parent().parent();
        var prev = $(categoryLi).prev();
        if (prev != null && prev.length > 0) {
            $(categoryLi).insertBefore(prev);
        }
        
    });

    $(".categoryDown").unbind("click").click(function () {
        var categoryLi = $(this).parent().parent().parent().parent().parent();
        var next = $(categoryLi).next();
        if (next != null && next.length > 0) {
            $(categoryLi).insertAfter(next);
        }
       
    });

    $(".fieldUp").unbind("click").click(function () {
        var field = $(this).parent().parent();
        var prev = $(field).prev();
        if (prev != null && prev.length > 0) {
            $(field).insertBefore(prev);
        }

    });

    $(".fieldDown").unbind("click").click(function () {
        var field = $(this).parent().parent();
        var next = $(field).next();
        if (next != null && next.length > 0) {
            $(field).insertAfter(next);
        }

    });

}

function SelectCategory(v) {
    if ($(v).prop("checked") == true) {
        $(v).parent().parent().find("td").addClass("trSelected");
    }
    else {
        $(v).parent().parent().find("td").removeClass("trSelected");
    }

    var allSelected = true;
    $(".chkCategory").each(function () {
        if ($(this).prop("checked") == false) {
            allSelected = false;
        }
    });

    $(".selectAllCategory").prop("checked", allSelected);
}

function GetTemplateObject() {
    DetailArray = new Array(); 
    $(".table-category").each(function (i, val) {
        var category = {};        
        category.guid = $(val).attr("id");
        category.text = $($(val).find("input").get(0)).val().replace(/\ +/g, "");
        category.id = $($(val).find("input").get(0)).val().replace(/\ +/g, "");
        category.reportCategory = $($(val).find("input").get(2)).val().replace(/\ +/g, "");
        category.priceTip = $($(val).find("textarea")).val();
        category.fields = [];
        var subTable = $(val).find("table");
        subTable.find("tr:gt(0)").each(function (i, val) {
            var tr = $(val);
            var field = {};
            field.id = $(tr.find("input").get(2)).val().replace(/\ +/g, "");
            field.type = $(tr.find("select")).val();
            if ($(tr.find("input[type='checkbox']").get(1)).prop("checked")) {
                field.isRequired = true;
            }
            else {
                field.isRequired = false;
            }
            if ($(tr.find("input[type='checkbox']").get(2)).prop("checked")) {
                field.isPriceFactor = true;
            }
            else {
                field.isPriceFactor = false;
            }
            if ($(tr.find("input[type='checkbox']").get(3)).prop("checked")) {
                field.isStockFactor = true;
            }
            else {
                field.isStockFactor = false;
            }

            field.formular = $(tr.find("input").get(5)).val().trim().replace(/\ +/g, "");
            field.label = $(tr.find("input").get(2)).val().replace(/\ +/g, "");
            if (field.type == 2) {
                field.options = $(tr.find("input").get(6)).val().replace(/，/g, ",").split(',');
            }
            category.fields.push(field);
        });

        var chk = $(val).find(".td-materials input[type='checkbox']");
        category.MaterialCategory = [];
        $(chk).each(function (x, y) {
            if ($(y).prop("checked")) {
                category.MaterialCategory.push({Id:$(y).attr("id")});
            }
        });

        DetailArray.push(category);       
    });
    
    //DetailArray.sort(comapre);       
}

function CheckInput() {
    var checkStatus = true;
    
    $("input[type='text']").removeClass("redBorder");
    ClearErrorMsg();

    $("input[type='checkbox']").each(function (i, val) {
        if ($($(val).parent().find("span").get(0)).text() == "价格因子") {
            if ($($(val).parent().parent().find("input").get(3)).prop("checked") &&
                !$($(val).parent().parent().find("input").get(1)).prop("checked")) {
                SetErrorMsg('价格因子字段为必填项。（类别：' + $($(val).parent().parent().parent().parent().parent().parent().parent().parent().find("input[type='text']").get(0)).val() + '，字段：' + $($(val).parent().parent().find("input").get(2)).val() + '）');                
                checkStatus = false;                
            }
        }
    });

    if (!checkStatus) {
        return checkStatus;
    }

    if ($("#type").val() == "1") {
        $("input[type='checkbox']").each(function (i, val) {
            if ($($(val).parent().find("span").get(0)).text() == "库存因子") {
                if ($($(val).parent().parent().find("input").get(4)).prop("checked") &&
                    !$($(val).parent().parent().find("input").get(1)).prop("checked")) {
                    SetErrorMsg('库存因子字段为必填项。（类别：' + $($(val).parent().parent().parent().parent().parent().parent().parent().parent().find("input[type='text']").get(0)).val() + '，字段：' + $($(val).parent().parent().find("input").get(2)).val() + '）');
                    checkStatus = false;
                }
            }
        });
    }

    if (!checkStatus) {
        return checkStatus;
    }

    $("input[type='text']").each(function (i, val) {

        if ($(val).attr("id") == "option") {
            if ($(val).parent().parent().find("select").val() == "2") {

                if ($(val).val().replace(/\ +/g, "") == "") {
                    $(val).addClass("redBorder");
                    SetErrorMsg(msg_error.required);
                    checkStatus = false;                    
                }
            }
        }
        else if ($(val).attr("id") == "formular") {
            if ($(val).parent().parent().find("select").val() == "2") {
                if ($(val).val() != "") {
                    $(val).addClass("redBorder");
                    checkStatus = false;                
                    SetErrorMsg('字段类型为下拉框时，公式不可用');                    
                }
            }
        }
        else {
            if ($(val).val() == "") {
                $(val).addClass("redBorder");              
                checkStatus = false;   
                SetErrorMsg(msg_error.required);
            }
        }

        if (!checkStatus) {
            return checkStatus;
        }

        if ($(val).val().indexOf('<') >= 0
                     || $(val).val().indexOf('>') >= 0
                     || $(val).val().indexOf('"') >= 0
                     || $(val).val().indexOf("'") >= 0
                     //|| $(val).val().indexOf(")") >= 0
                     //|| $(val).val().indexOf("(") >= 0
                     || $(val).val().indexOf("-") >= 0
                     || $(val).val().indexOf('+') >= 0
                     || $(val).val().indexOf('-') >= 0
                     || $(val).val().indexOf('*') >= 0
                    || $(val).val().indexOf('/') >= 0
            || $(val).val().indexOf(':') >= 0
            || $(val).val().indexOf('\\') >= 0) {               
            if ($(val).attr("id") == "name" || $(val).attr("id") == "categoryName"){
                $(val).addClass("redBorder");
                checkStatus = false;
                SetErrorMsg('业务类型或字段名称不能包含< > / " \' + - * \\ : ,  请点击【全部展开】按钮并检查带红色框的输入项。');            
            }
            
        }
    });

    if (checkStatus) {
        $("input[type='text']").each(function (i, val) {

            if ($(val).attr("id") == "option") {
                if ($(val).parent().parent().find("select").val() == "1" ||
                    $(val).parent().parent().find("select").val() == "3") {

                    if ($(val).val() != "") {
                        $(val).addClass("redBorder");
                        SetErrorMsg("字段类型为文本框或长备注框时，选项值必须为空"); 
                        checkStatus = false;
                    }
                }
            }
        });
        
    }
    
    return checkStatus;

}

function GenerateTemplate() {
    var divContainer = $("#divCategories");
    divContainer.html("");
    var table, tr, td;
    var subTable, subTr, subTd, ddlType, cbRequired;
    for (var i in DetailArray) {
        table = CreateNewCategory();
 
        //$(table.find(".imgToggle")).click();
        
        table.attr("id", DetailArray[i].guid);
        $(table.find("input").get(0)).val(DetailArray[i].text);        
        $(table.find("input").get(2)).val(DetailArray[i].reportCategory);
        if (DetailArray[i].priceTip != undefined) {
            $(table.find("textarea")).val(DetailArray[i].priceTip);
        }       
        subTable = table.find("table");
        
        var fieldsName = [];
        for (var j in DetailArray[i].fields) {
            fieldsName.push(DetailArray[i].fields[j].label);
            subTr = CreateNewfield();           
            $(subTr.find("select").get(0)).val(DetailArray[i].fields[j].type);
            if (DetailArray[i].fields[j].isRequired) {
                $(subTr.find("input").get(1)).prop("checked", true);
            }

            if (DetailArray[i].fields[j].isPriceFactor != undefined
                && DetailArray[i].fields[j].isPriceFactor) {
                $(subTr.find("input").get(3)).prop("checked",true);
            }
            if (DetailArray[i].fields[j].isStockFactor != undefined
                && DetailArray[i].fields[j].isStockFactor) {
                $(subTr.find("input").get(4)).prop("checked", true);
            }

            $(subTr.find("input").get(2)).val(DetailArray[i].fields[j].label);

            if (DetailArray[i].fields[j].formular != undefined) {
                $(subTr.find("input").get(5)).val(DetailArray[i].fields[j].formular);
            }

            $(subTr.find("input").get(6)).val(GetOptionString(DetailArray[i].fields[j].options));

            subTr.appendTo(subTable);

        }
        table.find('.spanFields').html("字段：" + fieldsName.join(", "));

        var li =$("<li></li>");
        table.appendTo(li);
        setPriceMask();
        li.appendTo(divContainer);        
        if (DetailArray[i].MaterialCategory != undefined
            && DetailArray[i].MaterialCategory != null) {
            var chks = table.find(".td-materials input[type='checkbox']");            
            $(DetailArray[i].MaterialCategory).each(function (x, y) {                 
                table.find(".td-materials input[id='" + y.Id+ "']").prop("checked", true);
            });
        }     

    }

    var el = document.getElementById('divCategories');
    //var sortable = Sortable.create(el);

    BindEvents();

    $("#btnToggle1").click();

    $(".btn-add").button({ icons: { primary: "ui-icon-plus" } });
    $(".btn-delete").button({ icons: { primary: "ui-icon-delete" } });
}

function NewTable() {
    return $("<table class='tableEdit'></table>");
}

function NewTr() {
    return $("<tr></tr>");
}

function newTd() {
    return $("<td></td>");
}

function newTh() {
    return $("<th></th>");
}

function NewFieldsTypeDdl() {
    return $("<select><option value='1'>文本框</option><option value='2'>下拉选择框</option><option value='3'>长备注框</option></select>");
}

function NewFieldsRequiredCheckbox() {
    return $("<input type='checkbox' value='true' />");
}

function NewFieldsImpactPriceCheckbox() {
    return $("<input type='checkbox' value='true' />");
}

function NewSubTable() {
    return $("<table style='text-align:center'><thead><tr><th style='width:40px'><input type='checkbox' title='全选' class='chkSubTable'> </input></th><th style='width:120px'>类型</th><th style='width:100px'>必填项</th><th style='width:120px' >名称</th><th style='width:90px'>价格因子</th><th class='isStockFactor' style='width:90px'>库存因子</th><th>计算公式</th><th>选项</th></tr></thead></table>");
}

function newTdWithClass(css) {
    return $("<td class='" + css + "'></td>");
}

function NewTextbox() {
    return $("<input type='text'/>")
}

function GetOptionString(value) {
    var result = "";
    for (var i in value) {
        result = result + value[i] + ","
    }
    if (result.length > 0) {
        result = result.substr(0, result.length - 1);
    }
    return result;
}

function CreateNewCategory() {
    var table, tr, td;
    table = NewTable();
    table.addClass("table-category");
    table.attr("id", newId());
    var thead = $("<thead></thead>");

    tr = NewTr();
    tr.addClass("tr-category-title")
    td = $("<td class='label'></td>");
    var icon = $("<img class='imgToggle' title='折叠/展开' src='../../Images/grid/ExpandedBlockStart.gif'  />");
 

    icon.appendTo(td);
    td.addClass("title");
    $("<span>业务类型</span>").appendTo(td);   
    td.appendTo(tr);
    td = newTd();
    td.css("position", "relative");
    td.addClass("title");
    NewTextbox().attr("id","categoryName").appendTo(td);    
    
    var chk = $("<input type='checkbox' title='选中删除' class='chkCategory'/>");    
    

    chk.appendTo(td);    
   
    var fieldsSpan = $("<span class='spanFields'></span>");

    fieldsSpan.appendTo(td);
    
    $("<a href='javascript:void(0)' class='categoryUp'>上↑</a>").appendTo(td);
   
    $("<a href='javascript:void(0)' class='categoryDown'>下↓</a>").appendTo(td);

    td.appendTo(tr);
    
    tr.appendTo(thead);
    thead.appendTo(table);

    var tbody = $("<tbody></tbody>");

    tr = NewTr();
    td = newTdWithClass("label");
    td.html("所属类别");
    td.appendTo(tr);
    td = newTd();
    NewTextbox().appendTo(td);
    td.appendTo(tr);
    tr.appendTo(tbody);
    tbody.appendTo(table);     

    tr = NewTr();
    td = newTdWithClass("label");
    td.html("详细字段");
    td.appendTo(tr);
    td = newTd(); 

    var hAddField = $("<button type='button' class='btn-add'>添加字段</button>");

    hAddField.click(function () {
        var tr = CreateNewfield();
        tr.appendTo($(this).parent().find("table"));
        BindEvents();
        return false;
    });
    hAddField.appendTo(td);

    var hDeleteField = $("<button class='btnDeleteFields btn-delete' type='button'>删除字段</button>");
  

    hDeleteField.appendTo(td);

    var chkField = $("<input style='margin-left:10px' type='checkbox'/>");

    subTable = NewSubTable();

    subTable.appendTo(td);
    td.appendTo(tr);
    tr.appendTo(tbody);
    tbody.appendTo(table);  

    tr = NewTr();
    tr.addClass(trPriceCss);
    td = newTdWithClass("label");
    td.html("价格提示");
    td.appendTo(tr);
    td = newTd();

    $("<textarea rows='4' style='width:600px;height:60px;'/>").appendTo(td); 
    td.appendTo(tr);
    tr.appendTo(tbody);   

    tr = NewTr();
    td = newTdWithClass("label").html("可用材料");
    td.appendTo(tr);
    td = newTdWithClass("td-materials");
    $(allCategory).each(function (i, v) {
        var chk = $("<input type='checkbox'/>").attr("id",v.Id);
        var span = $("<span></span>").html(v.Name);
        chk.appendTo(td);
        span.appendTo(td);
    });
    td.appendTo(tr);
    tr.appendTo(tbody);   
    
    tbody.appendTo(table);

    return table;  
}

function CreateNewfield() {
    var subTr, subTd, ddlType, cbRequired;
    subTr = NewTr();
    subTr.addClass("tr-category-title");

    subTd = newTd();
    var chkField = $("<input type='checkbox' title='选中删除' class='chkField'></input>");
    chkField.appendTo(subTd);
    $(subTd).css("text-align", "center");
    subTd.appendTo(subTr);

    subTd = newTd();
    ddlType = NewFieldsTypeDdl().css("width", "110px");
    ddlType.appendTo(subTd);
    subTd.appendTo(subTr);

    subTd = newTd();
    cbRequired = NewFieldsRequiredCheckbox();
    cbRequired.appendTo(subTd);
    $("<span>必填项</span>").appendTo(subTd);
    subTd.appendTo(subTr);

    subTd = newTd();   
    NewTextbox().css("width", "100%").attr("id","name").appendTo(subTd);
    subTd.appendTo(subTr);

    subTd = newTd();
    cbRequired = NewFieldsImpactPriceCheckbox();
    cbRequired.appendTo(subTd);
    $("<span>价格因子</span>").appendTo(subTd);
    subTd.appendTo(subTr);

    subTd = newTd();
    subTd.addClass("isStockFactor");
    cbRequired = NewFieldsImpactPriceCheckbox();
    cbRequired.appendTo(subTd);
    $("<span>库存因子</span>").appendTo(subTd);
    subTd.appendTo(subTr);

    subTd = newTd();
    NewTextbox().addClass("width-100").attr("id", "formular").appendTo(subTd);
    subTd.appendTo(subTr);

    subTd = newTd();
    subTd.css("padding-right", "68px");
    NewTextbox().addClass("width-100").attr("id","option").attr("title","多个选项间用逗号,分开").appendTo(subTd);        
    subTd.css("position","relative");
    $("<a href='javascript:void(0)' class='fieldUp'>上↑</a>").appendTo(subTd);    
    $("<a href='javascript:void(0)' class='fieldDown'>下↓</a>").appendTo(subTd);
    subTd.appendTo(subTr);

    return subTr;
}

function SelectAll(val) {    
    var chk;
    if ($(val).prop("checked")) {
        chk = true;
    }
    else {
        chk = false;
    }
    

    $(val).parent().parent().parent().parent().find(".chkField").each(function (i, r) {
        $(r).prop("checked", chk);
    });
}

function SelectOne(val) {
    var allSelected = true;
    
    $(val).parent().parent().parent().find(".chkField").each(function (i, r) {
        if ($(r).prop("checked") == false) {
            allSelected = false;
        }
    });
    $(val).parent().parent().parent().parent().find(".chkSubTable").prop("checked", allSelected);
}

function GetSelectedFieldsNumber(val) {
    var result = 0;
    $(val).parent().find(".chkField").each(function (i, r) {
        if ($(r).prop("checked") == true) {
            result = result + 1;
        }
    });

    return result;
}

function GetSelectedCategory(val) {
    var result = 0;
    $(".chkCategory").each(function (i, r) {
        if ($(r).prop("checked") == true) {
            result = result + 1;
        }
    });    
    return result;
}

function deleteField(t){
        
        if (GetSelectedFieldsNumber(t) == 0) {
            alert("请选择字段");
            return;
        }
        
        synConfirm("确定要删除选中的字段吗？", function () {
            $(t).parent().find(".chkField").each(function (i, r) {
                if ($(r).prop("checked") == true) {
                    $(r).parent().parent().remove();
                }
            });
        }.bind(t));
}