﻿var previousValue;
 

$(function () {    

    TdRowOverOut("tbody");

    $(".list input[type=text]").dblclick(function () {
        if (!$("#EditModel").prop("checked")) {
            alert("如需修改数据，请启用搜索栏中的“编辑模式”选项");
        }        
    });

    bindEvents();

    $("#EditModel").click(function () {
        setInputStatus();
    });

    $(".td-amount input[type=text]").inputmask({ 'mask': "9{0,9}[.9{0,2}]", greedy: false });


    $(".add-tip").click(function () {
        var costInput = $(this).parent().find("input[type=text]");
        if (!$("#EditModel").prop("checked")) {
            alert("请先启用编辑模式");
            return;
        }
        var type = $(this).parent().find("input[type=text]").attr("id").replace("fee", "");
        var orderNo = $(this).parent().parent().attr("id"); 
        $.ajax({
            url: "/Order/AutoGetOrderCost",
            type: 'POST',
            cache: false,
            data: {
                OrderNo: orderNo,  Type: type
            },
            success: function (result) {

                if (result.code == 0) {
                    if (result.fee != null) {
                        costInput.val(result.fee);
                        costInput.parent().parent().find("#TotalFee").html(result.totalCost);
                        var amount = FixTwoDecimal(costInput.parent().parent().find("#Amount").html());
                        costInput.parent().parent().find("#Profit").html(FixTwoDecimal(amount - result.totalCost));
                        if (result.message) {
                            alert(result.message);
                        }

                    }
                    //updateSuccess(td);
                }
                else {
                    updateFailed(td);
                }
            },
            error: function (e) {
                
                updateFailed(td);

            }
        });
        
    });

    var inputs = $(".list input[type=text]");

    $(inputs).each(function (i, v) {
        var msg1 = $('<span class="priceMsg">设置成功！</span>');
        var msg2 = $('<span class="priceMsg1">设置失败！</span>');
        msg1.appendTo($(v).parent());
       
        msg2.appendTo($(v).parent());
    });

    setInputStatus();
});

function setInputStatus() {
    if ($("#EditModel").prop("checked")) {
        $(".list input[type=text]").removeAttr("readonly");        
    }
    else {
        $(".list input[type=text]").attr("readonly", "readonly");
    }
}

function checkSearch() {
    if ($("#BeginDate").val().trim() == "" || $("#EndDate").val().trim() == ""){
        SetErrorMsg("请选择起止时间");
        return false;
    }
    else if (DateDiff($("#BeginDate").val(), $("#EndDate").val()) > 366) {
        SetErrorMsg("提示：起止时间跨度最多为1年。如果时间跨度超过1年，请分多次查询。");
        return false;
    }

    return true;
}
 
function bindEvents() {
    $("#tbody input[type=text]").focus( function () {        
        previousValue = $(this).val();      
        $(this).parent().addClass("td-focus");

    }).blur(function(){
        $(this).parent().removeClass("td-focus");
    }).change(function () {

        var orderNo = $(this).parent().parent().attr("id"); 
        var cost = $(this).val();
        var costInput = $(this);
        var td = $(this).parent();
        var type = costInput.attr("id").replace("fee", "");
        var memo = cost;

        if (parseInt(type)<10 && cost != "" && isNaN(cost)) {           
            costInput.addClass("red-text");
            updateFailed(td);
        }
        else {
            console.log(memo);
            $.ajax({
                url: "/Order/UpdateOrderCost",
                type: 'POST',
                cache: false,
                data: {
                    OrderNo: orderNo, Cost: cost, cost: cost, Type: type,Memo:memo
                },
                success: function (result) {
                    
                    if (result.code == 0) {
                        if (result.data != null) {
                            console.log(result);
                            costInput.parent().parent().find("#TotalFee").html(result.data);
                            var amount = FixTwoDecimal( costInput.parent().parent().find("#Amount").html());
                            costInput.parent().parent().find("#Profit").html(FixTwoDecimal( amount - result.data));
                            
                        }
                        //updateSuccess(td);
                    }
                    else {                               
                        updateFailed(td);
                    }
                },
                error: function (e) {
                    
                    updateFailed(td);
                   
                }
            });
        }        
    });
}



function updateSuccess(td) {
    $(td).find("input").removeClass("red-text");
    console.log($(td).find(".priceMsg"));
    $(td).find(".priceMsg").fadeIn("fast");
    $(td).find(".priceMsg").fadeOut("3000");
}

function updateFailed(td) {
    $(td).find("input").addClass("red-text");
    $(td).find(".priceMsg1").fadeIn("fast");
    $(td).find(".priceMsg1").fadeOut("3000");
}



function downExcel() {
    if ($("#BeginDate").val().trim() == "" || $("#EndDate").val().trim() == "") {
        SetErrorMsg("请选择起止时间");
        return false;
    }
    else if (DateDiff($("#BeginDate").val(), $("#EndDate").val()) > 366) {
        SetErrorMsg("提示：起止时间跨度最多为1年。如果时间跨度超过1年，请分多次查询。");
        return false;
    }
    location.href = "/Order/GetOrderCostExcel?BeginDate=" + $("#BeginDate").val() + "&EndDate=" + $("#EndDate").val()+"&Key="+$("#Key").val();
}