﻿var allCustomer = [];
$(function () {

    $.ajax({
        url: "/Order/GetAutoCompleteCustomer",
        type: 'GET',
        cache: false,
        dataType: 'json',
        async: false,
        success: function (result) {
            for (var i in result.data) {
                allCustomer.push({ label: result.data[i].ItemText, value: result.data[i].ItemValue });
            }
        },
        error: function (e) {
        }
    });

    try {
        $('#txtCustomer').autocomplete({
            source: allCustomer,
            select: function (a, b, c) {
                $("#sCustomerNo").val(b.item.value);
            },
            close: function (envent, ui) {
                $('#txtCustomer').val("");
            }
        });
    }
    catch (e) {
    }

    $("#tOrder tr td").click(function () {
        if ($(this).parent().hasClass("totalTd")) {
            return;
        }        
        else {
            ShowDetail($(this).parent().attr("id"));
        }
    });

    TdRowOverOut("tOrder");      
    SetSpanColor("tOrder");

    $("#btnExportExcel").click(function () {
        if (checkRequired('dSearch', '') == false) {
            return false;
        }     

        location.href = "/Order/GetOrderAgingExcel?sCustomerNo=" + $("#sCustomerNo").val() + "&sBeginDate=" + $("#sBeginDate").val() + "&sCustomerName=" + $("#sCustomerName").val() +
            "&sEndDate=" + $("#sEndDate").val() + "&sContact=" + $("#sContact").val() + "&sOrderAging=" + $("#sOrderAging").val();
    });

});

function checkField() {
    ClearErrorMsg();

    if (checkRequired('dSearch', '') == false) {
        return false;
    }
    else if (DateDiff($("#sBeginDate").val(), $("#sEndDate").val()) > 93) {
        SetErrorMsg("提示：起止时间跨度最多为3个月。如果时间跨度超过3个月，请分多次查询。");
        return false;
    }
    else {
        return true;
    }
}

