﻿$(function () { 
    //GetPerformanceData();

});

function GetPerformanceData() {

    $.ajax({
        url: "/Chart/GetMySpaceData",
        type: 'GET',
        cache: false,
        data: { },
        success: function (result) {
            if (result.code == 0) {
                RefreshChart(result.data);
            }
            else {
                alert("获取数据失败");
            }

        },
        error: function (e) {
            alert("获取数据失败");
        }
    });

}

function RefreshChart(data) {
    $('#chartcontainer').highcharts({
        title: {
            text: '',
            x: -20 //center
        },
        chart: {type: "spline"},
        subtitle: {
            text: '',
            x: -20
        },
        xAxis: {
            categories: data.Categories
        },
        yAxis: {
            min:0,
            title: {
                text: '订单金额 (元)'
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        tooltip: {
            valueSuffix: '元'
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'middle',
            borderWidth: 0
        },
        series: data.Series
    });
}