﻿$(function () {
    $("#btnUpload").click(function () {

        ClearErrorMsg();

        materialFileUpload();
    });

    $("#btnReturn").click(function () {
        location.href = "/Warehouse/Material";
    });    
})

function materialFileUpload() {    

    if ($("#fileToUpload").val() == "") {
        SetErrorMsg("请选择上传文件");
        return;
    }

    var point = $("#fileToUpload").val().lastIndexOf(".");
    var type = $("#fileToUpload").val().substr(point).toLowerCase();

    if (type != ".xls" && type != ".xlsx") {
        SetErrorMsg("文件类型错误，仅支持.xls和.xlsx格式的文件。");
        return;
    }

    $.blockUI({ message: '<h5>导入数据可能需要较长时间，请耐心等候...</h5>' });

    $.ajaxFileUpload({
        url: '/Warehouse/MaterialFileUpload?nowtime=' + new Date().getTime(),
        secureuri: false,
        fileElementId: 'fileToUpload',        
        dataType: 'json',
        success: function (d, status) {            
            $.unblockUI();

            var data = JSON.parse(d);
            data = data.Data;
            if (data.code == "1") {                 
                SetErrorMsg(data.message);                
            }
            else if (data.code == "0") {
                SetInfoMsg("导入成功！共导入"+ data.data + "条材料数据");
            }
        },
        error: function (data, status, e) {
            console.log(data);
            console.log(status);
            console.log(e);
            $.unblockUI(); 
            SetErrorMsg("错误：导入时发生错误，请稍后再试。");     
        }
    });     
}