﻿function EditCategory(Id, Name) {

    ClearErrorMsg();    
    $("#Name").val(Name);
    $("#Id").val(Id);
    showCategory();  
}

function DeleteCategory(Id) {

    ClearErrorMsg();     

    synConfirm("确定删除吗？", function () {
        $.ajax({
            url: "/Warehouse/DeleteCategory",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    $("#tCategory").find("tr[id='" + Id + "']").remove();
                }
                else if (result.code==1) {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('删除失败：该分类已产生业务数据，无法删除');
            }
        });
    });    

    return false;
}

$(function () {

    setOperationBtns();

   
    TdRowOverOutSpecify("tCategory");
    TdRowOverOut("tCategory");

    $('#divCategory').dialog({
        width:400,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    

 
 

    $('#btnNew').click(function () {
        $("#Name").val('');
        $("#Id").val('');
        showCategory();        
    });

    


    $('#btnSave').click(function () {

        if (!$("#Id").val()) {
            if (checkRequired('divCategory', 'errorMessage') == false) {
                return;
            }
 
            synConfirm("确定保存吗？", function () {

                $.ajax({
                    url: "/Warehouse/CategoryAdd",
                    type: 'POST',
                    cache: false,
                    data: {
                        Name: $("#Name").val()
                    },
                    success: function (result) {
                        if (result.code == 0) {
                            closeCategory();                          
                            location.href = "/Warehouse/Category";
                        }
                        else {
                            SetErrorMsg(result.message,"divCategory");
                        }
                    },
                    error: function (e) {                        
                        SetErrorMsg("保存失败", "divCategory");
                    }
                })
            });     
        }
        else {
            if (!checkRequired('divCategory', 'errorMessage')) {
                return;
            }

            synConfirm("确定保存修改吗？", function () {
                $.ajax({
                    url: "/Warehouse/CategoryUpdate",
                    type: 'POST',
                    cache: false,
                    data: {
                        Id: $("#Id").val(),
                        Name: $("#Name").val() 
                    },
                    success: function (result) {
                        if (result.code == 0) {
                            closeCategory();
                            location.href = "/Warehouse/Category";
                        }
                        else {
                            SetErrorMsg(result.message, "divCategory");                             
                        }
                    },
                    error: function (e) {
                        SetErrorMsg("保存失败.","divCategory");
                    }
                });
            });

           
        }
    });
});

function showCategory() {
    ClearErrorMsg();
    $('#divCategory').dialog('open');
}

function closeCategory() {
    $('#divCategory').dialog('close');
}
 
 