﻿function EditMaterial(Id) {

    clearMaterialForm();

    $.ajax({
        url: "/Warehouse/GetMaterial",
        type: 'GET',
        cache: false,
        data: { Id: Id },
        success: function (result) {
            if (result.code == 0) {
                $("#Id").val(result.data.Id);
                $("#Name").val(result.data.Name);
                $("#CategoryId").val(result.data.CategoryId);
                $("#CostPrice").val(result.data.CostPrice);
                $("#SailPrice").val(result.data.SailPrice);
                $("#FactoryPrice").val(result.data.FactoryPrice);
                $("#SafetyStock").val(result.data.SafetyStock);
                $("#PriceUnitId").val(result.data.PriceUnitId);
                $("#StockMaterialId").val(result.data.StockMaterialId);
                $("#ForOrder").prop("checked", result.data.ForOrder);
                $("#ForStock").prop("checked", result.data.ForStock);
                $("#IsActive").prop("checked", result.data.IsActive);
                $("#Memo").val(result.data.Memo);
                $("#ForStock").change();

                showMaterial();
            }

        },
        error: function (e) {
        }
    });

    return false;
}

function DeleteMaterial(Id) {

    ClearErrorMsg();

    synConfirm("确定删除吗？<br>提醒：该材料的报价记录，库存记录等将一并删除。", function () {
        $.blockUI({ message: '<h5>请稍候...</h5>' });
        $.ajax({
            url: "/Warehouse/DeleteMaterial",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                $.unblockUI();
                if (result.code == 0) {
                    $("#tMaterial").find("tr[id='" + Id + "']").remove();
                }
                else {
                    alert(result.message);
                }

            },
            error: function (e) {
                $.unblockUI();
                alert('删除失败：该材料已产生业务数据，无法删除');
            }
        });
    });

    return false;
}

function setColor() {
    var spans = $("span.status");
    $(spans).each(function (i, v) {
        if ($(v).text() == "已停用") {
            $(v).parent().parent().css("background-color", "#ddd");
        }
        else {
            $(v).css("color", "#3c8dbc");
        }
    });

    $("#tMaterial span").each(function () {
        if ($(this).html() == "是") {
            $(this).css("color", "#3c8dbc");
        }
        else if ($(this).html() == "否") {
            $(this).css("color", "gray");
        }
    });
}

$(function () {

    setOperationBtns();

    setColor();

    TdRowOverOut("tMaterial");

    $('#divTechnic').dialog({
        width: 600,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });




    $('#btnImport').click(function () {
        location.href = "/Warehouse/MaterialImport";
    });

    $('#btnSaveMaterial').click(function () {

        if (checkRequired('divMaterial', 'errorMessage') == false) {
            return;
        }

        synConfirm("确定保存吗？", function () {
            $.ajax({
                url: "/Warehouse/SaveMaterial",
                type: 'POST',
                cache: false,
                data: GetFormMaterialObject(),
                success: function (result) {
                    if (result.code == 0) {
                        closeMaterial();
                        location.reload();                        
                    }
                    else {
                        SetErrorMsg(result.message, "divMaterial");
                    }
                },
                error: function (e) {
                    SetErrorMsg("保存失败", "divMaterial");
                }
            })
        });
    });
});


function downExcel() {
    location.href = "/Warehouse/GetMaterialExcel?sStatus=" + $("#sStatus").val() + "&sCategoryId=" + $("#sCategoryId").val() + "&sKeywords=" + $("#sKeywords").val();
}

function EditTechnic(materialId, materialName) {
    $("#divTechnic #MaterialId").val(materialId);
    $("#divTechnic #divTechnicTitle").html(materialName);
    var tBody = $("#technics");
    tBody.empty();

    $("#chart-no-data").hide();
    $("#technicTable").hide();
    $("#btnSaveTechnic").hide();

    $.ajax({
        url: "/Warehouse/GetMaterialTechnic",
        type: 'POST',
        cache: false,
        data: { materialId: materialId },
        success: function (result) {
            if (result.code == 0) {

                if (result.data.length > 0) {
                    $("#technicTable").show();
                    $("#btnSaveTechnic").show();
                    var tr, td, chk, price;

                    $(result.data).each(function (i, v) {
                        tr = $("<tr></tr>").attr("id", v.Id);
                        td = $("<td></td>");
                        chk = $("<input type='checkbox'>").val(v.TechnicId).prop("checked", v.Id > 0).appendTo(td);
                        td.appendTo(tr);

                        td = $("<td></td>").html(v.TechnicName);
                        td.appendTo(tr);

                        td = $("<td></td>");
                        price = $("<input id='CostPrice' type='textbox'></input>").val(v.CostPrice == 0 ? "" : v.CostPrice).inputmask({ 'mask': "-{0,1}9{0,9}[.9{0,4}]", greedy: false });
                        price.appendTo(td);
                        td.appendTo(tr);

                        td = $("<td></td>");
                        price = $("<input id='SailPrice' type='textbox'></input>").val(v.SailPrice == 0 ? "" : v.SailPrice).inputmask({ 'mask': "-{0,1}9{0,9}[.9{0,4}]", greedy: false });
                        price.appendTo(td);
                        td.appendTo(tr);

                        td = $("<td></td>");
                        price = $("<input id='FactoryPrice' type='textbox'></input>").val(v.FactoryPrice == 0 ? "" : v.FactoryPrice).inputmask({ 'mask': "-{0,1}9{0,9}[.9{0,4}]", greedy: false });
                        price.appendTo(td);
                        td.appendTo(tr);

                        tr.appendTo(tBody);

                    });
                }
                else {
                    $("#chart-no-data").show();
                }


                $('#divTechnic').dialog('open');
            }

        },
        error: function (e) {
        }
    });

    return false;
}

function SaveTechnic() {
    var technicData = [];
    var msg1 = "错误：只能为选中的工艺设置价格";
    ClearErrorMsg("divTechnic");
    var selected, costPrice,sailPrice, factoryPrice, inputCheck = true;
    $($("#technics tr")).each(function (i, tr) {
        selected = $(tr).find("input[type=checkbox]").prop("checked");

        sailPrice = $(tr).find("#SailPrice").val();
        costPrice = $(tr).find("#CostPrice").val();
        factoryPrice = $(tr).find("#FactoryPrice").val();

        if (selected) {

            if (costPrice.trim() == "") {
                $(tr).find("#CostPrice").val("0");
                //inputCheck = false;
                //$(tr).find("#CostPrice").addClass("redBorder");
                //return false;
            }

            if (sailPrice.trim() == "") {
                $(tr).find("#SailPrice").val("0");
                //inputCheck = false;
                //$(tr).find("#SailPrice").addClass("redBorder");
                //return false;
            }

            if (factoryPrice.trim() == "") {
                $(tr).find("#FactoryPrice").val("0");
                //inputCheck = false;
                //$(tr).find("#FactoryPrice").addClass("redBorder");
                //return false;
            }

            technicData.push({
                Id: $(tr).attr("id"),
                MaterialId: $("#divTechnic #MaterialId").val(),
                TechnicId: $(tr).find("input[type=checkbox]").val(),
                CostPrice: FixFourDecimal(costPrice),
                SailPrice: FixFourDecimal(sailPrice),
                FactoryPrice: FixFourDecimal(factoryPrice)
            });

        }
        else {
            if (sailPrice.trim() != "") {
                inputCheck = false;
                $(tr).find("#SailPrice").addClass("redBorder");
                SetErrorMsg(msg1, "divTechnic");
                return false;
            }

            if (factoryPrice.trim() != "") {
                inputCheck = false;
                $(tr).find("#FactoryPrice").addClass("redBorder");
                SetErrorMsg(msg1, "divTechnic");
                return false;
            }
        }

    });

    if (!inputCheck) {
        return;
    }


    $.ajax({
        url: "/Warehouse/SaveMaterialTechnic",
        type: 'POST',
        cache: false,
        data: {
            materialId: $("#divTechnic #MaterialId").val(),
            Technics: JSON.stringify(technicData)
        },
        success: function (result) {
            if (result.code == 0) {
                $('#divTechnic').dialog('close');
                location.reload();
            }
            else {
                SetErrorMsg(result.message, "divTechnic");
            }
        },
        error: function (e) {
            SetErrorMsg("保存失败", "divTechnic");
        }
    })

}

 