﻿var smsTimeRemain = 60;
var smsInterval = null;

function showTip() {
    $('#divTip').dialog("open");
}
$(function () {   
    $('#divTip').dialog({
        width: 680,
        autoOpen: false,
        modal: true,
        title:"提示",
        buttons: {
        }
    });

    $("#btnSend").click(function () {

        ClearErrorMsg();
        if (!$("#mobile").val()) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("请输入手机号");
        }

        if (!IsMobile($("#mobile").val())) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("手机号格式不对");
        }

        $("#btnSend").prop("disabled", "disabled");
        $.ajax({
            url: "/Home/GetValidateCode",
            type: 'POST',
            cache: false,
            data: { mobile: $("#mobile").val(), type: 2 },
            success: function (result) {
                $("#btnSend").removeAttr("disabled");
                if (result.code == 0) {
                    // TBD 倒计时

                    smsTimeRemain = 60;
                    $("#btnSend").prop("disabled", "disabled");

                    smsInterval = setInterval(
                        function () {
                            if (smsTimeRemain == 1) {
                                $("#btnSend").text("发送验证码");
                                $("#btnSend").removeAttr("disabled");
                                if (smsInterval != null) {
                                    clearInterval(smsInterval);
                                }
                            }
                            else {
                                smsTimeRemain--;
                                $("#btnSend").text(smsTimeRemain + "秒后重发");
                            }


                        }, 1000);

                    $("#btnSend").prop("disabled", "disabled");
                    $("#btnSend").text("60秒后重发");
                }
                else if (result.code == 1) {
                    SetErrorMsg("手机号未注册");
                }
                else if (result.code==2){
                    SetErrorMsg("验证码发送失败，请稍后再试");
                }

            },
            error: function (e) {
                $("#btnSend").removeAttr("disabled");
                SetErrorMsg("验证码发送失败，请稍后再试");
                $.unblockUI();
            }
        });

    });


    $("#btnSave").click(function () {
        ClearErrorMsg();
        if (!$("#mobile").val()) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("请输入手机号");
        }

        if (!IsMobile($("#mobile").val())) {
            $("#mobile").addClass("redBorder");
            return SetErrorMsg("手机号格式不对");
        }

        if (!$("#code").val()) {
            $("#code").addClass("redBorder");
            return SetErrorMsg("请输入验证码");
        }

        if (!$("#password").val()) {
            $("#password").addClass("redBorder");
            return SetErrorMsg("请输入新密码");
        }


        if ($("#password").val().length < 6) {
            $("#password").addClass("redBorder");
            return SetErrorMsg("密码至少6位字符");
        }

        $.blockUI({ message: '<h5>处理中，请稍候...</h5>' });
        $.ajax({
            url: "/Account/ResetPassword",
            type: 'POST',
            data: { mobile: $("#mobile").val(), code: $("#code").val(), password: $("#password").val() },
            success: function (result) {
                $.unblockUI();
                if (result.code == 0) {
                    location.href = "/Account/login?id=" + $("#mobile").val() + "&welcome=2";
                }
                else if (result.code == 1) {
                    SetErrorMsg("验证码错误");                    
                }
                else if (result.code == 2) {
                    SetErrorMsg("手机号未注册");                    
                }
                else if (result.code == 3) {
                    SetErrorMsg("用户已锁定");                    
                }
                else if (result.code == 4) {
                    SetErrorMsg("非管理员账号，请联系您的管理员获取密码");                    
                }
            },
            error: function (e) {
                $.unblockUI();
                SetErrorMsg("密码重置失败，请联系9平米管理员");                
            }
        });

    });

});
