﻿var previousValue;
 

$(function () {    

    $("#sMaterialId").select2();
    $("#sFactoryNo").select2();

    $("#sourceFactoryNo").select2();
    $("#destinationFactoryNo").select2();

    TdRowOverOut("tbody");

    $('#divCopy').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $("#btnCopy").click(function () {
        ClearErrorMsg();
        $("#sourceFactoryNo").val($("#sFactoryNo").val()).select2();
        $('#divCopy').dialog('open');
    });


    bindEvents();
   
});

function checkSearch() {
    if ($("#sMaterialId").val() == "" && $("#sFactoryNo").val() == ""){
        SetErrorMsg("请选择要查询的材料或外协");
        return false;
    }

    return true;
}

function copyPrice() {

    ClearErrorMsg();

    if (checkRequired('divCopy', 'errorMessage') == false) {
        return;
    }

    if ($("#sourceFactoryNo").val() == "") {
        SetErrorMsg("请选择源外协", "divCopy");
        return;
    }
    if ($("#destinationFactoryNo").val() == "") {
        SetErrorMsg("请选择目标外协", "divCopy");
        return;
    }

    if ($("#sourceFactoryNo").val() == $("#destinationFactoryNo").val()) {
        SetErrorMsg("源外协和目标外协不能相同", "divCopy");
        return;
    }
    
    var destinationC = $("#destinationFactoryNo").find("option:selected").text();

    synConfirm("确定复制吗？<br><b>提示：此操作将删除[" + destinationC + "]之前的报价信息!</b>", function () {

        $.ajax({
            url: "/WareHouse/CopyFactoryPrice",
            type: 'POST',
            cache: false,
            data: {
                sourceFactoryNo: $("#sourceFactoryNo").val(), destinationFactoryNo: $("#destinationFactoryNo").val()},
            success: function (result) {
                if (result.code == 0) {
                    $('#divCopy').dialog('close');             
                    $("#sMaterialId").val("");
                    $("#sFactoryNo").val($("#destinationFactoryNo").val());
                    $("#btnSearch").click();

                }
                else {
                    SetErrorMsg(result.message,"divCopy");
                }
            },
            error: function (e) {
                SetErrorMsg("复制价格失败，请稍候再试", "divCopy");
            }
        });
    });
}


function bindEvents() {
    $("#tbody input[type=text]").focus( function () {        
        previousValue = $(this).val();      
    }).change(function () {

        var factoryNo = $(this).parent().parent().find("#hFactoryNo").val();
        var materialId = $(this).parent().parent().find("#hMaterialId").val();
        var sailPrice = $(this).val();
        var sailPriceInput = $(this);
        var td = $(this).parent();

        if (sailPrice != "" && isNaN(sailPrice)) {
            sailPriceInput.addClass("red-text");
        }
        else if ((sailPrice && !isNaN(sailPrice))|| sailPrice=="") {

            $.ajax({
                url: "/WareHouse/UpdateFactoryPrice",
                type: 'POST',
                cache: false,
                data: {
                    factoryNo: factoryNo, materialId: materialId, sailPrice: sailPrice
                },
                success: function (result) {
                    if (result.code == 0) {
                        if (result.data != null) {
                            sailPriceInput.val(result.data);
                        }
                        updateSuccess(td);
                    }
                    else {                       
                        updateFailed(td);
                    }
                },
                error: function (e) {
                  
                    updateFailed(td);
                   
                }
            });
        }        
    });
}



function updateSuccess(td) {
    $(td).find("input").removeClass("red-text");
    $(td).find(".priceMsg").fadeIn("fast");
    $(td).find(".priceMsg").fadeOut("3000");
}

function updateFailed(td) {
    $(td).find("input").addClass("red-text");
    $(td).find(".priceMsg1").fadeIn("fast");
    $(td).find(".priceMsg1").fadeOut("3000");
}



function downExcel() {
    if ($("#sMaterialId").val() == "" && $("#sFactoryNo").val() == "") {
        SetErrorMsg("请选择要查询的材料或外协");
        return false;
    }
    location.href = "/Warehouse/GetFactoryPriceExcel?sMaterialId=" + $("#sMaterialId").val() + "&sFactoryNo=" + $("#sFactoryNo").val();
}