﻿function NewAllowance() {
    $("#AllowanceId").val("0");
    $("#AllowanceName").val("");
    $("#AllowanceAmount").val("");

    $('#divAllowance').dialog('open');
}

function EditAllowance(id, name, value) {
    $("#AllowanceId").val(id);
    $("#AllowanceName").val(name);
    $("#AllowanceAmount").val(value);

    $('#divAllowance').dialog('open');
}

function SaveAllowance() {
    ClearErrorMsg("divAllowance");

    if (checkRequired('divAllowance', 'error-msg') == false) {
        return;
    }

    var data = {};
    data.Id = $("#AllowanceId").val();
    data.SettingName = $("#AllowanceName").val();
    data.SettingValue = $("#AllowanceAmount").val();
    data.EmployeeId = $("#Employee_Id").val();

    $.ajax({
        url: "/HR/SaveAllowance",
        type: 'POST',
        cache: false,
        data: data,
        success: function (result) {

            if (result.code == 0) {

                if (data.Id == 0) {
                    addAllowanceTr(result.data);
                }
                else {
                    updateAllowanceTr(result.data);
                }

                $('#divAllowance').dialog('close');
            }
            else if (result.code == 1) {
                SetErrorMsg("该津贴名称已存在", "divAllowance");
            }
            else {
                SetErrorMsg("保存失败，请稍后再试", "divAllowance");
            }

        },
        error: function (e) {
            SetErrorMsg("保存失败，请稍后再试", "divAllowance");
        }
    });
}

function DeleteAllowance(id) {
    if (!confirm("删除该项目将影响所有员工薪酬配置，确定删除吗？")) {
        return;
    }

    $.ajax({
        url: "/HR/DeleteAllowance",
        type: 'POST',
        cache: false,
        data: { Id: id },
        success: function (result) {

            if (result.code == 0) {
                var tbody = $("#tab_2 tbody tr[id='" + id + "']").remove();
            }
            else {
                SetErrorMsg("删除失败，请稍后再试", "tab_2");
            }

        },
        error: function (e) {
            etErrorMsg("删除失败，请稍后再试", "tab_2");
        }
    });
}

function addAllowanceTr(data) {
    var tbody = $("#tbodyAllowance");
    var tr = NewTr();
    tr.attr("id", data.Id);

    var td = NewTd();
    td.html(data.SettingName);
    td.appendTo(tr);

    td = NewTd();
    td.html(data.SettingValue);
    td.appendTo(tr);

    td = NewTd();
    var a = $("<a href='javascript:void(0)' onclick='EditAllowance(" + data.Id + ",\"" + data.SettingName + "\"," + data.SettingValue + ")'>编辑</a>");
    a.appendTo(td);

    $("<span>&nbsp;</span>").appendTo(td);

    a = $("<a href='javascript:void(0)' onclick='DeleteAllowance(" + data.Id + ")'>删除</a> ");
    a.appendTo(td);

    td.appendTo(tr);
    tr.appendTo(tbody);
}

function updateAllowanceTr(data) {
    var tr = $("#tbodyAllowance tr[id='" + data.Id + "']");
    console.log(tr);
    console.log(tr.find("td:eq(0)"));
    tr.find("td:eq(0)").html(data.SettingName);

    tr.find("td:eq(1)").html(data.SettingValue);
}

function NewDeduct() {
    $("#DeductId").val("0");
    $("#DeductName").val("");
    $("#DeductAmount").val("");

    $('#divDeduct').dialog('open');
}

function EditDeduct(id, name, value) {
    $("#DeductId").val(id);
    $("#DeductName").val(name);
    $("#DeductAmount").val(value);

    $('#divDeduct').dialog('open');
}

function SaveDeduct() {
    ClearErrorMsg("divDeduct");

    if (checkRequired('divDeduct', 'error-msg') == false) {
        return;
    }

    var data = {};
    data.Id = $("#DeductId").val();
    data.SettingName = $("#DeductName").val();
    data.SettingValue = $("#DeductAmount").val();
    data.EmployeeId = $("#Employee_Id").val();

    $.ajax({
        url: "/HR/SaveDeduct",
        type: 'POST',
        cache: false,
        data: data,
        success: function (result) {

            if (result.code == 0) {

                if (data.Id == 0) {
                    addDeductTr(result.data);
                }
                else {
                    updateDeductTr(result.data);
                }

                $('#divDeduct').dialog('close');
            }
            else if (result.code == 1) {
                SetErrorMsg("该扣款名称已存在", "divDeduct");
            }
            else {
                SetErrorMsg("保存失败，请稍后再试", "divDeduct");
            }

        },
        error: function (e) {
            SetErrorMsg("保存失败，请稍后再试", "divDeduct");
        }
    });
}

function DeleteDeduct(id) {
    if (!confirm("删除该项目将影响所有员工薪酬配置，确定删除吗？")) {
        return;
    }

    $.ajax({
        url: "/HR/DeleteDeduct",
        type: 'POST',
        cache: false,
        data: { Id: id },
        success: function (result) {

            if (result.code == 0) {
                var tbody = $("#tab_2 tbody tr[id='" + id + "']").remove();
            }
            else {
                SetErrorMsg("删除失败，请稍后再试", "tab_2");
            }

        },
        error: function (e) {
            etErrorMsg("删除失败，请稍后再试", "tab_2");
        }
    });
}

function addDeductTr(data) {
    var tbody = $("#tbodyDeduct");
    var tr = NewTr();
    tr.attr("id", data.Id);

    var td = NewTd();
    td.html(data.SettingName);
    td.appendTo(tr);

    td = NewTd();
    td.html(data.SettingValue);
    td.appendTo(tr);

    td = NewTd();
    var a = $("<a href='javascript:void(0)' onclick='EditDeduct(" + data.Id + ",\"" + data.SettingName + "\"," + data.SettingValue + ")'>编辑</a>");
    a.appendTo(td);

    $("<span>&nbsp;</span>").appendTo(td);

    a = $("<a href='javascript:void(0)' onclick='DeleteDeduct(" + data.Id + ")'>删除</a> ");
    a.appendTo(td);

    td.appendTo(tr);
    tr.appendTo(tbody);
}

function updateDeductTr(data) {
    var tr = $("#tbodyDeduct tr[id='" + data.Id + "']");
    console.log(tr);
    console.log(tr.find("td:eq(0)"));
    tr.find("td:eq(0)").html(data.SettingName);

    tr.find("td:eq(1)").html(data.SettingValue);
}

$(function () {

  $(".text-date-1").attr("readonly", "readonly");
    $(".text-date-1").datepicker({
        dateFormat: 'yy-mm-dd',
        changeMonth: true,
        changeYear: true,
        yearRange:"1920:2020"


    });

    $("#btnReturnBasicInfo").click(function () {
        var url = location.href.toLowerCase();
        if (url.indexOf("message")>=0){
            location.href="/HR/Employee";
        }
        else{
            history.go(-1);
        }
      
    });

    $('#divAllowance').dialog({
        width: 400,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#divDeduct').dialog({
        width: 400,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $(".nav-tabs a").click(function () {
        var id = "#tab_" + $(this).attr("id").replace("a", "");

        if (id == "#tab_2" && $("#Employee_Id").val() == "0") {

            $("#basic-message").html("请保存员工基本信息后再进行薪酬配置");
            $("#basic-message").fadeIn("fast");
            $("#basic-message").fadeOut(3000);

            return;
        }
        $(".tab-pane").hide();
        $(".nav-tabs li").removeClass("active");
        $(this).parent().addClass("active");

        $(id).show();
    });

    if ($("#Employee_Id").val() == "0") {
        EditBasicInfo();
        $("#User_Password").show();
    }
    else {
        CancelBasicInfo();
        $("#User_Password").hide();
        if ($("#User_IsAdmin").val().toLowerCase() == "true") {
            $("#User_LoginId").attr("readonly", "readonly");
            $('input:radio[name="User.IsActive"]').attr("disabled", "disabled");
        }
    }
})

function EditBasicInfo() {
    $(".et_field").show();
    $(".rs_field").hide();

    $("#btnEditBasicInfo").hide();
    $("#btnSaveBasicInfo").show();

    if ($("#Employee_Id").val() == "0") {
        $("#btnReturnBasicInfo").show();
        $("#btnCancelBasicInfo").hide();
    }
    else {
        $("#btnReturnBasicInfo").hide();
        $("#btnCancelBasicInfo").show();
    }
}

function CancelBasicInfo() {
    $(".et_field").hide();
    $(".rs_field").show();

    $("#btnEditBasicInfo").show();
    $("#btnReturnBasicInfo").show();

    $("#btnSaveBasicInfo").hide();
    $("#btnCancelBasicInfo").hide();
}

function SaveBasicInfo() {
    ClearErrorMsg("tab_1");

    if (checkRequired('tab_1', 'error-msg') == false) {
        return;
    }
    
    if ($('input:radio[name="User.IsActive"]:checked').val().toLowerCase() == "true") {
        if ($("#User_LoginId").val() == '') {
            SetErrorMsg("请填写登录账号", 'tab_1');
            $("#User_LoginId").addClass("redBorder");
            return;
        }
        else {
            if (!$("#User_LoginId").attr("readonly") == true) {
                 
                    if (!IsEmail($("#User_LoginId").val())) {
                        SetErrorMsg("登录账号必须为合法的Email", 'tab_1');
                        $("#User_LoginId").addClass("redBorder");
                        return;
                    }
                  
            }
                    
        }
    }

    var data = {};
    data.Id = $("#Employee_Id").val();
    data.EmployeeName = $("#Employee_EmployeeName").val();
    data.EmployeeNo = $("#Employee_EmployeeNo").val();
    data.DepartmentId = $("#Employee_DepartmentId").val();
    data.Position = $("#Employee_Position").val();
    data.Birthday = $("#Employee_Birthday").val();
    data.Gender = $('input:radio[name="Employee.Gender"]:checked').val();
    data.IdCardNo = $("#Employee_IdCardNo").val();
    data.OnboardDate = $("#Employee_OnboardDate").val();
    data.EmployeeType = $("#Employee_EmployeeType").val();
    data.EmployeeStatus = $("#Employee_EmployeeStatus").val();
    data.PositiveDate = $("#Employee_PositiveDate").val();
    data.LeaveDate = $("#Employee_LeaveDate").val();
    data.OfficePhone = $("#Employee_OfficePhone").val();
    data.Mobile = $("#Employee_Mobile").val();
    data.Email = $("#Employee_Email").val();
    data.Qualifications = $("#Employee_Qualifications").val();
    data.Country = $("#Employee_Country").val();
    data.Nationality = $("#Employee_Nationality").val();
    data.PoliticsStatus = $("#Employee_PoliticsStatus").val();
    data.MaritalStatus = $("#Employee_MaritalStatus").val();
    data.EmergencyContact = $("#Employee_EmergencyContact").val();
    data.EmergencyRelation = $("#Employee_EmergencyRelation").val();
    data.EmergencyPhone = $("#Employee_EmergencyPhone").val();
    data.FamilyAddress = $("#Employee_FamilyAddress").val();
    data.HuKou = $("#Employee_HuKou").val();
    data.Memo = $("#Employee_Memo").val();

    if (data.Email!='') {
        if (!IsEmail(data.Email)) {
            SetErrorMsg("请填写合法的Email", 'tab_1');
            $("#Employee_Email").addClass("redBorder");
            return;
        }
    }

    if (!confirm("确定保存员工信息吗？")) {
        return;
    }

    $.ajax({
        url: "/HR/SaveEmployee?isactive=" + $('input:radio[name="User.IsActive"]:checked').val().toLowerCase() + "&loginId=" + $("#User_LoginId").val() + "&password=" + $("#User_Password").val(),
        type: 'POST',
        cache: false,
        data: data,
        success: function (result) {

            if (result.code == 0) {
                location.href = "/HR/EmployeeDetail/" + result.data + "?message=1";
            }
            else if (result.code == 1) {
                SetErrorMsg("该Email已被其它用户使用");
                $("#User.LoginId").addClass("redBorder");
            }
            else if (result.code == 2) {
                SetErrorMsg("员工信息不存在");
            }
            else if (result.code == 3) {
                SetErrorMsg(result.message);
            }
            else {
                SetErrorMsg("员工信息保存失败，请稍后再试");
            }

        },
        error: function (e) {
            etErrorMsg("员工信息保存失败，请稍后再试");
        }
    });

}



function Save5x1j() {
    ClearErrorMsg("tab_2");

    if (checkRequired('table_5x1j', 'error-msg') == false) {
        return;
    }

    var data = {};
    data.EmployeeId = $("#Employee_Id").val();
    data.InsuranceBase = $("#InsuranceBase").val();
    data.HouseFundBase = $("#HouseFundBase").val();

    data.YangLao1 = $("#YangLao1").val();
    data.YangLao2 = $("#YangLao2").val();
    data.YiLiao1 = $("#YiLiao1").val();
    data.YiLiao2 = $('#YiLiao2').val();
    data.ShengYu1 = $("#ShengYu1").val();
    data.ShengYu2 = $("#ShengYu2").val();
    data.GongShang1 = $("#GongShang1").val();
    data.GongShang2 = $("#GongShang2").val();
    data.ShiYe1 = $("#ShiYe1").val();
    data.ShiYe2 = $("#ShiYe2").val();
    data.HouseFund1 = $("#HouseFund1").val();
    data.HouseFund2 = $("#HouseFund2").val();

    if (!confirm("确定保存吗？")) {
        return;
    }

    $.ajax({
        url: "/HR/SaveEmployeeSalaryBasicInfo",
        type: 'POST',
        cache: false,
        data: data,
        success: function (result) {

            if (result.code == 0) {

                $("#message-2").html("保存成功");
                $("#message-2").fadeIn("fast");
                $("#message-2").fadeOut(3000);

            }
            else {
                SetErrorMsg("保存失败，请稍后再试", "tab_2");
            }

        },
        error: function (e) {
            etErrorMsg("保存失败，请稍后再试", "tab_2");
        }
    });



}

function SaveBasicSetting() {
    ClearErrorMsg("tab_2");

    if (checkRequired('table_basic', 'error-msg') == false) {
        return;
    }

    var data = {};
    data.EmployeeId = $("#Employee_Id").val();

    data.HasSalary = $("#HasSalary").prop("checked");
    data.HasInsurance = $("#HasInsurance").prop("checked");
    data.HasHouseFund = $("#HasHouseFund").prop("checked");
    data.HasTax = $("#HasTax").prop("checked");
    data.BaseSalary = $("#BaseSalary").val();
    data.InsuranceBase = $("#InsuranceBase").val();
    data.HouseFundBase = $("#HouseFundBase").val();

    data.YangLao1 = $("#YangLao1").val();
    data.YangLao2 = $("#YangLao2").val();
    data.YiLiao1 = $("#YiLiao1").val();
    data.YiLiao2 = $('#YiLiao2').val();
    data.ShengYu1 = $("#ShengYu1").val();
    data.ShengYu2 = $("#ShengYu2").val();
    data.GongShang1 = $("#GongShang1").val();
    data.GongShang2 = $("#GongShang2").val();
    data.ShiYe1 = $("#ShiYe1").val();
    data.ShiYe2 = $("#ShiYe2").val();
    data.HouseFund1 = $("#HouseFund1").val();
    data.HouseFund2 = $("#HouseFund2").val();

    if (!confirm("确定保存吗？")) {
        return;
    }

    $.ajax({
        url: "/HR/SaveEmployeeSalaryBasicInfo",
        type: 'POST',
        cache: false,
        data: data,
        success: function (result) {

            if (result.code == 0) {

                $("#message-1").html("保存成功");
                $("#message-1").fadeIn("fast");
                $("#message-1").fadeOut(3000);

            }
            else {
                SetErrorMsg("保存失败，请稍后再试", "tab_2");
            }

        },
        error: function (e) {
            etErrorMsg("保存失败，请稍后再试", "tab_2");
        }
    });

}

function NewTr() {
    return $("<tr></tr>");
}

function NewTd() {
    return $("<td></td>");
}