﻿var trId = "";
var isAdd = true;

function EditDepartment(Id) {
    isAdd = false;   

    clearForm();

    $.ajax({
        url: "/HR/GetDepartment",
        type: 'GET',
        cache: false,
        data: { Id: Id },
        success: function (result) {
            if (result.code == 0) {
                $("#DepartmentName").val(result.data.DepartmentName);
                $("#Id").val(result.data.Id);
                $("#Memo").val(result.data.Memo);                
                showDepartment();
            }
            else {
                alert(result.message);
            }

        },
        error: function (e) {
            alert("查找部门信息失败");
        }
    });

    return false;
}

function DeleteDepartment(Id) {

    synConfirm("确定删除吗？", function () {
        $.ajax({
            url: "/HR/DeleteDepartment",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    location.href = '/HR/Department';
                }
                else {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('该部门已产生业务数据，无法删除。');
            }
        });
    });

    return false;
}

 
$(function () {

    setOperationBtns();
 

    TdRowOverOut("tDepartment");

    $('#divDepartment').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });
 

    $('#btnNew').click(function () {
        isAdd = true;      
        clearForm();
        showDepartment();
    });

    $('#btnCancel').click(function () {
        $('#divDepartment').dialog('close');
    }); 
 
 
    $('#btnSave').click(function () {

        if (isAdd) {
            if (checkRequired('divDepartment', 'errorMessage') == false) {
                return;
            } 

            $.ajax({
                url: "/HR/AddDepartment",
                type: 'POST',
                cache: false,
                data: {
                    DepartmentName: $("#DepartmentName").val(), Memo: $("#Memo").val()
                },
                success: function (result) {
                    if (result.code == 0) {
                        closeDepartment();
                        location.href = "/HR/Department";
                    }
                    else {
                        SetErrorMsg(result.message, "divDepartment");
                    }
                },
                error: function (e) {
                    SetErrorMsg("保存失败", "divDepartment");
                }
            });
        }
        else {
            if (!checkRequired('divDepartment', 'errorMessage')) {
                return;
            }

            synConfirm("确定保存修改吗？", function () {
                $.ajax({
                    url: "/HR/UpdateDepartment",
                    type: 'POST',
                    cache: false,
                    data: {
                        Id: $("#Id").val(), DepartmentName: $("#DepartmentName").val(),Memo: $("#Memo").val()
                    },
                    success: function (result) {
                        if (result.code == 0) {
                            closeDepartment();
                            location.href = "/HR/Department";
                        }
                        else {
                            SetErrorMsg(result.message, "divDepartment");
                        }
                    },
                    error: function (e) {
                        SetErrorMsg("保存失败", "divDepartment");
                    }
                });
            });
        }
    });
});

function showDepartment() {
    $('#divDepartment').dialog('open');
}

function closeDepartment() {
    $('#divDepartment').dialog('close');
}
function clearForm() {
    $("input").removeClass("redBorder");
    $("input[type=text]").val("");
    $("textarea").val("");
}

