﻿var previousValue;
 

$(function () {    

    $("#destinationCustomerNo").select2();
    $("#sourceCustomerNo").select2();
    $("#sMaterialId").select2();
    $("#sCustomerNo").select2();

    TdRowOverOut("tbody");

    $('#divCopy').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $("#btnCopy").click(function () {
        ClearErrorMsg();
        $("#sourceCustomerNo").val($("#sCustomerNo").val()).select2();
        $('#divCopy').dialog('open');
    });


    bindEvents();
   
});

function checkSearch() {
    if ($("#sMaterialId").val() == "" && $("#sCustomerNo").val() == ""){
        SetErrorMsg("请选择要查询的材料或客户");
        return false;
    }

    return true;
}

function copyPrice() {

    ClearErrorMsg();

    if (checkRequired('divCopy', 'errorMessage') == false) {
        return;
    }
    if ($("#sourceCustomerNo").val()=="") {
        SetErrorMsg("请选择源客户", "divCopy");
        return;
    }
    if ($("#destinationCustomerNo").val() == "") {
        SetErrorMsg("请选择目标客户", "divCopy");
        return;
    }

    if ($("#sourceCustomerNo").val() == $("#destinationCustomerNo").val()) {
        SetErrorMsg("源客户和目标客户不能相同", "divCopy");
        return;
    }
    
    var destinationC = $("#destinationCustomerNo").find("option:selected").text();

    synConfirm("确定复制吗？<br><b>提示：此操作将删除[" + destinationC + "]之前的报价信息!</b>", function () {

        $.ajax({
            url: "/WareHouse/CopyCustomerPrice",
            type: 'POST',
            cache: false,
            data: {
                sourceCustomerNo: $("#sourceCustomerNo").val(), destinationCustomerNo: $("#destinationCustomerNo").val()},
            success: function (result) {
                if (result.code == 0) {
                    $('#divCopy').dialog('close');             
                    $("#sMaterialId").val("");
                    $("#sCustomerNo").val($("#destinationCustomerNo").val());
                    $("#btnSearch").click();

                }
                else {
                    SetErrorMsg(result.message,"divCopy");
                }
            },
            error: function (e) {
                SetErrorMsg("复制价格失败，请稍候再试", "divCopy");
            }
        });
    });
}


function bindEvents() {
    $("#tbody input[type=text]").focus( function () {        
        previousValue = $(this).val();      
    }).change(function () {

        var customerNo = $(this).parent().parent().find("#hCustomerNo").val();
        var materialId = $(this).parent().parent().find("#hMaterialId").val();
        var sailPrice = $(this).val();
        var sailPriceInput = $(this);
        var td = $(this).parent();

        if (sailPrice != "" && isNaN(sailPrice)) {
            sailPriceInput.addClass("red-text");
        }
        else if ((sailPrice && !isNaN(sailPrice))|| sailPrice=="") {

            $.ajax({
                url: "/WareHouse/UpdateCustomerPrice",
                type: 'POST',
                cache: false,
                data: {
                    customerNo: customerNo, materialId: materialId, sailPrice: sailPrice
                },
                success: function (result) {
                    if (result.code == 0) {
                        if (result.data != null) {
                            sailPriceInput.val(result.data);
                        }
                        updateSuccess(td);
                    }
                    else {                       
                        updateFailed(td);
                    }
                },
                error: function (e) {
                  
                    updateFailed(td);
                   
                }
            });
        }        
    });
}



function updateSuccess(td) {
    $(td).find("input").removeClass("red-text");
    $(td).find(".priceMsg").fadeIn("fast");
    $(td).find(".priceMsg").fadeOut("3000");
}

function updateFailed(td) {
    $(td).find("input").addClass("red-text");
    $(td).find(".priceMsg1").fadeIn("fast");
    $(td).find(".priceMsg1").fadeOut("3000");
}



function downExcel() {
    if ($("#sMaterialId").val() == "" && $("#sCustomerNo").val() == "") {
        SetErrorMsg("请选择要查询的材料或客户");
        return false;
    }
    location.href = "/Warehouse/GetCustomerPriceExcel?sMaterialId=" + $("#sMaterialId").val() + "&sCustomerNo=" + $("#sCustomerNo").val();
}