﻿ 
$(function () {
    
    TdRowOverOut("tDeposite");   
  
    $("#CustomerNo").select2();
    $("#divDeposite #CustomerNo").select2();

    $("#sb").attr("readonly", "readonly");
    $("#se").attr("readonly", "readonly");
    
    $("#sb").datepicker({ dateFormat: 'yy-mm-dd' });
    $("#se").datepicker({ dateFormat: 'yy-mm-dd' }); 

    $("#sb,#se").dblclick(function () {
        $(this).val("");
    });

    $("#RealAmount").inputmask({ 'mask': "-{0,1}9{0,9}[.9{0,2}]", greedy: false });
    $("#FreeAmount").inputmask({ 'mask': "-{0,1}9{0,9}[.9{0,2}]", greedy: false });

    $('#divDeposite').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#btnNew').click(function () {      
        clearForm();
        showDeposite(); 
    });

    $('#btnReturn').click(function () {
        //location.href = "/Customer"
        history.go(-1);
    });
    

    $('#btnCancel').click(function () {
        $('#divDeposite').dialog('close');
    });


    $('#btnSave').click(function () {
    
            if (checkRequired('divDeposite', 'errorMessage') == false) {
                return;
            }          
            if ($("#divDeposite #CustomerNo").val() == "") {
                return SetErrorMsg("请选择客户", "divDeposite");
            }


            $("#btnSave").attr({ "disabled": "disabled" });

            var data = {};
            data.CustomerNo = $("#divDeposite #CustomerNo").val();
            data.RealAmount = $("#divDeposite #RealAmount").val();
            data.FreeAmount = $("#divDeposite #FreeAmount").val();
            data.Memo = $("#divDeposite #Memo").val();           
           
            if (data.FreeAmount == "") {
                data.FreeAmount = 0;
            }

            $.ajax({
                url: "/Customer/AddDeposite",
                type: 'POST',
                cache: false,              
                data: data,
                success: function (result) {
                    $("#btnSave").removeAttr("disabled")
                    if (result.code == 0) {
                        closeDeposite();
                        location.reload();
                    }
                    else {
                       SetErrorMsg(result.message,"divDeposite");
                    }
                },
                error: function (e) {
                    $("#btnSave").removeAttr("disabled")                    
                    SetErrorMsg("保存失败.", "divDeposite");
                }
            });      
 
    });
});

function showDeposite() {
    $('#divDeposite').dialog('open');
}

function closeDeposite() {
    $('#divDeposite').dialog('close');
}

function clearForm() {
    $("input").removeClass("redBorder");
    $("input[type=text]").val("");
    $("textarea").val(""); 
    ClearErrorMsg();    
}
 