﻿var customer_color;

function EditCategory(Id, Name, Color) {

    ClearErrorMsg();    
    $("#Name").val(Name);
    $("#Id").val(Id);    
    setCxColor(Color);
    showCategory();  
}

function DeleteCategory(Id) {

    ClearErrorMsg();     

    synConfirm("确定删除吗？", function () {
        $.ajax({
            url: "/Customer/DeleteCategory",
            type: 'POST',
            cache: false,
            data: { Id: Id },
            success: function (result) {
                if (result.code == 0) {
                    $("#tCategory").find("tr[id='" + Id + "']").remove();
                }
                else if (result.code==1) {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('删除失败：该分类已产生业务数据，无法删除');
            }
        });
    });    

    return false;
}

$(function () {

    setOperationBtns();


    customer_color = $('#category_color');
    console.log(customer_color);
    customer_color.cxColor(); 
    console.log(customer_color);
    
    TdRowOverOutSpecify("tCategory");
    TdRowOverOut("tCategory");

    $('#divCategory').dialog({
        width:400,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    }); 
 

    $('#btnNew').click(function () {
        $("#Name").val('');
        $("#Id").val('');
        setCxColor("");
        showCategory();        
    });   


    $('#btnSave').click(function () {        
        if (!$("#Id").val()) {
            if (checkRequired('divCategory', 'errorMessage') == false) {
                return;
            }
 
            synConfirm("确定保存吗？", function () {

                $.ajax({
                    url: "/Customer/CategoryAdd",
                    type: 'POST',
                    cache: false,
                    data: {
                        Name: $("#Name").val(),
                        Color: customer_color.val()
                    },
                    success: function (result) {
                        if (result.code == 0) {
                            closeCategory();                          
                            location.href = "/Customer/Category";
                        }
                        else {
                            SetErrorMsg(result.message,"divCategory");
                        }
                    },
                    error: function (e) {                        
                        SetErrorMsg("保存失败", "divCategory");
                    }
                })
            });     
        }
        else {
            if (!checkRequired('divCategory', 'errorMessage')) {
                return;
            }

            synConfirm("确定保存修改吗？", function () {
                $.ajax({
                    url: "/Customer/CategoryUpdate",
                    type: 'POST',
                    cache: false,
                    data: {
                        Id: $("#Id").val(),
                        Name: $("#Name").val(),
                        Color: customer_color.val()
                    },
                    success: function (result) {
                        if (result.code == 0) {
                            closeCategory();
                            location.href = "/Customer/Category";
                        }
                        else {
                            SetErrorMsg(result.message, "divCategory");                             
                        }
                    },
                    error: function (e) {
                        SetErrorMsg("保存失败.","divCategory");
                    }
                });
            });

           
        }
    });
});

function showCategory() {
    ClearErrorMsg();
    //console.log(customer_color.cxColor());
    //customer_color.api.color($("#Color").val()); 
    $('#divCategory').dialog('open');
}

function closeCategory() {
    $('#divCategory').dialog('close');
}
 
function setCxColor(color) {
    if (color) {
        customer_color.css("background-color", color);
        customer_color.css("color", color);
        customer_color.val(color);
    }
    else {
        customer_color.css("background-color", "");
        customer_color.css("color", "");
        customer_color.val(color);
    }
    

}