﻿var prices = [];
var paymentType = 9;

$(function () {
    var price = $("#hidPrice").val();
    prices = price.split(','); //30,9,7.5,6
    
    $(".content-wrapper").css("background-color", "#fff");

    var numbers = $(".online-payment .table-payment .pay-number div");

    for (var i = 0; i < 3; i++) {
        $(numbers[9+i]).attr("title", "购买" +(i+1) + "年，立享官网价格" + prices[1+i] + "折");
    }    

    $(numbers).click(function () {
        var c = $(this);
       
        var allN = c.parent().find("div");
        allN.removeClass("selected");

        $(allN).each(function (i, v) {
            if (i < 9) {
                $(v).text($(v).text().replace("个月", ""));
            }            
        });

        c.addClass("selected");

        var index = $(this).index();
        paymentType = index;
        if (index < 9 && c.text().indexOf("个月") < 0) {
            c.text(c.text() + "个月");
        }
        calcPrice(index)
       
    });

    calcPrice(9);


    $("#btnYes").click(function () {
        $.unblockUI();
        location.href = "/System/CompanyPayment";
    });

    $("#btnNo").click(function () {
        $.unblockUI();
        location.href = "/System/CompanyPayment";
    });

});

function calcPrice(index) {
    var amount = 0;
    var ramount = 0;
    if (index < 9) {
        amount = toDecimal2(parseFloat(prices[0]) * (index + 1));
    }
    else if (index == 9) {
        amount = toDecimal2(parseFloat(prices[0]) * 12 * prices[1] / 10.0);
        ramount = toDecimal2(parseFloat(prices[0]) * 12 - amount);
    }
    else if (index == 10) {
        amount = toDecimal2(parseFloat(prices[0]) * 24 * prices[2] / 10.0);
        ramount = toDecimal2(parseFloat(prices[0]) * 24 - amount);
        console.log(ramount);
    }
    else {
        amount = toDecimal2(parseFloat(prices[0]) * 36 * prices[3] / 10.0);
        ramount = toDecimal2(parseFloat(prices[0]) * 36 - amount);
    }    

    $(".yuan1").text("￥" + amount);
    if (ramount > 0) {
        $(".yuan2").text("省￥" + ramount);
    }
    else {
        $(".yuan2").text("");
    }
}

function goNext() {
     
    // input validation 
    if ($("#hidVip").val() == "1") {
        return SetErrorMsg("VIP账号，无效续费");
    }
 
    var amount = $(".yuan1").text().trim().replace("￥", "");
    var channel = $("input[name='channel']:checked").val();

    $.ajax({
        url: "/System/CompanyPaymentCreate",
        type: 'POST',
        cache: false,
        data: { paymentType:paymentType,amount:amount,channel:channel},
        dataType: 'json',
        async: false,
        success: function (result) {
            console.log(result);
            if (result.code == 0) {      
                $.blockUI({ message: $('#company-pay-question'), css: { width: '380px' } });                
                window.open("http://localhost:58400/System/CompanyPaymentPay?id=" + result.data, "_blank");                
            }
            else if (result.code == 1) {
                SetErrorMsg("VIP账号，无效续费");
            }
            else if (result.code == 2) {
                SetErrorMsg("金额不正确，请按F5键刷新页面后重新操作");
            }
            else {
                SetErrorMsg("发起支付请求失败，请稍后再试");
            }
            
        },
        error: function (e) {            
            SetErrorMsg("发起支付请求失败，请稍后再试");
        }
    }); 
}

function continuePay(id) {

}