﻿var CompanyAccountNo = "";
var trId = "";
var isAdd = true;

function EditCompanyAccount(CompanyAccountNo) {
    isAdd = false;

    clearForm(isAdd);

    $.ajax({
        url: "/Finance/GetCompanyAccount",
        type: 'GET',
        cache: false,
        data: { CompanyAccountNo: CompanyAccountNo },
        success: function (result) {
            if (result.CompanyAccountNo != "") {
                $("#Memo").val(result.Memo);
                $("#TransactionDate").val(result.TransactionDateStr);
                $("#CompanyAccountNo").val(result.CompanyAccountNo);
                $("#CompanyAccountNo").val(result.CompanyAccountNo);
                $("#AccountTitleNo").val(result.AccountTitleNo).trigger("change");
                $("#Amount").val(result.Amount);
                showCompanyAccount();
            }

        },
        error: function (e) {
        }
    });

    return false;
}


function DeleteCompanyAccount(CompanyAccountNo) {

    synConfirm('确定删除收支记录 [' + CompanyAccountNo + '] 吗？', function () {
        $.ajax({
            url: "/Finance/DeleteCompanyAccount",
            type: 'POST',
            cache: false,
            data: { CompanyAccountNo: CompanyAccountNo },
            success: function (result) {
                if (result.code == 0) {
                    location.reload();
                }
                else {
                    alert(result.message);
                }

            },
            error: function (e) {
                alert('删除失败');
            }
        });
    });

    return false;
}



$(function () {


    setOperationBtns();

    TdRowOverOut("tFinance");

    $("#CompanyAccountNo").attr("readonly", "readonly");
    $("#sb").attr("readonly", "readonly");
    $("#se").attr("readonly", "readonly");
    $("#TransactionDate").attr("readonly", "readonly");
    $("#sb").datepicker({ dateFormat: 'yy-mm-dd' });
    $("#se").datepicker({ dateFormat: 'yy-mm-dd' });
    $("#TransactionDate").datepicker({ dateFormat: 'yy-mm-dd' });

    $("#sb,#se,#TransactionDate").dblclick(function () {
        $(this).val("");
    });

    $("#Amount").inputmask({ 'mask': "9{0,9}[.9{0,2}]", greedy: false });

    $('#divCompanyAccount').dialog({
        width: 500,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });

    $('#btnNew').click(function () {
        isAdd = true;
        clearForm(isAdd);
        showCompanyAccount();
        $("#CompanyAccountNo").val("自动编号");
    });

    $('#btnCancel').click(function () {
        $('#divCompanyAccount').dialog('close');
    });

    $('#btnSave').click(function () {

        if (isAdd) {

            if (!$("#AccountTitleNo").val()) {
                return SetErrorMsg("请选择科目", "divCompanyAccount");
            }

            if (checkRequired('divCompanyAccount', 'errorMessage') == false) {
                return;
            }
            $("#btnSave").attr({ "disabled": "disabled" });

            $.ajax({
                url: "/Finance/AddCompanyAccount",
                type: 'POST',
                cache: false,
                data: $('form').serialize(),
                success: function (result) {
                    $("#btnSave").removeAttr("disabled")
                    if (result.code == 0) {
                        closeCompanyAccount();
                        location.href = "/Finance/InAndOut";
                    }
                    else {
                        $("#errorMessage").text(result.message);
                    }
                },
                error: function (e) {
                    $("#btnSave").removeAttr("disabled")
                    $("#errorMessage").text("保存失败.");
                }
            });


        }
        else {

            if (!$("#AccountTitleNo").val()) {
                return SetErrorMsg("请选择科目", "divCompanyAccount");
            }

            if (!checkRequired('divCompanyAccount', 'errorMessage')) {
                return;
            }

            synConfirm("确定保存修改吗？", function () {

                $("#btnSave").attr({ "disabled": "disabled" });

                $.ajax({
                    url: "/Finance/UpdateCompanyAccount",
                    type: 'POST',
                    cache: false,

                    data: $('form').serialize(),
                    success: function (result) {
                        $("#btnSave").removeAttr("disabled")
                        if (result.code == 0) {
                            closeCompanyAccount();
                            location.reload();
                        }
                        else {
                            $("#errorMessage").text(result.message);
                        }
                    },
                    error: function (e) {
                        $("#btnSave").removeAttr("disabled")
                        $("#errorMessage").text("保存失败.");
                    }
                });

            });
        }
    });

    $("#btnExportExcel").click(function () {

        if (!checkField()) {
            return;
        }
        location.href = "/Finance/GetInAndOutExcel?km=" + $("#km").val() + "&sb=" + $("#sb").val() + "&se=" + $("#se").val() +
            "&kl=" + $("#kl").val() + "&sk=" + $("#sk").val() + "&sUserName=" + $("#sUserName").val();
    });

    $("#km").select2();
    $("#AccountTitleNo").select2();

});

function checkField() {
    ClearErrorMsg();

    if ($('#sb').val() == "") {
        $("#sb").addClass("redBorder");
        return false;
    }

    if ($('#se').val() == "") {
        $("#se").addClass("redBorder");
        return false;
    }

    else if (DateDiff($("#sb").val(), $("#se").val()) > 93) {
        SetErrorMsg("提示：起止时间跨度最多为3个月。如果时间跨度超过3个月，请分多次查询。");
        return false;
    }
    else {
        return true;
    }
}


function showCompanyAccount() {
    $('#divCompanyAccount').dialog('open');
}

function closeCompanyAccount() {
    $('#divCompanyAccount').dialog('close');
}

function clearForm(isAdd) {
    $("input").removeClass("redBorder");
    $("input[type=text]").val("");
    $("textarea").val("");
    ClearErrorMsg();
    if (isAdd) {
        $("#CompanyAccountName").focus();
    }
    else {
        $("#CompanyAccountName").focus();
    }

    $("#AccountTitleNo").val("").trigger("change");
}

