﻿$(function () {

    $("#chart-no-data").hide();
    $("#chartcontainer").hide();
    $("#chartcontainer1").hide();

    GetOrderData();
    GetOrderData1();

});


function GetOrderData() {

    $.ajax({
        url: "/Chart/GetOrderAgingData",
        type: 'GET',
        cache: false,
        data: {},
        success: function (result) {
            if (result.code == 0) {
                $("#chartcontainer").show();
                RefreshChart(result.data);
            }
            else if (result.code == 1) {
                $("#chart-no-data").show();
            }
            else {
                alert("获取数据失败");
            }

        },
        error: function (e) {
            alert("获取数据失败");
        }
    });

}

function GetOrderData1() {

    $.ajax({
        url: "/Chart/GetCustomerAgingData",
        type: 'GET',
        cache: false,
        data: {},
        success: function (result) {
            if (result.code == 0) {
                $("#chartcontainer1").show();
                RefreshChart1(result.data);
            }
            else if (result.code == 1) {
                $("#chart-no-data").show();
            }
            else {
                alert("获取数据失败");
            }

        },
        error: function (e) {
            alert("获取数据失败");
        }
    });

}

function RefreshChart(data) {
    if (data.Series[0].data.length == 0) {
        $("#chart-no-data").show();
        $('#chartcontainer').hide();
        return;
    }
    $("#chart-no-data").hide();
    $('#chartcontainer').show();

    $('#chartcontainer').highcharts({
        chart: {
            type: 'pie'
        },
        title: {
            text: "订单账龄分析"
        },
        subtitle: {
            text: '客户欠款 '
        },

        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: true,
                    format: '<b>{point.name}</b>: {point.y} 元',
                    style: {
                        color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                    }
                }
            }
        },

        series: data.Series
    });
}

function RefreshChart1(data) {

    $('#chartcontainer').show();

    $('#chartcontainer1').highcharts({
        chart: {
            type: 'column'
        },
        title: {
            text: "客户欠费统计图"
        },
        subtitle: {
            text: '欠费金额前15位客户'
        },
        xAxis: {
            categories: data.Categories,
            crosshair: true
        },
        yAxis: {
            min: 0,
            title: {
                text: '欠费金额 (元)'
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            '<td style="padding:0"><b>{point.y:.1f} 元</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        series: data.Series
    });
}