﻿$(function () { 

    $("#sc").select2();

    $("#btnOK").click(function(){
        if (checkRequired('dSearch', '') == false) {
            return false;
        }
        GetPerformanceData();
    });

});


function GetPerformanceData() {
    $.blockUI({ message: '<h5>请稍候...</h5>' });
    $.ajax({
        url: "/Chart/GetCustomerPerformanceData",
        type: 'GET',
        cache: false,
        data: {sc:$("#sc").val() },
        success: function (result) {
            $.unblockUI();
            if (result.code == 0) {
                RefreshChart(result.data);
            }
            else {
                alert("获取数据失败");
            }

        },
        error: function (e) {
            $.unblockUI();
            alert("获取数据失败");
        }
    });

}

function RefreshChart(data) {
    if (data.Categories.length < 5) {
        $("#chart-no-data").show();
        $('#chartcontainer').hide();
        return;
    }
    $("#chart-no-data").hide();
    $('#chartcontainer').show();

    $('#chartcontainer').highcharts({
        chart: { type: "spline" },
        title: {
            text: $("#sc").find("option:selected").text() +  ' 近两年业绩（逐月）',
            x: -20 //center
        },
        subtitle: {
            text: '',
            x: -20
        },
        xAxis: {
            categories: data.Categories,
            tickInterval:1
        },
        yAxis: {
            title: {
                text: '订单金额 (元)'
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        tooltip: {
            valueSuffix: '元'
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'middle',
            borderWidth: 0
        },
        series: data.Series
    });
}