﻿$(function () {    
    $("#btnOK").click(function () {

        if (checkRequired('dSearch', '') == false) {
            return false;
        }
        GetCustomerData();
    });

    GetCustomerData();

});
function checkField() {
    if (checkRequired('dSearch', '') == false) {
        return false;
    }

    return true;
}


function GetCustomerData() {

    $.ajax({
        url: "/Chart/GetCustomerData",
        type: 'GET',
        cache: false,
        data: { sb: $("#sb").val(), se: $("#se").val() },
        success: function (result) {
            if (result.code == 0) {
                RefreshChart(result.data);
            }
            else {
                alert("获取数据失败");
            }

        },
        error: function (e) {
            alert("获取数据失败");
        }
    });

}

function RefreshChart(data) {
    if (data.Categories.length < 3) {
        $("#chart-no-data").show();
        $('#chartcontainer').hide();
        return;
    }
    $("#chart-no-data").hide();
    $('#chartcontainer').show();

    $('#chartcontainer').highcharts({
        chart: {
            type: 'column'
        },
        title: {
            text: "客户业务量（前15位）"
        },
        subtitle: {
            text: '起止: ' + $("#sb").val() + ' ~ ' + $("#se").val()
        },
        xAxis: {
            categories: data.Categories,
            crosshair: true
        },
        yAxis: {
            min: 0,
            title: {
                text: '订单金额 (元)'
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y:.1f} 元</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        series: data.Series
    });
}