(function ($) {

    function calendarWidget(el, params) {

        var now = new Date();
        var thismonth = now.getMonth();
        var thisyear = now.getYear() + 1900;
        var thisday = now.getDate();

        var opts = {
            month: thismonth,
            year: thisyear
        };

        $.extend(opts, params);

        var monthNames = ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'];
        var dayNames = ['日', '一', '二', '三', '四', '五', '六'];
        month = i = parseInt(opts.month);
        year = parseInt(opts.year);
        var m = 0;
        var table = '';

        // next month
        if (month == 11) {
            var next_month = '<a href="?month=' + 1 + '&amp;year=' + (year + 1) + '" title="' + monthNames[0] + ' ' + (year + 1) + '">' + monthNames[0] + ' ' + (year + 1) + '</a>';
        } else {
            var next_month = '<a href="?month=' + (month + 2) + '&amp;year=' + (year) + '" title="' + monthNames[month + 1] + ' ' + (year) + '">' + monthNames[month + 1] + ' ' + (year) + '</a>';
        }

        // previous month
        if (month == 0) {
            var prev_month = '<a href="?month=' + 12 + '&amp;year=' + (year - 1) + '" title="' + monthNames[11] + ' ' + (year - 1) + '">' + monthNames[11] + ' ' + (year - 1) + '</a>';
        } else {
            var prev_month = '<a href="?month=' + (month) + '&amp;year=' + (year) + '" title="' + monthNames[month - 1] + ' ' + (year) + '">' + monthNames[month - 1] + ' ' + (year) + '</a>';
        }

        table += ('<h3 style="display:inline;padding-right:10px;" id="current-month">' + year + '年' + monthNames[month] + '</h3>');
        table += " <div class='btn-group'><button class='btn btn-sm btn-default' onclick='preMonth()'><上月</button>";
        table += "<button class='btn btn-sm btn-default' onclick='nextMonth()'>下月></button></div>";
        
        table += "<button class='btn btn-sm btn-default' onclick=\"javascript:location.href='/MySpace/ToDoList'\"  style='margin-left:10px;'>高级搜索</button>";
        table += "<button class='btn btn-sm btn-warning' onclick=\"javascript:location.href='/MySpace/ToDoList?ss=1'\"  style='margin-left:10px;'>代办事项</button>";
        // uncomment the following lines if you'd like to display calendar month based on 'month' and 'view' paramaters from the URL
        //table += ('<div class="nav-prev">'+ prev_month +'</div>');
        //table += ('<div class="nav-next">'+ next_month +'</div>');
        table += ('<table class="calendar-month " ' + 'id="calendar-month' + i + ' " cellspacing="0">');

        table += '<tr>';

        for (d = 0; d < 7; d++) {
            table += '<th class="weekday">' + dayNames[d] + '</th>';
        }

        table += '</tr>';

        var days = getDaysInMonth(month, year);
        var firstDayDate = new Date(year, month, 1);
        var firstDay = firstDayDate.getDay();

        var prev_days = getDaysInMonth(month, year);
        var firstDayDate = new Date(year, month, 1);
        var firstDay = firstDayDate.getDay();

        var prev_m = month == 0 ? 11 : month - 1;
        var prev_y = prev_m == 11 ? year - 1 : year;
        var prev_days = getDaysInMonth(prev_m, prev_y);
        firstDay = (firstDay == 0 && firstDayDate) ? 7 : firstDay;

        var i = 0;

        var startDay = prev_y + "-" + (prev_m + 1) + "-" + (prev_days - firstDay + 1);

        for (j = 0; j < 42; j++) {

            if ((j < firstDay)) {
                table += ('<td class="other-month"><span class="day">' + (prev_days - firstDay + j + 1) + '</span></td>');
            } else if ((j >= firstDay + getDaysInMonth(month, year))) {
                i = i + 1;
                table += ('<td class="other-month"><span class="day">' + i + '</span></td>');
            } else {
                if (thisday == (j - firstDay + 1) && year == thisyear && month == thismonth) {
                    table += ('<td class="current-month today day' + (j - firstDay + 1) + '"><span class="day">' + (j - firstDay + 1) + '</span></td>');
                }
                else {
                    table += ('<td class="current-month day' + (j - firstDay + 1) + '"><span class="day">' + (j - firstDay + 1) + '</span></td>');
                }

            }
            if (j % 7 == 6) table += ('</tr>');
        }

        table += ('</table>');

        el.html(table);
        getData(startDay);
    }


    function getData(date) {
        $.blockUI({ message: '<h5>Loading...</h5>' });
        $.ajax({
            url: "/MySpace/GetMonthToDo?date=" + date,
            type: 'GET',
            cache: false,
            dataType: 'json',
            async: false,
            success: function (result) {
                $.unblockUI();
                showData(result.data);
            },
            error: function (e) {
                $.unblockUI();
            }
        });
    }

    function showData(data) {

        var tds = $("#calendar").find("tbody").find("td");
        tds = $(tds);

        for (var i = 0; i < 42; i++) {

            if (data[i].type > 0) {
                var span = $('<span class="' + (data[i].type == 1 ? 'red-tip' : 'blue-tip') + '">' + data[i].number + '</span>');
                //$(tds[i]).attr("title", data[i].items);
                span.appendTo(tds[i]);
            }

            var tdClick = function (el, index) {
                el.onclick = function () {
                    location.href = "/MySpace/ToDoList?sb=" + data[index].date + "&se=" + data[index].date;
                };
            };

            tdClick(tds[i], i);

            var span1 = $('<span class="add-tip">+</span>');

            var addClick = function (el, index) {
                el.onclick = function (event) {
                    event.stopPropagation();
                    addToDo(data[index].date);
                };
            };

            addClick(span1[0], i);
            span1.appendTo(tds[i]);
        }
    }

    function getDaysInMonth(month, year) {
        var daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        if ((month == 1) && (year % 4 == 0) && ((year % 100 != 0) || (year % 400 == 0))) {
            return 29;
        } else {
            return daysInMonth[month];
        }
    }

    // jQuery plugin initialisation
    $.fn.calendarWidget = function (params) {
        calendarWidget(this, params);
        return this;
    };

})(jQuery);