﻿function Backup() { 

    if (!confirm("确定开始备份吗？")) {
        return;
    }

    $.blockUI({ message: '<h5>备份可能需要较多时间，请耐心等待...</h5>' });
    $.ajax({
        url: "/System/BackupDatabase",
        type: 'Post',
        cache: false,       
        success: function (result) {
            $.unblockUI();
            if (result.code == 0) {
                location.href = "/System/BackupDB?message=1";
            }
            else {
                SetErrorMsg("备份数据库失败");
            }


        },
        error: function (e) {
            $.unblockUI();
            SetErrorMsg("备份数据库失败");
        }
    });    
}



function Delete(fileName) {
    
    if (!confirm("确定删除备份文件[" + fileName + "]吗？")){
        return;
    }

    $.ajax({
        url: "/System/DeleteBackupFile",
        type: 'Post',
        cache: false,
        data: {
            fileName: fileName},
        success: function (result) {
            if (result.code == 0) {
                location.href = location.href;
            }
            else {
                SetErrorMsg("删除备份文件失败。");
            }


        },
        error: function (e) {
            SetErrorMsg("删除备份文件失败");
        }
    });

}

 