﻿var inUploading = false;
$(function () {

    $('#divDetail').dialog({
        width: 960,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });
 

    $('#divAttachment').dialog({
        width: 700,
        autoOpen: false,
        modal: true,
        buttons: {
        }
    });


    $("#btnUpload").click(function () {
        ajaxFileUpload();
    });

 
});


function ShowDetail(id) {
    ClearErrorMsg();

    $("#OrderNo").val(id);
    $.ajax({
        url: "/Portal/GetDetail",
        type: 'POST',
        cache: false,
        data: { OrderNo: id },
        success: function (result) {
            if (result.code == 0) {
                $("#dStatus").html(result.data.StatusDescription);

                $("#dPaymentStatus").html(result.data.PaymentStatusDescription);
                $("#dPaymentStatus").removeClass();

                if (result.data.PaymentStatus == 1) {
                    $("#dPaymentStatus").addClass("OrderStatusUnPaid");
                }
                else if (result.data.PaymentStatus == 2) {
                    $("#dPaymentStatus").addClass("OrderStatusUnPaid");
                }
                else {
                    $("#dPaymentStatus").addClass("OrderStatusPaid");
                }

                $("#dPayment").html(result.data.Payment);

                $("#dOrderNo").html(result.data.OrderNo);
                $("#dOrderName").html(result.data.OrderName);
                $("#dCustomer").html(result.data.CustomerShortName);
                $("#dContact").html(result.data.Contact);         

                $("#dIsInvoiced").html(result.data.IsInvoiced ? "已开票" : "未开票");
                $("#dTaxInfo").html(result.data.TaxInfo);

                $("#dMarketAmount").html(result.data.MarketAmount);
                $("#dDiscount").html(result.data.Discount);
                $("#dPaid").html(result.data.Paid);
                $("#dAmount").html(result.data.Amount);

                $("#dCreatedTime").html(result.data.CreatedTimeString);
                $("#dTransactionDate").html(result.data.TransactionDateString);
                $("#dCreator").html(result.data.Creator);
               
                $("#dNumber").html(result.data.Number);
                $("#dExpectDeliveryDate").html(result.data.ExpectDeliveryDateString);

                $("#dMemo").html(result.data.Memo);
                $("#dDeliveryType").html(result.data.DeliveryType);
                $("#dDeliveryAddress").html(result.data.DeliveryAddress);

                GenerateWorkFlowSteps(result.data.steps);

                var table = $("#tableFactory");
                table.empty();
          
                var t = $("#tdAttachment");
                t.html("");
                for (var r in result.data.Attachments) {
                    var a = $("<div title='点击下载'><img src='" + result.data.Attachments[r].Addition1 + "' alt=''/><a href='#' style='text-decoration:underline;' onclick=\"javascript:return DownLoadFile('" + result.data.Attachments[r].ItemValue + "');\">" + result.data.Attachments[r].ItemText + "</a> (" + result.data.Attachments[r].Addition2 + ")</div>");
                    a.appendTo(t);
                }


                var orderDetails = [];

                $(result.data.OrderDetails).each(function (i, v) {

                    eval("var d=" + v.Detail + ";");
                    orderDetails.push({
                        Id: v.Id,
                        OrderName: v.OrderName,
                        Detail: d,
                        DetailText: v.DetailText,
                        Category: v.Category,
                        CategoryName: v.CategoryName,
                        ReportCategory: v.ReportCategory,
                        Number: v.Number,
                        Price: v.Price,
                        MaterialName: v.MaterialName,
                        Amount: v.Amount,
                        Memo: v.Memo,
                        UnitName: v.UnitName,
                    });
                });

                FillOrderDetailInfo(orderDetails);

                SetDetailDetail(eval("(" + result.data.Detail + ")"));


                $('#divDetail').dialog('open');
            }
            else {
                alert("获取信息失败.");
            }

        },
        error: function (e) {
            alert("获取信息失败.");
        }
    });
}


function ajaxFileUpload() {
    ClearErrorMsg();

    if ($("#fileToUpload").val() == "") {
        SetErrorMsg("请选择上传文件", "divAttachment");
        return;
    }

    var point = $("#fileToUpload").val().lastIndexOf(".");
    var type = $("#fileToUpload").val().substr(point).toLowerCase();

    if (type == ".exe" || type == ".bat" || type == ".msi") {
        SetErrorMsg("文件类型不允许", "divAttachment");
        return;
    }
    $("#loading").show();

    $.ajaxFileUpload({
        url: '/Portal/FileUpload',
        secureuri: false,
        fileElementId: 'fileToUpload',
        data: { OrderNo: $("#OrderNo").val() },
        dataType: 'json',
        success: function (d, status) {
            var data = JSON.parse(d);
            data = data.Data;
            if (data.code == "1") {
                $("#divAttachment input").removeAttr("disabled");
                inUploading = false;
                SetErrorMsg(data.message, "divAttachment");
                $("#loading").hide();
            }
            else if (data.code == "0") {
                $("#divAttachment input").removeAttr("disabled");
                inUploading = false;
                $("#loading").hide();
                alert("上传成功！");
                $('#divAttachment').dialog('close');
            }
        },
        error: function (data, status, e) {
            $("#divAttachment input").removeAttr("disabled");
            inUploading = false;
            SetErrorMsg("上传时发生错误", "divAttachment");
            $("#loading").hide();
        }
    });

    $("#divAttachment input").attr("disabled", "disabled");
    inUploading = true;
    return false;
}

function ShowAttachment(OrderNo) {
    ClearErrorMsg();
    $("#OrderNo").val(OrderNo);

    $.ajax({
        url: "/Portal/GetOrderAttachments",
        type: 'GET',
        cache: false,
        data: { OrderNo: OrderNo },
        success: function (result) {
            if (result.code == 0) {
                $("#dAttachment").html("");

                if (result.data.length > 0) {
                    for (var r in result.data) {
                        var tr = $("<tr id='" + result.data[r].ItemValue + "'></tr>");
                        var td = $("<td style='text-align: center;'></td>");
                        var image = $("<img src='" + result.data[r].Addition1 + "' alt=''>");
                        image.appendTo(td);
                        td.appendTo(tr);
                        td = $("<td></td>");
                        td.html(result.data[r].ItemText);
                        td.appendTo(tr);
                        td = $("<td></td>");
                        td.html(result.data[r].Addition2);
                        td.appendTo(tr);
                        td = $("<td></td>");
                        var tno = result.data[r].ItemValue;
                        var t = $("<a href='#' onclick=\"javascript:return DownLoadFile('" + tno + "');\">下载</a>");
                        t.appendTo(td.addClass("text-center"));

                        //t = $("<a href='#' style='margin-left:5px;' onclick=\"javascript:return DeleteFile('" + tno + "','" + result.data[r].ItemText + "');\">删除</a>");
                        //t.appendTo(td);

                        td.appendTo(tr);

                        tr.appendTo($("#dAttachment"));
                    }
                }
                $('#divAttachment').dialog('open');
            }
            else {
                alert("获取信息失败.");
            }

        },
        error: function (e) {
            alert("获取信息失败.");
        }
    });
}


function DownLoadFile(no) {
    ClearErrorMsg();
    if (inUploading) {
        return false;
    }

    location.href = "/Portal/DownLoadAttachment?FileNo=" + no;
}

