<%@ page contentType="text/html; charset=utf-8"%>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="cm" uri="/commons-tags" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>数据库备份文件管理</title>
<link href="../resources/style/base.css" rel="stylesheet" type="text/css"/>
<s:include value="../common/head.jsp" />
<script type="text/javascript">

function dbBackup(){
	msgConfirm("您确认要备份当前数据库吗？",function(){
		iframeWindow("<s:url action='dbBackup'/>",400,200,"数据库备份",refreshWindow);
	});
}

function dbRecovery(){
	if(getCheckedCount("sid")!=1){
		msgAlert("请选择一条您要恢复的数据库备份文件记录。");
		return;
	}
	msgConfirm("您确认要恢复数据库备份文件（"+getCheckedValue("sid")+"）吗？",function(){
		iframeWindow("<s:url action='dbRecovery'/>?fileName="+getCheckedValue("sid"),400,200,"数据库恢复",refreshWindow);
	});
}

function dbDelete(){
	if(getCheckedCount("sid")!=1){
		msgAlert("请选择一条您要恢复的数据库备份文件记录。");
		return;
	}
	msgConfirm("您确认要删除数据库备份文件（"+getCheckedValue("sid")+"）吗？",function(){
		iframeWindow("<s:url action='dbBackupDelete'/>?fileName="+getCheckedValue("sid"),400,200,"删除数据库备份文件",refreshWindow);
	});
}

function dbDownload(){
	if(getCheckedCount("sid")!=1){
		msgAlert("请选择一条您要恢复的数据库备份文件记录。");
		return;
	}
	window.open("<s:url action='dbBackupDownload'/>?fileName="+getCheckedValue("sid"));
}

</script>
</head>

<body>
<div class="body_list">
<s:include value="../common/body.jsp" />
<s:form action="dbBackupList" id="queryForm" namespace="/system">

 
  
  <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0"  style="margin:0 0 5px 0;" >
    <tr>
      <td>
	  	<input type="button" name="add" onclick="dbBackup()" value="备份"/>
		<input type="button" name="edit" onclick="dbRecovery()" value="恢复"/>
        <input type="button" name="edit" onclick="dbDelete()" value="删除"/>
		<input type="button" name="edit" onclick="dbDownload()" value="下载"/>
      </td>
    </tr>
  </table>
  
  <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="table_line">
    <tr class="list_title">
      <td width="3%" align="center"><input type="radio" name="array" onclick="checkedAll(this)" value="checkbox" /></td>
      <td width="36%">文件名</td>
      <td width="25%">备份时间</td>
      <td width="36%">文件大小</td>
      </tr>
    <s:iterator value="files" status="st">
        <s:set name="row_cls" value=""/><s:if test="#st.Even"><s:set name="row_cls" value="%{'row_a'}"/></s:if>
        <tr class="list_data <s:property value='#row_cls'/>">
          <td align="center"><input type="radio" name="array" value="<s:property value='file.name'/>" lang="sid"/></td>
          <td class="center"><s:property value="file.name"/></td>
          <td class="center"><s:date name="lastModify" format="yyyy-MM-dd HH:mm:ss"/></td>
          <td class="center"><s:property value="file.length()/1024"/> k</td>
        </tr>
    </s:iterator>
  </table>
	  <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="list_page">
    <tr>
      <td style="text-align:left;"><span class="info"><strong>提示：</strong>上面列表中的数据库备份文件存储在安装人事系统的计算机上，为防止因该计算机设备损坏而导致数据丢失，建议您定期将数据库备份文件下载并在其它设备上保存一份。</span></td>
    </tr>
  </table>

</s:form>
</div>
</body>
</html>