
// JavaScript Document

//获取正文内容Panel对象
function getContentPanel(){
	return Ext.getCmp('content-panel');
}


//在指定节下添加目录节点，并返回该目录节点对象
function addFolderNode(name,parentFolder){
	var folderNode=new Ext.tree.TreeNode({text:name,singleClickExpand:true});
	parentFolder.appendChild(folderNode);
	return folderNode;
}

//在指定节下添加添加带链接地址的节点
function addLinkNode(parentFolder,name,url){
	var lnode=new Ext.tree.TreeNode({text:name,attributes:url,iconCls:'icon_'+name});
	parentFolder.appendChild(lnode);
	lnode.addListener("click",function(nd,env){
		openTab(url,name);
	});
}

//将name转换为一个唯一tab ID
function nameToTabID(name){
	return "tab_"+hex_md5('name_'+name);
}

//将tab id转换为iframe ID
function tabToIframeID(tabID){
	return "iframe_"+tabID;
}


//在tab中打开一个urlse
function openTab(url,name){
	var tid=nameToTabID(name);
	var fid=tabToIframeID(tid);				
	var oldTab=getContentPanel().getComponent(tid);
	if(oldTab!=null){
		oldTab.show();
		document.getElementById(fid).src=url;		
	}else{
		getContentPanel().add({  
		  title: "&nbsp;"+name+"&nbsp;",  
		  id:tid,                     
		  autoScroll:true,  
		  closable:true,  
		  html:'<iframe id="'+fid+'" src="'+url+'" width="100%" height="100%" frameborder="0" scrolling="auto"></iframe>'  
		}).show(); 
	}
}

function closeTab(name){
	var tid=nameToTabID(name);			
	var oldTab=getContentPanel().getComponent(tid);
	if(oldTab!=null){
		oldTab.destroy();
	}
}