// JavaScript Document


//此方法用于对页面控件的CSS进行调整
function ctlResize(targetObj){
	if(targetObj==null) targetObj=$(document);
	targetObj.find("input,textarea,select").each(function(){
		var $obj=$(this);
		var objType=$obj.attr("type").toLowerCase();
		var tagName=this.tagName.toLowerCase();
		if(objType=="button"||objType=="submit"||objType=="reset"){
			$obj.addClass("css_button");
		}else{
			if(objType=="checkbox" || objType=="radio") return;
			$obj.addClass("css_input");
			if($obj.attr("readonly")){
				$obj.addClass("css_input_readonly");
			}
			if($obj.attr("disabled")){
				$obj.addClass("css_input_disabled");
			}
			if(tagName=="select" || objType=="file"){
				if($obj.width()>0){
					$obj.width($obj.width()+6);
				}
				$obj.height($obj.height()+6);
			}
		}
	});
}

// 以下方法用于ie6水平滚动条的调整，注意此方法会被外层的extjs调用
function resizeBody(widthSize){
	if($.browser.msie && $.browser.version<7){
		var widthSize=widthSize==null?$(window).width():widthSize;
		$("body").width(widthSize-10);
	}
}

//对表格的空白td进行填充
function tableSpace(){
	$("td").each(function(){
		var $obj=$(this);
		if($.trim($obj.html())==""){
			$obj.html("&nbsp;");
		}
	});
}

//对排序字段的处理
function orderByField(){
	var orderVal=$("input[name='orderBy']").first().val();
	$(".orderBy").each(function(){
		var $obj=$(this);
		var fname=$obj.attr("lang");
		var ascDesc="asc";
		if((fname+" asc")==orderVal){
			ascDesc="desc";
			$obj.attr("title","点击按 “"+$obj.text()+"” 降序排序");
			$obj.text($obj.text()+"▲");
		} else if((fname+" desc")==orderVal){
			$obj.attr("title","点击按“"+$obj.text()+"” 升序排序");
			$obj.text($obj.text()+"▼");
		} else{
			$obj.attr("title","点击按 “"+$obj.text()+"” 升序排序");
		}
		var nextOrderVal=fname+" "+ascDesc;
		
		$obj.bind("click", {orderBy:nextOrderVal}, function(event)  {
			$("input[name='orderBy']").val(event.data.orderBy);
			$("#queryForm").get(0).submit();
		});

	});
}

$(function(){ 
	resizeBody();
	ctlResize();
	tableSpace();
	orderByField();
});
