// 此文件在最外层（引入了ext库）的页面中引用
// 此文件与ext_iframe.js的方法一一对象

//获取不重复的ID
var uniqueIndex=0;
function getUniqueID(){
	var dt = new Date();
	var dstr=dt.getTime();
	return "uid_"+dstr+"_"+(uniqueIndex++);
}

//显示confirm窗口
function extConfirm(message,resultFun){
	Ext.MessageBox.confirm('提示', message, function(res){ 
		if(resultFun!=null){
			resultFun(res=='yes'?true:false);
		}
	});
}

//显示alert窗口
function extAlert(message){
	Ext.Msg.show({
		title:'提示',
		msg: message,
		buttons: Ext.Msg.OK,
		icon: Ext.MessageBox.WARNING
	});
}

//显示普通的信息提示窗口
function extInfo(message){
	Ext.Msg.show({
		title:'提示',
		msg: message,
		buttons: Ext.Msg.OK,
		icon: Ext.MessageBox.INFO
	});
}

//用在iframe显示指定的url
function extWindow(url,widthSize,heightSize,titleStr,closeFun,modalFlag){
	var winID=getUniqueID();
	if(url.indexOf('?')==-1){
		url=url+"?";
	}else{
		url=url+"&";	
	}
	url=url+"winID="+winID;
	if(modalFlag==null){
		modalFlag=true;
	}
	
	var win = new Ext.Window({
		id:winID,
		width:widthSize,
		height:heightSize,
		plain: true,
		modal: modalFlag,
		title:titleStr,
		html:'<iframe id="ext_iframe_'+getUniqueID()+'" src="'+url+'" width="100%" height="100%" frameborder="0" scrolling="auto"></iframe>',
		listeners : {'close':{fn: function(){
			if(closeFun!=null){closeFun();}
		}}}
	});
	win.show(this);
}

//根据id来关闭extWindow
function extWindowClose(winId){
	Ext.getCmp(winId).close();
}