// JavaScript Document

////////////////////////////////////////
//
//  公共js方法
//
////////////////////////////////////////

//去除字符串前后的空格
function trim(str){
	if(str!=null){
		rex=/^ +/;
		rex2=/ +$/;
		return str.replace(rex,"").replace(rex2,"");
	}
	return "";
}

//替换字符串
//srcStr原始字符串  sourStr被替换字符串 destStr替换的字符串
function replaceAll(srcStr,sourStr,destStr){
	var lastStr=srcStr;
	var currStr=lastStr.replace(sourStr,destStr);
	while(currStr!=lastStr){
		lastStr=currStr;
		currStr=lastStr.replace(sourStr,destStr);
	}
	return currStr;
}

//检查是否为数字
function isNum(str){
	rex=/^\d+$/
	return str.match(rex)==str;
}

//产生随机字符串
function randomStr(){
	var d=new Date();
	s = ""+d.getHours()+d.getMinutes()+d.getSeconds()+d.getMilliseconds();
	s = "z_"+parseInt(""+(Math.random()*10000))+"_z_"+s;
	return s;
}

////////////////////////////////////////
//
//   <input type="checkbox" 控件相关的方法
// 
////////////////////////////////////////

// 全选 复选框
// 参数：
// allCheckboxObj 必须 触发全选的checkbox控件对象
// langFilter 可选 通过<input type="checkbox" lang="abc"中的abc进行分组过滤
function checkedAll(allCheckboxObj,langFilter){
	var ips=document.getElementsByTagName("input");
	var isChecked=allCheckboxObj.checked;
	for(var i = 0; i < ips.length;i++)
		if(ips[i].type=="checkbox" && (langFilter==null || ips[i].lang==langFilter))
			if(ips[i]!=allCheckboxObj&&!ips[i].disabled)
				ips[i].checked=isChecked;
}

// 返回checkbox或radio选择的数量
// 参数：
// langFilter 可选 通过<input type="checkbox" lang="abc"中的abc进行分组过滤
function getCheckedCount(langFilter){
	var ips=document.getElementsByTagName("input");
	var nn=0;
	for(var i = 0; i < ips.length; i++)
		if((ips[i].type=="checkbox" || ips[i].type=="radio" ) && (langFilter==null||ips[i].lang==langFilter) && ips[i].checked)
			nn++;
	return nn;
}

// 返回checkbox或radio中第一个选择的值
// 参数：
// langFilter 可选 通过<input type="checkbox" lang="abc"中的abc进行分组过滤
function getCheckedValue(langFilter){
	var ips=document.getElementsByTagName("input");
	for(var i = 0; i < ips.length; i++)
		if((ips[i].type=="checkbox" || ips[i].type=="radio" ) && (langFilter==null||ips[i].lang==langFilter) && ips[i].checked)
			return ips[i].value;
	return null;
}

// 返回checkbox或radio中选择的所有值，用逗号,分隔返回
// 参数：
// langFilter 可选 通过<input type="checkbox" lang="abc"中的abc进行分组过滤
function getCheckedValues(langFilter){
	var ips=document.getElementsByTagName("input");
	var res="";
	for(i = 0; i < ips.length;i++)
		if((ips[i].type=="checkbox" || ips[i].type=="radio" ) && (langFilter==null||ips[i].lang==langFilter) && ips[i].checked)
			res=res+","+ips[i].value;
	return res.length>0?res.substring(1):res;
}

////////////////////////////////////////
//
//    <select 控件相关的方法
// 
////////////////////////////////////////

//设置select框的选中值
function setSelectedValue(selObj,value){
	for(i = 0; i < selObj.options.length;i++)
		selObj.options[i].selected=selObj.options[i].value==value;
}

//获取select框中被选中的Option对象
function getSelectedOption(selObj){
	return selObj.options[selObj.selectedIndex];	
}

////////////////////////////////////////
//
//  公共的html相关方法 
//
////////////////////////////////////////

function openForm(form,name){
	window.open(form.action+"?"+getFormParameters(form),name);
}

//获取指定form的所有控件的参数，返回格式为： a=1&b=2 （utf-8编码）
// 参数ignoreNames用于指定忽略的名字集合
function getFormParameters(form,ignoreNames){
	var args="";
	for(i = 0; i < form.elements.length;i++){
		var obj = form.elements[i];
		if(ignoreNames!=null && ignoreNames.indexOf(obj.name)!=-1) continue;
		
		if(obj.disabled) continue;
		var type=obj.type.toLowerCase();
		var tag=obj.tagName.toLowerCase();

		if(tag=="input" || tag=="textarea"){
			if((type=="radio" || type=="checkbox") && !obj.checked )
				continue;
			args=args+encodeURI(obj.name)+"="+encodeURI(obj.value)+"&"
		}
		if(tag=="select"){
			args=args+encodeURI(obj.name)+"=";
			if(obj.options.length>0) args=args+encodeURI(obj.options[obj.selectedIndex].value);
			args=args+"&";
		}
	}	
	return args.length>0?args.substring(0,args.length-1):args;
}

//根据ID获取对象
function gi(id){
	return document.getElementById(id);
}

//根据Name获取对象
function gn(name){
	es=document.getElementsByName(name);
	return es!=null?es[0]:null;
}


//获取唯一的ID
var codeUniqueIndex=0;
function getCodeUniqueID(){
	var dt = new Date();
	var dstr=dt.getTime();
	return "unique_"+dstr+"_"+(codeUniqueIndex++)+"_id";
}


//获取http数据
function getHttpData(url){
	try{
    	var xmlhttp = ""; 
     	if(window.XMLHttpRequest)//   Mozilla,   Safari,...   
       		xmlhttp =new XMLHttpRequest();               
  		else					//   IE    
         	xmlhttp =new ActiveXObject("Msxml2.XMLHTTP"); 
		url=url+(url.indexOf("?")==-1?"?":"&")+"zzz="+getCodeUniqueID();
		xmlhttp.open("GET", url, false);
		xmlhttp.send(null);
		return xmlhttp.responseText;
	}catch(e){
		return e;	
	}
}

//获取并发送http数据
function postHttpData(url,data){
	try{
    	var xmlhttp = ""; 
     	if(window.XMLHttpRequest)//   Mozilla,   Safari,...   
       		xmlhttp =new XMLHttpRequest();               
  		else					//   IE    
         	xmlhttp =new ActiveXObject("Msxml2.XMLHTTP"); 
		url=url+(url.indexOf("?")==-1?"?":"&")+"zzz="+getCodeUniqueID();
		
		xmlhttp.open("POST", url, false);
		xmlhttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		xmlhttp.send(data);
		return xmlhttp.responseText;
	}catch(e){
		return e;	
	}
}

//切换location.href
function goto(url){
	location.href=url;	
}

//显示alert提示窗口
function msgAlert(info){
	var p=parent;
	var ix=0;
	while((++ix<50)&&p!=null&&!p.extAlert){
		p=p.parent;	
	}
	if(p.extAlert){
		p.extAlert(info);
	}else{
		alert(info);	
	}
}

//显示info提示窗口
function msgInfo(info){
	var p=parent;
	while(p!=null&&!p.extInfo){
		p=p.parent;	
	}
	p.extInfo(info);	
}

//显示confirm提示窗口
function msgConfirm(info,ifTrueCallFun){
	var p=parent;
	while(p!=null&&!p.extConfirm){
		p=p.parent;	
	}
	p.extConfirm(info,function(flag){
		if(flag){
			ifTrueCallFun();
		}
	});	
}

//在iframe中显示一个url
function iframeWindow(url,widthSize,heightSize,titleStr,closeFun,modalFlag){
	var p=parent;
	while(p!=null&&!p.extWindow){
		p=p.parent;	
	}
	p.extWindow(url,widthSize,heightSize,titleStr,closeFun,modalFlag);	
}

//根据id来关闭iframeWindow
function iframeWindowClose(winId){
	var p=parent;
	while(p!=null&&!p.extWindowClose){
		p=p.parent;	
	}
	p.extWindowClose(winId);
}

// 当图片加载成功后设置图片大小
// 本方法依赖于jquery
function resizeImg(imgId,maxWidth,maxHeight){
	var $photo=$("#"+imgId);
	var h=$photo.height();
	if(h<1){
		setTimeout("resizeImg('"+imgId+"',"+maxWidth+","+maxHeight+")",5);
		return;
	}
	var w=$photo.width();
	var bh=1;
	var bw=1;
	if(h>maxHeight) bh=h/maxHeight;
	if(w>maxWidth) bw=w/maxWidth;
	var bl=bh>bw?bh:bw;
	$photo.height(h/bl);
	$photo.width(w/bl);
}

/* 新开一个页面打开url */
function openUrl(url,name){
	var p=parent;
	while(p!=null&&!p.openTab){
		p=p.parent;	
	}
	p.openTab(url,name);
}

//根据name来关闭Tab
function closeUrl(name){
	var p=parent;
	while(p!=null&&!p.openTab){
		p=p.parent;	
	}
	p.closeTab(name);
}

//刷新本窗口中的内容
function refreshWindow(){
	if(query!=null){
		query();	
	}else{
		alert("query() not exist!");
		location.reload();	
	}
}


//将对象隐藏或显示
function showHide(id){
	var ds=$("#"+id).css("display");
	if("none"==ds){
		$("#"+id).css("display","block");
	}else{
		$("#"+id).css("display","none");
	}
}

//更改月份
// 参数：
// 1. 月份格式必须为yyyyMM
// 2. 改变的值可以为正负整数
// 返回：更改后的yyyyMM格式的月份
function addMonth(yyyyMM,addValue){
	var cm=yyyyMM;
	var zdate=new Date(parseInt(cm.substring(0,4),10),parseInt(cm.substring(4,6),10)-1,1);
	zdate.setMonth(zdate.getMonth()+addValue);
	var zmonth=zdate.getMonth()+1;
	cm=zdate.getYear()+(zmonth<10?"0":"")+zmonth;
	return cm;
}

//默认的查询方法
function query(){
	var checkOk=true;
	try{
		checkOk=gi("queryForm").onsubmit();
	}catch(ex){}
	if(checkOk){
		gi("queryForm").submit();
	}
}