//
//Form表单数据验证
//
// 使用步骤：
// 1. 在form中添加onsubmit方法。<form action="go.jsp" onsubmit="return checkForm(this);">
// 2. 在需要检查的控件中设置title属性值，包含指定关键字 [ 必选、必填、邮件、数字、数值、金额、日期、图片、最多n位小数、最多n个字符、必须为n个、半角] 即可。
//    特殊：固定长度的验证在size="n"设置；
//

//form的验证方法
// 参数form为需要验证的form对象。
// 参数funHandle为自定义的验证方法，将在所有验证结束后调用，必须返回boolean值。
// 参数disBut为boolean值，用于定义是否disalble表单中的按钮，默认为true
function checkForm(form,funHandle,disBut){
	for(i = 0; i < form.elements.length;i++){
		obj = form.elements[i];
		if(obj.disabled) continue;
		hideErrorBox(obj);
		if( !requiredCheck(obj) || !maxLengthCheck(obj) || !numberCheck(obj) || 
		    !emailCheck(obj) || !moneyCheck(obj) || !dateCheck(obj) || 
			!imageCheck(obj) || !banjiaoChcek(obj) || !fixLengthCheck(obj)||
			!numberValueCheck(obj) || !floatSuffixCheck(obj)
		) {
			return false;
		}
	}
	res=(funHandle!=null)?funHandle(form):true;
	disBut=disBut==null?true:disBut;
	if(res && disBut)disabledBut(form);
	return res;
}

//半角检查
function banjiaoChcek(obj){
	if(isEmpty(obj.value) || obj.title.indexOf("半角")==-1)
		return true;	
	if(obj.value.replace(/[^\x00-\xff]/g,"xx").length!=obj.value.length){
		checkMessage(obj);
		return false;
	}
	return true;
}

//最大数量限制
var maxLenRex = new RegExp(/最多(\d+)个字符/);  // 匹配的正则表达式
var cnCharNum = 3;                             //中文占用的字符数量(utf-8为3,GBK为2)
function maxLengthCheck(obj){
   	var r = obj.title.match(maxLenRex);
	if(!r) return true;
	var xx="";
	for(var i=0;i<cnCharNum;i++)
		xx+="x";
	var defLen=parseInt(r[1],10);
	var theLen=obj.value.replace(/[^\x00-\xff]/g,xx).length;
	if(theLen>defLen){
		checkMessage(obj,"输入值的长度为"+theLen+"个字符，超出了最大长度"+defLen+"，注意一个汉字占"+cnCharNum+"字符。");
	}
	return theLen<=defLen;
}


//固定长度检查
var fixLenRex = new RegExp(/必须为(\d+)个/);  // 匹配的正则表达式
function fixLengthCheck(obj){
 	var r = obj.title.match(fixLenRex);
	if(!r) return true;
	var xx="";
	for(var i=0;i<cnCharNum;i++)
		xx+="x";
	var defLen=parseInt(r[1],10);
	var theLen=obj.value.replace(/[^\x00-\xff]/g,xx).length;
	if(theLen!=defLen){
		checkMessage(obj,"输入值的长度为"+theLen+"个字符，不等于规定长度"+defLen+"，注意一个汉字占"+cnCharNum+"字符。");
	}
	return theLen==defLen;
}


//最多n位小数
var floatSuffixRex = new RegExp(/最多(\d+)位小数/);  // 匹配的正则表达式
function floatSuffixCheck(obj){
 	var r = obj.title.match(floatSuffixRex);
	if(!r) return true;
	if(obj.value=="") return true;
	var rex=new RegExp("^\\-?\\d+(\\.\\d{1,"+r[1]+"})?$");
	if(!(rex.test(obj.value))){
		checkMessage(obj);
		return false;
	}
	return true;
}

//图片验证，主要验证扩展名
function imageCheck(obj){
	if( obj.title.indexOf("图片")==-1)
		return true;
	str=obj.value.substring(obj.value.length-3,obj.value.length).toLowerCase();
	if("gif,jpg,png,bmp".indexOf(str)==-1){
		checkMessage(obj);
		return false;
	}
	return true;
}

//日期验证
function dateCheck(obj){
	if(isEmpty(obj.value) || obj.title.indexOf("日期")==-1)
		return true;
	rex=/^\d{4}\-\d{2}\-\d{2}$/
	if(!(rex.test(obj.value))){
		checkMessage(obj,"格式必须为yyyy-MM-dd 例如 2011-01-01");
		return false;
	}
	return true;
}

//金额验证
function moneyCheck(obj){
	if(isEmpty(obj.value) || obj.title.indexOf("金额")==-1)
		return true;
	rex1=/^\d+\.\d{1,2}$/
	rex2=/^\d+$/
	str=obj.value;
	if(!( rex1.test(str) || rex2.test(str) )){
		checkMessage(obj);
		return false;
	}
	return true;
}

//邮件验证
function emailCheck(obj){
	if(isEmpty(obj.value) || obj.title.indexOf("邮件")==-1)
		return true;
	rex=/^[^@]+@[^@]+\.[^@]+$/
	if(!(rex.test(obj.value))){
		checkMessage(obj);
		return false;
	}
	return true;
}

//数字验证
function numberCheck(obj){
	if(isEmpty(obj.value) || obj.title.indexOf("数字")==-1)
		return true;
	rex=/^\-{0,1}\d*$/;
	if(!(rex.test(obj.value))){
		checkMessage(obj);
		return false;
	}
	return true;
}

//数值验证
function numberValueCheck(obj){
	if(isEmpty(obj.value) || obj.title.indexOf("数值")==-1)
		return true;
	rex=/^\-{0,1}\d+(\.\d+)?$/;
	if(!(rex.test(obj.value))){
		checkMessage(obj);
		return false;
	}
	return true;
}


//空值验证
function requiredCheck(obj){
	if(obj.title.indexOf("必填")==-1&&obj.title.indexOf("必选")==-1)
		return true;
	if(isEmpty(obj.value)){
		checkMessage(obj);
		return false;
	}
	return true;
}

//输出提示信息
function checkMessage(obj,otherMessage){
	showErrorBox(obj);
	str="验证失败！"+obj.title;
	if(otherMessage)
		//str=str+"\n\n　　"+otherMessage;
		str=str+"<br><br>　　"+otherMessage;
	//alert("提示：\n\n　　"+str+"　　\n");
	msgAlert(str);
}

function getAbsPoint(e){
  var x = e.offsetLeft;
  var y = e.offsetTop;
  while(e = e.offsetParent){
    x += e.offsetLeft;
    y += e.offsetTop;
  }
  return {"x":x, "y": y};
}

//空值判断
function isEmpty(str){
	return trim(str)=="";
}

//去除前后的空格
function trim(str){
	rex=/^ +/;
	rex2=/ +$/;
	return str.replace(rex,"").replace(rex2,"");
}

//提交之前，让按钮失效
function disabledBut(form){
	for(i = 0; i < form.elements.length;i++){
		obj = form.elements[i];
		if(obj.type=="submit"||obj.type=="button"||obj.type=="reset")
			obj.disabled=true;
	}
}


var error_border_space=2;
document.write('<div onmouseover="this.style.display=\'none\';" id="error_border_div" style="position: absolute; display:none; z-index:9999; border:'+error_border_space+'px solid #FF5B5B;"></div>');

var oldBorderChecked=null;
var oldObjChecked=null;


//隐藏对象上的错误红色边框
function hideErrorBox(obj){
	if(obj=oldObjChecked)
		obj.border=oldBorderChecked;
}


//显示对象的错误红色边框
function showErrorBox(obj){
	eb=document.getElementById("error_border_div");
	eb.style.display="none";
	eb.style.width=(parseInt(obj.offsetWidth,10)-error_border_space*2) +"px";
	eb.style.height = (parseInt(obj.offsetHeight,10)-error_border_space*2)+"px";
	xy=getAbsPoint(obj);
	eb.style.top =xy.y+"px";
	eb.style.left =xy.x+"px";
	eb.style.display ="";	
}