/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.ui.DownloadWindow;
import com.sun.javaws.ui.UpdateDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import sun.awt.AppContext;

public class LDUpdater {
    private LaunchDesc _ld = null;
    private boolean _updateAvailable = false;
    private boolean _updateDownloaded = false;
    private boolean _updateChecked = false;
    private boolean _checkAborted = false;
    private LocalApplicationProperties _lap = null;
    private volatile Thread backgroundUpdateThread = null;
    private int _numThread = 0;
    private JNLPException _exception = null;
    private Object _syncObj = null;

    public LDUpdater(LaunchDesc launchDesc) {
        this._ld = launchDesc;
    }

    public boolean isCheckAborted() {
        return this._checkAborted;
    }

    public boolean isUpdateAvailable() {
        if (this._ld.isHttps()) {
            return this.isUpdateAvailable(false, true, false);
        }
        return this.isUpdateAvailable(false, true, true);
    }

    public boolean isUpdateAvailable(boolean bl) {
        return this.isUpdateAvailable(false, true, bl);
    }

    public synchronized boolean isUpdateAvailable(boolean bl, boolean bl2) {
        return this.isUpdateAvailable(bl, bl2, false);
    }

    public synchronized boolean isUpdateAvailable(boolean bl, boolean bl2, boolean bl3) {
        if (!this._updateChecked) {
            if (bl3 && this._syncObj == null) {
                this._syncObj = new Object();
            }
            try {
                this._updateAvailable = this._ld.isApplicationDescriptor() ? this.doUpdateCheck(bl, bl2, bl3) : this.updateCheck(bl, bl2, bl3);
                this._updateChecked = true;
                boolean bl4 = this._updateDownloaded = !this._updateAvailable;
                if (this._ld.isInstaller() && this._updateAvailable && DownloadEngine.isBackgroundThread()) {
                    this.setForceUpdateCheck();
                }
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        return this._updateAvailable;
    }

    public boolean isUpdateDownloaded() {
        return this._updateDownloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadUpdate(boolean bl) throws Exception {
        if (this._updateAvailable) {
            this.download(bl);
        }
        LDUpdater lDUpdater = this;
        synchronized (lDUpdater) {
            this._updateAvailable = false;
            this._updateDownloaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdateCheck(final boolean bl, final boolean bl2, final boolean bl3) {
        int n;
        if (this._lap == null) {
            this._lap = Cache.getLocalApplicationProperties((URL)this._ld.getCanonicalHome());
        }
        if ((n = this._ld.getUpdate().getCheck()) == 2) {
            this.startBackgroundUpdate();
            return false;
        }
        int n2 = Config.getIntProperty((String)"deployment.javaws.update.timeout");
        final Object object = new Object();
        final boolean[] blArray = new boolean[4];
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl5 = false;
                boolean bl22 = false;
                boolean bl32 = false;
                boolean bl4 = false;
                try {
                    if (LDUpdater.this.updateCheck(bl, bl2, bl3)) {
                        bl5 = true;
                        LDUpdater.this.setForceUpdateCheck();
                    }
                    bl22 = true;
                }
                catch (FailedDownloadingResourceException failedDownloadingResourceException) {
                    Throwable throwable;
                    if (LDUpdater.this._ld.isHttps() && (throwable = failedDownloadingResourceException.getWrappedException()) != null && throwable instanceof SSLHandshakeException) {
                        bl4 = true;
                    }
                    bl32 = true;
                    Trace.ignoredException((Exception)failedDownloadingResourceException);
                }
                catch (Exception exception) {
                    Trace.ignored((Throwable)exception);
                    bl32 = true;
                }
                Object object2 = object;
                synchronized (object2) {
                    blArray[0] = bl5;
                    blArray[1] = bl22;
                    blArray[2] = bl32;
                    blArray[3] = bl4;
                    object.notify();
                }
            }
        }).start();
        Object object2 = object;
        synchronized (object2) {
            while (!(blArray[1] || blArray[2] || blArray[3])) {
                try {
                    object.wait(n2);
                }
                catch (InterruptedException interruptedException) {
                    Trace.ignored((Throwable)interruptedException);
                }
                if (n != 1 || this._ld.isHttps()) continue;
            }
        }
        this._checkAborted = blArray[3];
        return blArray[0];
    }

    public synchronized boolean isBackgroundUpdateRunning() {
        return null != this.backgroundUpdateThread;
    }

    public void startBackgroundUpdateOpt() {
        if (!this._ld.getUpdate().isBackgroundCheck()) {
            return;
        }
        if (null != this.backgroundUpdateThread) {
            return;
        }
        this.startBackgroundUpdate();
    }

    private synchronized void startBackgroundUpdate() {
        if (null != this.backgroundUpdateThread) {
            return;
        }
        Trace.println((String)"LDUpdater: started background update check", (TraceLevel)TraceLevel.NETWORK);
        final ArrayList arrayList = this.buildBackgroundDownloadList();
        this.storeBackgroundListInAppContext(arrayList);
        this.backgroundUpdateThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DownloadEngine.setBackgroundThread((boolean)true);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (LDUpdater.this.updateCheck(false, true, false)) {
                        LDUpdater.this.download(true);
                    }
                    LDUpdater.this.resetForceUpdateCheck();
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                    LDUpdater.this.setForceUpdateCheck();
                }
                finally {
                    LDUpdater.this.removeBackgroundListInAppContext(arrayList);
                }
            }
        });
        this.backgroundUpdateThread.setName("Background Update Thread");
        this.backgroundUpdateThread.setPriority(1);
        this.backgroundUpdateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCheck(boolean bl, boolean bl2, boolean bl3) throws JNLPException {
        Object object;
        Object object2;
        int n;
        IconDesc[] iconDescArray;
        ResourcesDesc resourcesDesc;
        URL uRL = this._ld.getLocation();
        if (uRL == null) {
            uRL = this._ld.getCanonicalHome();
        }
        if (uRL != null) {
            try {
                if (bl3) {
                    this.rapidUpdateCheckHelper(uRL);
                } else if (DownloadEngine.isUpdateAvailable((URL)uRL, null)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new FailedDownloadingResourceException(uRL, null, iOException);
            }
        }
        if ((resourcesDesc = this._ld.getResources()) == null) {
            return false;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!bl2 && jARDescArray[i].isLazyDownload()) continue;
            if (bl3) {
                this.rapidUpdateCheckHelper(jARDescArray[i]);
                continue;
            }
            if (!jARDescArray[i].getUpdater().isUpdateAvailable()) continue;
            return true;
        }
        if (bl && (iconDescArray = this._ld.getInformation().getIcons()) != null) {
            for (n = 0; n < iconDescArray.length; ++n) {
                object2 = iconDescArray[n].getLocation();
                object = iconDescArray[n].getVersion();
                try {
                    if (bl3) {
                        this.rapidUpdateCheckHelper(iconDescArray[n]);
                        continue;
                    }
                    if (!DownloadEngine.isUpdateAvailable((URL)object2, (String)object)) continue;
                    Globals.setIconImageUpdated(true);
                    continue;
                }
                catch (IOException iOException) {
                    throw new FailedDownloadingResourceException((URL)object2, null, iOException);
                }
            }
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }
        });
        for (n = 0; n < arrayList.size(); ++n) {
            object2 = ((ExtensionDesc)arrayList.get(n)).getExtensionDesc();
            object = ((LaunchDesc)object2).getLocation();
            try {
                if (bl3) {
                    ((LaunchDesc)object2).getUpdater().isUpdateAvailable(bl, bl2, bl3);
                    continue;
                }
                if (!((LaunchDesc)object2).getUpdater().isUpdateAvailable(bl, bl2, bl3)) continue;
                return true;
            }
            catch (NullPointerException nullPointerException) {
                Trace.ignored((Throwable)nullPointerException);
            }
        }
        if (bl3) {
            while (this._numThread > 0) {
                Object object3 = this._syncObj;
                synchronized (object3) {
                    if (this._updateAvailable || this._numThread == 0) {
                        break;
                    }
                    if (this._exception != null) {
                        throw this._exception;
                    }
                }
            }
            return this._updateAvailable;
        }
        return false;
    }

    private void rapidUpdateCheckHelper(URL uRL) {
        this.rapidUpdateCheckHelper(uRL, null, null);
    }

    private void rapidUpdateCheckHelper(JARDesc jARDesc) {
        this.rapidUpdateCheckHelper(null, jARDesc, null);
    }

    private void rapidUpdateCheckHelper(IconDesc iconDesc) {
        this.rapidUpdateCheckHelper(null, null, iconDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rapidUpdateCheckHelper(final URL uRL, final JARDesc jARDesc, final IconDesc iconDesc) {
        Object object = this._syncObj;
        synchronized (object) {
            ++this._numThread;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block23: {
                    JNLPException jNLPException = null;
                    boolean bl = false;
                    try {
                        if (uRL != null) {
                            try {
                                bl = DownloadEngine.isUpdateAvailable((URL)uRL, null);
                            }
                            catch (IOException iOException) {
                                throw new FailedDownloadingResourceException(uRL, null, iOException);
                            }
                        }
                        if (jARDesc != null) {
                            bl = jARDesc.getUpdater().isUpdateAvailable();
                        }
                        if (iconDesc == null) break block23;
                        URL uRL2 = iconDesc.getLocation();
                        String string = iconDesc.getVersion();
                        try {
                            if (DownloadEngine.isUpdateAvailable((URL)uRL2, (String)string)) {
                                Globals.setIconImageUpdated(true);
                            }
                        }
                        catch (IOException iOException) {
                            throw new FailedDownloadingResourceException(uRL2, null, iOException);
                        }
                    }
                    catch (JNLPException jNLPException2) {
                        jNLPException = jNLPException2;
                    }
                    finally {
                        Object object = LDUpdater.this._syncObj;
                        synchronized (object) {
                            if (bl && !LDUpdater.this._updateAvailable) {
                                LDUpdater.this._updateAvailable = true;
                            }
                            if (jNLPException != null && LDUpdater.this._exception == null) {
                                LDUpdater.this._exception = jNLPException;
                            }
                            LDUpdater.this._numThread--;
                        }
                    }
                }
            }
        }).start();
    }

    private static boolean compareByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean needUpdatePerPolicy(DownloadWindow downloadWindow) throws ExitException {
        boolean bl = false;
        switch (this._ld.getUpdate().getPolicy()) {
            default: {
                bl = true;
                break;
            }
            case 1: {
                bl = UpdateDialog.showUpdateDialog(this._ld, downloadWindow);
                if (bl) break;
                Trace.println((String)"Start from cached after user chose not to update", (TraceLevel)TraceLevel.BASIC);
                this.startBackgroundUpdate();
                break;
            }
            case 2: {
                bl = UpdateDialog.showUpdateDialog(this._ld, downloadWindow);
                if (bl) break;
                Trace.println((String)"Exiting after user chose not to update", (TraceLevel)TraceLevel.BASIC);
                throw new ExitException(new LaunchDescException(this._ld, "User cancelled mandatory update - aborted", null), 3);
            }
        }
        return bl;
    }

    public boolean needUpdatePerPolicy() throws ExitException {
        return this.needUpdatePerPolicy(null);
    }

    private void download(boolean bl) throws Exception, JNLPException {
        Object object;
        int n;
        ResourcesDesc resourcesDesc;
        URL uRL = this._ld.getLocation();
        File file = DownloadEngine.getCachedFile((URL)uRL, null, (boolean)true, (boolean)false, null);
        byte[] byArray = LaunchDescFactory.readBytes(new FileInputStream(file), file.length());
        byte[] byArray2 = this._ld.getBytes();
        LaunchDesc launchDesc = null;
        if (byArray != null && byArray2 != null) {
            launchDesc = LDUpdater.compareByteArray(byArray, byArray2) ? this._ld : LaunchDescFactory.buildDescriptor(file, this._ld.getCodebase(), this._ld.getLocation());
        }
        if ((resourcesDesc = launchDesc.getResources()) == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        if (bl) {
            arrayList.addAll(Arrays.asList(jARDescArray));
        } else {
            for (n = 0; n < jARDescArray.length; ++n) {
                if (jARDescArray[n].isLazyDownload()) continue;
                arrayList.add(jARDescArray[n]);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (ExtensionDesc[])arrayList.get(n);
            if (!object.getUpdater().isUpdateAvailable()) continue;
            object.getUpdater().downloadUpdate();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (JARDesc)arrayList.get(n);
            if (!object.getUpdater().isUpdateDownloaded()) continue;
            object.getUpdater().updateCache();
        }
        IconDesc iconDesc = launchDesc.getInformation().getIconLocation(1, 0);
        if (iconDesc != null) {
            try {
                DownloadEngine.getResource((URL)iconDesc.getLocation(), null, (String)iconDesc.getVersion(), null, (boolean)true, (int)1);
                Trace.println((String)("Downloaded " + iconDesc.getLocation()), (TraceLevel)TraceLevel.NETWORK);
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
        object = resourcesDesc.getExtensionDescs();
        for (int i = 0; i < ((ExtensionDesc[])object).length; ++i) {
            LaunchDesc launchDesc2 = object[i].getExtensionDesc();
            URL uRL2 = launchDesc2.getLocation();
            try {
                if (!launchDesc2.getUpdater().isUpdateAvailable(false, bl)) continue;
                launchDesc2.getUpdater().downloadUpdate(bl);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                Trace.ignored((Throwable)nullPointerException);
                continue;
            }
            catch (IOException iOException) {
                throw new FailedDownloadingResourceException(uRL2, null, iOException);
            }
        }
    }

    private void setForceUpdateCheck() {
        if (this._lap != null && !this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(true);
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private void resetForceUpdateCheck() {
        if (this._lap != null && this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(false);
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private ArrayList buildBackgroundDownloadList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ResourcesDesc resourcesDesc;
            URL uRL = this._ld.getLocation();
            if (uRL == null) {
                uRL = this._ld.getCanonicalHome();
            }
            if (uRL != null) {
                arrayList.add(uRL.toString());
            }
            if ((resourcesDesc = this._ld.getResources()) != null) {
                IconDesc[] iconDescArray;
                ExtensionDesc[] extensionDescArray = resourcesDesc.getExtensionDescs();
                for (int i = 0; i < extensionDescArray.length; ++i) {
                    URL uRL2 = extensionDescArray[i].getLocation();
                    if (uRL2 == null) continue;
                    arrayList.add(uRL2.toString());
                }
                JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
                if (jARDescArray != null) {
                    for (int i = 0; i < jARDescArray.length; ++i) {
                        URL uRL3 = jARDescArray[i].getLocation();
                        if (uRL3 == null) continue;
                        arrayList.add(uRL3.toString());
                    }
                }
                if ((iconDescArray = this._ld.getInformation().getIcons()) != null) {
                    for (int i = 0; i < iconDescArray.length; ++i) {
                        URL uRL4 = iconDescArray[i].getLocation();
                        if (uRL4 == null) continue;
                        arrayList.add(uRL4.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
        return arrayList;
    }

    private void storeBackgroundListInAppContext(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            AppContext.getAppContext().put(DownloadEngine.APPCONTEXT_BG_KEY + string, "background");
        }
    }

    private void removeBackgroundListInAppContext(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            AppContext.getAppContext().remove(DownloadEngine.APPCONTEXT_BG_KEY + string);
        }
    }
}

