/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.jardiff.JarDiffPatcher;
import com.sun.deploy.jardiff.Patcher;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadHelper;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.awt.AppContext;

public class DownloadEngine {
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    public static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final int BASIC_DOWNLOAD_PROTOCOL = 1;
    private static final int VERSION_DOWNLOAD_PROTOCOL = 2;
    private static final int EXTENSION_DOWNLOAD_PROTOCOL = 3;
    public static final int NORMAL_CONTENT_BIT = 1;
    public static final int NATIVE_CONTENT_BIT = 16;
    public static final int JAR_CONTENT_BIT = 256;
    public static final int PACK200_CONTENT_BIT = 4096;
    public static final int VERSION_CONTENT_BIT = 65536;
    private static int BUF_SIZE = 8192;
    private static final String defaultLocaleString = Locale.getDefault().toString();
    private static HttpRequest _httpRequestImpl;
    private static HttpDownload _httpDownloadImpl;
    public static final String BACKGROUND_STRING = "background";
    public static final String APPCONTEXT_BG_KEY;
    private static InheritableThreadLocal backgroundUpdateThreadLocal;
    private static int jarCompression;
    private static Hashtable noCacheJarFileList;
    private static ArrayList updateCheckDoneList;
    private static final Object syncObject;

    public static boolean isBackgroundThread() {
        return (Boolean)backgroundUpdateThreadLocal.get();
    }

    public static void setBackgroundThread(boolean bl) {
        backgroundUpdateThreadLocal.set(new Boolean(bl));
    }

    private static boolean isNormalContentType(int n) {
        return (n & 1) == 1;
    }

    public static boolean isNativeContentType(int n) {
        return (n & 0x10) == 16;
    }

    public static boolean isJarContentType(int n) {
        return (n & 0x100) == 256;
    }

    public static boolean isPackContentType(int n) {
        return (n & 0x1000) == 4096;
    }

    private static boolean isVersionContentType(int n) {
        return (n & 0x10000) == 65536;
    }

    static boolean isPack200Supported() {
        return Config.isJavaVersionAtLeast15();
    }

    public static void setJarCompressionLevel(int n) {
        jarCompression = n;
    }

    public static int getJarCompressionLevel() {
        if (jarCompression == -1) {
            String string = Config.getProperty("deployment.cache.jarcompression");
            string = string.trim();
            try {
                jarCompression = Integer.valueOf(string);
                if (jarCompression < 0 || jarCompression > 9) {
                    jarCompression = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                jarCompression = 0;
            }
        }
        return jarCompression;
    }

    public static String getCachedResourceFilePath(URL uRL, String string) throws IOException {
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, string);
            if (cacheEntry != null) {
                return cacheEntry.getResourceFilename();
            }
        } else {
            JarFile jarFile = (JarFile)MemoryCache.getLoadedResource(uRL.toString());
            if (jarFile != null) {
                return jarFile.getName();
            }
        }
        throw new IOException("Cannot find cached resource for URL: " + uRL.toString());
    }

    public static File downloadJarWithoutCache(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, int n) throws IOException {
        File file = null;
        try {
            file = DownloadEngine.getJarFileWithoutCache(uRL, string, string2, downloadDelegate, n);
        }
        catch (IOException iOException) {
            file = DownloadEngine.getJarFileWithoutCache(uRL, string, string2, downloadDelegate);
        }
        return file;
    }

    public static URL getResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        return DownloadEngine.getResource(uRL, string, string2, downloadDelegate, bl, 1);
    }

    public static URL getResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, int n) throws IOException {
        File file;
        URL uRL2 = null;
        MemoryCache.removeLoadedResource(uRL.toString());
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, n);
            if (cacheEntry != null) {
                uRL2 = URLUtil.fileToURL(new File(cacheEntry.getResourceFilename()));
            }
        } else if ((DownloadEngine.isJarContentType(n) || DownloadEngine.isPackContentType(n) || DownloadEngine.isAlwaysCached(uRL.toString().toLowerCase())) && (file = DownloadEngine.downloadJarWithoutCache(uRL, string, string2, downloadDelegate, n)) != null) {
            JarFile jarFile = new JarFile(file);
            MemoryCache.addLoadedResource(uRL.toString(), jarFile);
        }
        return uRL2;
    }

    static boolean isZipFile(String string) {
        return string.toLowerCase().endsWith(".zip");
    }

    public static boolean isAlwaysCached(String string) {
        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar") || string.toLowerCase().endsWith(".zip");
    }

    public static long getCachedLastModified(URL uRL, String string, String string2) throws IOException {
        CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false);
        if (cacheEntry != null) {
            return cacheEntry.getLastModified();
        }
        return 0L;
    }

    public static long getCachedSize(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl);
        if (cacheEntry != null) {
            return cacheEntry.getSize();
        }
        return 0L;
    }

    public static void clearNoCacheJarFileList() {
        noCacheJarFileList.clear();
    }

    private static File getJarFileWithoutCache(URL uRL, String string, String string2, DownloadDelegate downloadDelegate) throws IOException {
        return DownloadEngine.getJarFileWithoutCache(uRL, string, string2, downloadDelegate, 256);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getJarFileWithoutCache(final URL uRL, String string, final String string2, final DownloadDelegate downloadDelegate, int n) throws IOException {
        Object object;
        int n2;
        JarFile jarFile;
        File file;
        OutputStream outputStream;
        byte[] byArray;
        block28: {
            File file2 = (File)noCacheJarFileList.get(uRL.toString());
            if (file2 != null) {
                return file2;
            }
            byArray = new byte[8192];
            URL uRL2 = DownloadEngine.getRequestURL(uRL, string, string2, null, null, null, null, false, null, string2 == null ? 1 : 2);
            boolean bl = false;
            if (DownloadEngine.isVersionContentType(n)) {
                uRL2 = DownloadEngine.getEmbeddedVersionUrl(uRL2, string2);
            }
            if (DownloadEngine.isPackContentType(n)) {
                uRL2 = DownloadEngine.getPack200Url(uRL2);
                bl = true;
            }
            URLConnection uRLConnection = uRL2.openConnection();
            if (DownloadEngine.isPack200Supported()) {
                uRLConnection.setRequestProperty("accept-encoding", "pack200-gzip,gzip");
            } else {
                uRLConnection.setRequestProperty("accept-encoding", "gzip");
            }
            InputStream inputStream = uRLConnection.getInputStream();
            int n3 = uRLConnection.getContentLength();
            String string3 = uRLConnection.getContentEncoding();
            int n4 = 0;
            if (downloadDelegate != null) {
                downloadDelegate.setTotalSize(n3);
            }
            HttpDownloadListener httpDownloadListener = downloadDelegate == null ? null : new HttpDownloadListener(){

                public boolean downloadProgress(int n, int n2) {
                    downloadDelegate.downloading(uRL, string2, n, n2, false);
                    return true;
                }
            };
            outputStream = null;
            file = null;
            jarFile = null;
            Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", uRL2.toString(), n3, string3), TraceLevel.NETWORK);
            try {
                try {
                    file = File.createTempFile("jar_cache", null);
                    file.deleteOnExit();
                    outputStream = new FileOutputStream(file);
                    n2 = 0;
                    if (bl || string3 != null && string3.equals("pack200-gzip")) {
                        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
                        object = Pack200.newUnpacker();
                        object.unpack((InputStream)new GZIPInputStream(inputStream, BUF_SIZE), jarOutputStream);
                        jarOutputStream.close();
                    } else {
                        if (string3 != null && string3.equals("gzip")) {
                            inputStream = new GZIPInputStream(inputStream, BUF_SIZE);
                        }
                        int n5 = 0;
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            if (n5 == 0 && !DownloadEngine.isJarHeaderValid(byArray)) {
                                throw new IOException("Invalid jar file");
                            }
                            outputStream.write(byArray, 0, n2);
                            if ((n4 += n2) > n3 && n3 != 0) {
                                n4 = n3;
                            }
                            if (httpDownloadListener != null) {
                                httpDownloadListener.downloadProgress(n4, n3);
                            }
                            ++n5;
                        }
                    }
                    jarFile = new JarFile(file);
                }
                catch (IOException iOException) {
                    if (file != null) {
                        file.delete();
                    }
                    throw iOException;
                }
                Object var22_24 = null;
                if (inputStream == null) break block28;
            }
            catch (Throwable throwable) {
                Object var22_25 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (jarFile != null) {
            n2 = jarFile.size();
            int n6 = 0;
            if (downloadDelegate != null) {
                downloadDelegate.validating(uRL, 0, n2);
            }
            object = jarFile.entries();
            while (object.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)object.nextElement();
                int n7 = 0;
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                    while ((n7 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                    }
                }
                catch (ZipException zipException) {
                    throw new JARSigningException(uRL, string2, 2, zipException);
                }
                catch (SecurityException securityException) {
                    throw new JARSigningException(uRL, string2, 2, securityException);
                }
                if (downloadDelegate == null) continue;
                downloadDelegate.validating(uRL, ++n6, n2);
            }
            jarFile.close();
        }
        noCacheJarFileList.put(uRL.toString(), file);
        return file;
    }

    public static JarFile getCachedJarFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedJarFile(uRL, string, false, 1);
    }

    public static JarFile getUpdatedJarFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedJarFile(uRL, string, true, 1);
    }

    public static JarFile getUpdatedJarFile(URL uRL, String string, int n) throws IOException {
        return DownloadEngine.getCachedJarFile(uRL, string, true, n);
    }

    private static JarFile getCachedJarFile(URL uRL, String string, boolean bl, int n) throws IOException {
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = null;
            cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl, n);
            if (cacheEntry != null) {
                return cacheEntry.getJarFile();
            }
        } else {
            JarFile jarFile = (JarFile)MemoryCache.getLoadedResource(uRL.toString());
            if (jarFile != null) {
                return jarFile;
            }
            File file = DownloadEngine.getJarFileWithoutCache(uRL, null, string, null);
            if (file != null) {
                JarFile jarFile2 = new JarFile(file);
                MemoryCache.addLoadedResource(uRL.toString(), jarFile2);
                return jarFile2;
            }
        }
        return null;
    }

    public static File getCachedShortcutImage(URL uRL, String string) throws IOException {
        return DownloadEngine.getShortcutImage(uRL, string, false);
    }

    public static File getUpdatedShortcutImage(URL uRL, String string) throws IOException {
        return DownloadEngine.getShortcutImage(uRL, string, true);
    }

    private static File getShortcutImage(URL uRL, String string, boolean bl) throws IOException {
        CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl);
        if (cacheEntry != null) {
            cacheEntry.generateShortcutImage();
            return cacheEntry.getDataFile();
        }
        return null;
    }

    public static File getCachedFileNative(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("jar")) {
            String string = uRL.getPath();
            int n = string.indexOf("!/");
            if (n > 0) {
                try {
                    String string2;
                    String string3 = string.substring(n + 2);
                    URL uRL2 = new URL(string.substring(0, n));
                    CacheEntry cacheEntry = Cache.getCacheEntry(uRL2, null, null);
                    if (cacheEntry != null && (string2 = cacheEntry.getNativeLibPath()) != null) {
                        return new File(string2, string3);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored(malformedURLException);
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
            return null;
        }
        return DownloadEngine.getCachedFile(uRL);
    }

    public static File getCachedFile(URL uRL) throws IOException {
        return DownloadEngine.getCachedFile(uRL, null);
    }

    public static File getCachedFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedFile(uRL, string, false, false, null);
    }

    public static File getUpdatedFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getUpdatedFile(uRL, string, false, null);
    }

    public static File getUpdatedFile(URL uRL, String string, boolean bl, String string2) throws IOException {
        return DownloadEngine.getCachedFile(uRL, string, true, bl, string2);
    }

    public static File getCachedFile(URL uRL, String string, boolean bl, boolean bl2, String string2) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl, bl2, string2, 1);
        if (cacheEntry != null) {
            return cacheEntry.getDataFile();
        }
        return null;
    }

    public static File getCachedResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl);
        if (cacheEntry != null) {
            File file = new File(cacheEntry.getResourceFilename());
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean isJarFileCorrupted(URL uRL, String string) {
        block14: {
            ZipFile zipFile;
            block13: {
                zipFile = null;
                CacheEntry cacheEntry = null;
                cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, false);
                zipFile = new JarFile(cacheEntry.getResourceFilename(), false);
                if (zipFile == null) break block13;
                boolean bl = false;
                Object var6_6 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                return bl;
            }
            Object var6_7 = null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            break block14;
            {
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    Object var6_8 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {
                        Trace.ignoredException(iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                throw throwable;
            }
        }
        return true;
    }

    public static boolean isResourceCached(URL uRL, String string, String string2) throws IOException {
        return DownloadEngine.isResourceCached(uRL, string, string2, 1);
    }

    public static boolean isResourceCached(URL uRL, String string, String string2, int n) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false, n);
        return cacheEntry != null;
    }

    public static void removeCachedResource(URL uRL, String string, String string2) {
        CacheEntry cacheEntry = null;
        try {
            cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        if (cacheEntry != null) {
            Cache.removeCacheEntry(cacheEntry);
        }
    }

    public static Map getCachedHeaders(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl);
        if (cacheEntry != null) {
            return cacheEntry.getHeaders();
        }
        return null;
    }

    public static HttpRequest getHttpRequestImpl() {
        return _httpRequestImpl;
    }

    public static HttpDownload getHttpDownloadImpl() {
        return _httpDownloadImpl;
    }

    /*
     * Loose catch block
     */
    public static File applyPatch(File file, File file2, final URL uRL, final String string, final DownloadDelegate downloadDelegate, String string2) throws FailedDownloadException {
        File file3;
        block17: {
            JarDiffPatcher jarDiffPatcher = new JarDiffPatcher();
            file3 = new File(string2);
            FileOutputStream fileOutputStream = null;
            boolean bl = false;
            fileOutputStream = new FileOutputStream(file3);
            Patcher.PatchDelegate patchDelegate = null;
            if (downloadDelegate != null) {
                downloadDelegate.patching(uRL, string, 0);
                patchDelegate = new Patcher.PatchDelegate(){

                    public void patching(int n) {
                        downloadDelegate.patching(uRL, string, n);
                    }
                };
            }
            try {
                jarDiffPatcher.applyPatch(patchDelegate, file.getPath(), file2.getPath(), fileOutputStream);
            }
            catch (IOException iOException) {
                throw new FailedDownloadException(uRL, string, iOException);
            }
            bl = true;
            Object var13_13 = null;
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (!bl) {
                file3.delete();
            }
            file2.delete();
            if (downloadDelegate != null && !bl) {
                downloadDelegate.downloadFailed(uRL, string);
            }
            break block17;
            {
                catch (IOException iOException) {
                    throw new FailedDownloadException(uRL, string, iOException);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                if (!bl) {
                    file3.delete();
                }
                file2.delete();
                if (downloadDelegate != null && !bl) {
                    downloadDelegate.downloadFailed(uRL, string);
                }
                throw throwable;
            }
        }
        return file3;
    }

    public static boolean isJnlpURL(URL uRL) {
        try {
            HttpResponse httpResponse = DownloadEngine.getHttpRequestImpl().doHeadRequest(uRL);
            return httpResponse.getContentType().equals(JNLP_MIME_TYPE);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToUpdateCheckDoneList(String string) {
        if (string != null) {
            Object object = syncObject;
            synchronized (object) {
                updateCheckDoneList.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromUpdateCheckDoneList(String string) {
        Object object = syncObject;
        synchronized (object) {
            int n = -1;
            while ((n = updateCheckDoneList.indexOf(string)) > -1) {
                updateCheckDoneList.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearUpdateCheckDoneList() {
        Object object = syncObject;
        synchronized (object) {
            updateCheckDoneList.clear();
        }
    }

    public static boolean isUrlInAppContext(URL uRL) {
        String string = (String)AppContext.getAppContext().get(APPCONTEXT_BG_KEY + uRL);
        return string != null && string.equals(BACKGROUND_STRING);
    }

    public static boolean isUpdateAvailable(URL uRL, String string) throws IOException {
        return DownloadEngine.isUpdateAvailable(uRL, string, false, null);
    }

    public static boolean isUpdateAvailable(URL uRL, String string, boolean bl) throws IOException {
        return DownloadEngine.isUpdateAvailable(uRL, string, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateAvailable(URL uRL, String string, boolean bl, Map map) throws IOException {
        Object object = syncObject;
        synchronized (object) {
            if (updateCheckDoneList.contains(uRL.toString())) {
                return false;
            }
        }
        object = HttpUtils.removeQueryStringFromURL(uRL);
        if (!DownloadEngine.isBackgroundThread() && DownloadEngine.isUrlInAppContext(uRL)) {
            return false;
        }
        CacheEntry cacheEntry = null;
        if (Cache.isCacheEnabled()) {
            cacheEntry = Cache.getCacheEntry((URL)(string == null ? uRL : object), null, string);
        }
        if (string != null) {
            return false;
        }
        if (!DownloadEngine.isValidationRequired(cacheEntry)) {
            return false;
        }
        if (!DeployOfflineManager.promptUserGoOnline(uRL)) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        if (DeployOfflineManager.isGlobalOffline()) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        if (cacheEntry == null) {
            return true;
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, null, string, null, null, null, null, false, null, string == null ? 1 : 2);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        long l = -1L;
        l = cacheEntry.getLastModified();
        URL uRL3 = null;
        if (bl) {
            uRL3 = DownloadEngine.getPack200Url(uRL2);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (map != null) {
            stringArray = map.keySet().toArray(new String[0]);
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object v = map.get(stringArray[i]);
                if (v == null || !(v instanceof List)) continue;
                stringArray2[i] = (String)((List)v).get(0);
            }
        }
        try {
            httpResponse = httpRequest.doGetRequestEX(uRL3 != null ? uRL3 : uRL2, stringArray, stringArray2, l);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (uRL3 == null) {
                throw fileNotFoundException;
            }
            httpResponse = httpRequest.doGetRequestEX(uRL2, l);
        }
        if (httpResponse == null) {
            return true;
        }
        int n = httpResponse.getStatusCode();
        httpResponse.disconnect();
        boolean bl2 = true;
        if (n == 304) {
            bl2 = false;
        } else if (n == 200) {
            int n2 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            if (l2 == l && n2 == cacheEntry.getContentLength()) {
                bl2 = false;
            }
        }
        if (!bl2) {
            Object object2 = syncObject;
            synchronized (object2) {
                updateCheckDoneList.add(uRL.toString());
            }
            long l3 = httpResponse.getExpiration();
            if (l3 != 0L) {
                cacheEntry.updateExpirationInIndexFile(l3);
            }
        }
        return bl2;
    }

    private static String getVersionJarPath(String string, String string2) {
        String string3 = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(0, string.lastIndexOf("/") + 1);
        String string4 = string3;
        String string5 = null;
        if (string3.lastIndexOf(".") != -1) {
            string5 = string3.substring(string3.lastIndexOf(".") + 1);
            string3 = string3.substring(0, string3.lastIndexOf("."));
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (string2 != null) {
            stringBuffer.append("__V");
            stringBuffer.append(string2);
        }
        if (string5 != null) {
            stringBuffer.append(".");
            stringBuffer.append(string5);
        }
        string = string + stringBuffer.toString();
        return string;
    }

    private static URL getEmbeddedVersionUrl(URL uRL, String string) {
        if (string == null || string.indexOf("*") != -1 || string.indexOf("+") != -1) {
            return uRL;
        }
        URL uRL2 = null;
        String string2 = uRL.getProtocol();
        String string3 = uRL.getHost();
        int n = uRL.getPort();
        String string4 = uRL.getPath();
        string4 = DownloadEngine.getVersionJarPath(string4, string);
        try {
            uRL2 = new URL(string2, string3, n, string4);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return uRL2;
    }

    public static URL getPack200Url(URL uRL) {
        URL uRL2 = null;
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = uRL.getPath();
        String string4 = uRL.getQuery();
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.append(".pack.gz");
        if (string4 != null) {
            stringBuffer.append("?");
            stringBuffer.append(string4);
        }
        try {
            uRL2 = new URL(string, string2, n, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
        }
        return uRL2;
    }

    private static CacheEntry actionDownload(CacheEntry cacheEntry, final URL uRL, URL uRL2, String string, String string2, final DownloadDelegate downloadDelegate, int n, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = false;
        int n2 = -1;
        boolean bl4 = false;
        String string3 = null;
        if (cacheEntry != null && string2 != null) {
            long l;
            if (cacheEntry.getVersion() != null && new VersionString(string2).contains(new VersionID(cacheEntry.getVersion()))) {
                return cacheEntry;
            }
            if (Environment.isJavaPlugin() && (l = cacheEntry.getExpirationDate()) != 0L && new Date().after(new Date(l))) {
                cacheEntry = null;
            }
        }
        if (cacheEntry != null) {
            string3 = cacheEntry.getVersion();
        }
        CacheEntry cacheEntry2 = null;
        try {
            Object object;
            Object object2;
            HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
            HttpResponse httpResponse = null;
            long l = -1L;
            if (cacheEntry != null) {
                l = cacheEntry.getLastModified();
            }
            URL uRL3 = uRL2;
            if (DownloadEngine.isVersionContentType(n)) {
                uRL3 = DownloadEngine.getEmbeddedVersionUrl(uRL3, string2);
            }
            if (DownloadEngine.isPackContentType(n)) {
                uRL3 = DownloadEngine.getPack200Url(uRL3);
            }
            try {
                try {
                    httpResponse = httpRequest.doGetRequestEX(uRL3, l);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (uRL2.toString().equals(uRL3.toString())) {
                        throw fileNotFoundException;
                    }
                    httpResponse = httpRequest.doGetRequestEX(uRL2, l);
                    bl3 = true;
                    n2 = n;
                    if (DownloadEngine.isPackContentType(n) && (DownloadEngine.isNativeContentType(n) || DownloadEngine.isJarContentType(n))) {
                        n2 &= 0xFFFFEFFF;
                    }
                    if (DownloadEngine.isVersionContentType(n)) {
                        n2 &= 0xFFFEFFFF;
                    }
                }
            }
            catch (FailedDownloadException failedDownloadException) {
                throw failedDownloadException;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                httpResponse = httpRequest.doGetRequest(uRL2, false);
            }
            int n3 = httpResponse.getStatusCode();
            if (n3 == 404) {
                throw new FailedDownloadException(uRL, string2, new IOException("HTTP response 404"));
            }
            if (n3 == 304) {
                httpResponse.disconnect();
                return cacheEntry;
            }
            int n4 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            long l3 = httpResponse.getExpiration();
            boolean bl5 = JNLP_MIME_TYPE.equals(httpResponse.getContentType());
            if (!bl5 && Environment.isImportMode() && Environment.getImportModeExpiration() != null && l3 != 0L) {
                object2 = new Date(l3);
                if (((Date)object2).before(Environment.getImportModeExpiration())) {
                    httpResponse.disconnect();
                    return null;
                }
            } else if (!bl5 && Environment.isImportMode() && Environment.getImportModeTimestamp() != null && l2 != 0L && ((Date)(object2 = new Date(l2))).before(Environment.getImportModeTimestamp())) {
                httpResponse.disconnect();
                return null;
            }
            object2 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
            if (string2 != null && object2 == null && Environment.getImportModeCodebaseOverride() != null && new VersionID(string2).isSimpleVersion()) {
                object2 = string2;
            }
            if (cacheEntry != null) {
                if (object2 != null && new VersionString((String)object2).contains(string3)) {
                    httpResponse.disconnect();
                    return cacheEntry;
                }
                if (n4 == cacheEntry.getContentLength() && l2 == l && string3 == null) {
                    httpResponse.disconnect();
                    return cacheEntry;
                }
                if (string3 == null) {
                    bl4 = true;
                }
            }
            if (downloadDelegate != null) {
                downloadDelegate.setTotalSize(n4);
            }
            if (object2 == null && (Environment.isJavaPlugin() || DownloadEngine.isVersionContentType(bl3 ? n2 : n))) {
                object2 = string2;
            }
            Object object3 = object2;
            String string4 = httpResponse.getContentType();
            boolean bl6 = string4 != null && string4.equalsIgnoreCase(JARDIFF_MIME_TYPE);
            Trace.println(ResourceManager.getString("downloadEngine.serverResponse", String.valueOf(n4), new Date(l2).toString(), (String)object2, string4), TraceLevel.NETWORK);
            if (string4 != null && string4.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                String string5 = bufferedReader.readLine();
                bufferedReader.close();
                throw new FailedDownloadException(uRL2, string2, new IOException("Error returned: " + string5));
            }
            if (object2 == null && string2 != null && !DownloadEngine.isVersionContentType(bl3 ? n2 : n)) {
                throw new FailedDownloadException(uRL, string2, new IOException("missing version response from server"));
            }
            if (object2 != null && string2 != null && !bl) {
                if (!new VersionString(string2).contains((String)object2)) {
                    throw new FailedDownloadException(uRL, string2, new IOException("bad version response from server:" + (String)object2));
                }
                object = new VersionID((String)object2);
                if (!((VersionID)object).isSimpleVersion()) {
                    throw new FailedDownloadException(uRL, string2, new IOException("bad version response from server:" + (String)object2));
                }
            }
            Object object4 = object = downloadDelegate == null ? null : new HttpDownloadListener((String)object3){
                private final /* synthetic */ String val$responseVersion;
                {
                    this.val$responseVersion = string;
                }

                public boolean downloadProgress(int n, int n2) {
                    downloadDelegate.downloading(uRL, this.val$responseVersion, n, n2, false);
                    return true;
                }
            };
            if (bl2) {
                return Cache.downloadResourceToCache(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, bl4, uRL2, cacheEntry, bl6, bl3 ? n2 : n);
            }
            CacheEntry cacheEntry3 = Cache.downloadResourceToTempFile(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, bl4, uRL2, cacheEntry, bl6, bl3 ? n2 : n);
            cacheEntry3.setBusy(0);
            cacheEntry3.setIncomplete(1);
            cacheEntry3.updateIndexHeaderOnDisk();
            return cacheEntry3;
        }
        catch (Exception exception) {
            if (cacheEntry2 != null) {
                Cache.removeCacheEntry(cacheEntry2);
            }
            if (exception instanceof JARSigningException) {
                throw (JARSigningException)exception;
            }
            if (exception instanceof FailedDownloadException) {
                throw (FailedDownloadException)exception;
            }
            throw new FailedDownloadException(uRL2, string2, exception);
        }
    }

    private static void addURLArgument(StringBuffer stringBuffer, String string, String string2) {
        try {
            stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append('&');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.ignoredException(unsupportedEncodingException);
        }
    }

    private static URL getRequestURL(URL uRL, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 == null && string2 != null) {
            string3 = Cache.getCacheEntryVersion(uRL, string);
        }
        if (string2 != null && n == 2) {
            DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string2);
            if (string3 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_CURRENT_VERSION_ID, string3);
            }
        }
        if (string2 != null && n == 3) {
            if (bl) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_PLATFORM_VERSION_ID, string2);
            } else {
                DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string2);
            }
            DownloadEngine.addURLArgument(stringBuffer, ARG_ARCH, Config.getOSArch());
            DownloadEngine.addURLArgument(stringBuffer, ARG_OS, Config.getOSName());
            DownloadEngine.addURLArgument(stringBuffer, ARG_LOCALE, defaultLocaleString);
            if (string7 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_KNOWN_PLATFORMS, string7);
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, '?');
        }
        try {
            if (Environment.getImportModeCodebaseOverride() != null && Environment.getImportModeCodebase() != null) {
                return new URL(Environment.getImportModeCodebaseOverride() + uRL.getFile().substring(Environment.getImportModeCodebase().getFile().length()) + stringBuffer);
            }
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + stringBuffer);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return null;
        }
    }

    public static CacheEntry getResourceTempCacheEntry(URL uRL, String string, int n) throws IOException {
        CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, string, n);
        CacheEntry cacheEntry2 = DownloadEngine.getCacheEntry(cacheEntry, uRL, null, string, null, false, null, n, false);
        return cacheEntry2;
    }

    public static CacheEntry getCacheEntryTemp(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, String string3, int n) throws IOException {
        return DownloadEngine.getCacheEntry(null, uRL, string, string2, downloadDelegate, bl, string3, n, false);
    }

    private static CacheEntry getCacheEntry(CacheEntry cacheEntry, URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, String string3, int n) throws IOException {
        return DownloadEngine.getCacheEntry(cacheEntry, uRL, string, string2, downloadDelegate, bl, string3, n, true);
    }

    private static CacheEntry getCacheEntry(CacheEntry cacheEntry, URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, String string3, int n, boolean bl2) throws IOException {
        int n2 = 1;
        if (string3 != null) {
            n2 = 3;
        } else if (string2 != null) {
            n2 = 2;
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, string2, null, null, null, null, bl, string3, n2);
        return DownloadEngine.actionDownload(cacheEntry, uRL, uRL2, string, string2, downloadDelegate, n, bl, bl2);
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, int n) throws IOException {
        return DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, false, null, n);
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        return DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, false, null, 1);
    }

    private static boolean isValidationRequired(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return true;
        }
        boolean bl = true;
        if (!cacheEntry.isExpired()) {
            bl = false;
        }
        if (cacheEntry.isHttpNoCacheEnabled()) {
            bl = true;
        }
        return bl;
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, boolean bl2, String string3, int n) throws IOException {
        boolean bl3;
        if (!Cache.isCacheEnabled() && !bl) {
            return null;
        }
        CacheEntry cacheEntry = null;
        boolean bl4 = bl3 = !Cache.isCacheEnabled() || bl && DownloadEngine.isUpdateAvailable(uRL, string2, DownloadEngine.isPackContentType(n));
        if (!bl3 && (cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(uRL.toString())) != null) {
            String string4 = cacheEntry.getVersion();
            if (string2 == null && string4 == null || string2 != null && string4 != null && string4.compareTo(string2) >= 0) {
                return cacheEntry;
            }
        }
        if (Cache.isCacheEnabled()) {
            cacheEntry = Cache.getCacheEntry(uRL, string, string2, n);
        }
        if (bl && (cacheEntry == null || DownloadEngine.isValidationRequired(cacheEntry))) {
            cacheEntry = Cache.isCacheEnabled() ? DownloadEngine.getCacheEntry(cacheEntry, uRL, string, string2, downloadDelegate, bl2, string3, n) : DownloadEngine.getCacheEntryTemp(uRL, string, string2, downloadDelegate, bl2, string3, n);
            MemoryCache.addLoadedResource(uRL.toString(), cacheEntry);
            if (cacheEntry != null && Cache.isCacheEnabled()) {
                Cache.touch(new File(cacheEntry.getResourceFilename() + Cache.getIndexFileExtension()));
            }
        }
        return cacheEntry;
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2) {
        int n = string2 != null ? 3 : 2;
        URL uRL2 = DownloadEngine.getRequestURL(uRL, null, string, null, null, null, null, bl, string2, n);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        String string3 = null;
        try {
            httpResponse = httpRequest.doGetRequest(uRL2);
            if (httpResponse != null) {
                string3 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
                httpResponse.disconnect();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
        return string3;
    }

    static boolean isJarHeaderValid(byte[] byArray) {
        return DownloadEngine.get32(byArray, 0) == 67324752L;
    }

    private static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n) {
        return (long)DownloadEngine.get16(byArray, n) | (long)DownloadEngine.get16(byArray, n + 2) << 16;
    }

    static {
        APPCONTEXT_BG_KEY = Config.getAppContextKeyPrefix() + "bg-";
        backgroundUpdateThreadLocal = new InheritableThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
        jarCompression = -1;
        noCacheJarFileList = new Hashtable();
        _httpRequestImpl = new BasicHttpRequest();
        _httpDownloadImpl = new HttpDownloadHelper(_httpRequestImpl);
        updateCheckDoneList = new ArrayList();
        syncObject = new Object();
    }

    public static interface DownloadDelegate {
        public void setTotalSize(long var1);

        public void downloading(URL var1, String var2, int var3, int var4, boolean var5);

        public void validating(URL var1, int var2, int var3);

        public void patching(URL var1, String var2, int var3);

        public void downloadFailed(URL var1, String var2);
    }

    public static interface DownloadProgress {
        public void jreDownload(String var1, URL var2);

        public void extensionDownload(String var1, int var2);

        public void progress(URL var1, String var2, long var3, long var5, int var7);

        public void validating(URL var1, String var2, long var3, long var5, int var7);

        public void patching(URL var1, String var2, int var3, int var4);

        public void downloadFailed(URL var1, String var2);
    }
}

