/*
 * Decompiled with CFR 0.152.
 */
package commons.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTimeFilter
implements Filter {
    protected static Logger log = LoggerFactory.getLogger(ProcessTimeFilter.class);
    public static final String PROCESS_START_TIME = "p_s_t";

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        long begin = System.currentTimeMillis();
        req.setAttribute(PROCESS_START_TIME, (Object)begin);
        try {
            fc.doFilter(req, resp);
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                long ms = System.currentTimeMillis() - begin;
                HttpServletRequest hreq = (HttpServletRequest)req;
                log.debug("[PROCESS] " + ms + " " + hreq.getRequestURI() + (hreq.getQueryString() != null ? "?" + hreq.getQueryString() : ""));
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            long ms = System.currentTimeMillis() - begin;
            HttpServletRequest hreq = (HttpServletRequest)req;
            log.debug("[PROCESS] " + ms + " " + hreq.getRequestURI() + (hreq.getQueryString() != null ? "?" + hreq.getQueryString() : ""));
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

