/*
 * Decompiled with CFR 0.152.
 */
package commons.web;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCacheFilter
implements Filter {
    protected static Logger log = LoggerFactory.getLogger(NoCacheFilter.class);
    public static final String EXT_NAMES = "extNames";
    public static final String NO_CACHE_EXCLUDE = "ncex";
    public static final String SPLIT_CHAR = ";";
    private Set<String> extNames;

    public void init(FilterConfig conf) throws ServletException {
        String[] ss;
        this.extNames = new HashSet<String>();
        String enStr = conf.getInitParameter(EXT_NAMES);
        if (enStr == null) {
            return;
        }
        String[] stringArray = ss = enStr.split(SPLIT_CHAR);
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!(s = s.trim()).equals("")) {
                this.extNames.add("." + s);
            }
            ++n2;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        if (this.isMatch(req)) {
            HttpServletResponse hresp = (HttpServletResponse)resp;
            hresp.setHeader("Pragma", "no-cache");
            hresp.setHeader("Cache-Control", "no-cache");
            hresp.setDateHeader("Expires", 0L);
        }
        try {
            fc.doFilter(req, resp);
        }
        catch (Throwable ex) {
            log.error("No catched exception.", ex);
            throw new RuntimeException(ex);
        }
    }

    private boolean isMatch(ServletRequest sreq) {
        HttpServletRequest req = (HttpServletRequest)sreq;
        if ("true".equals(req.getParameter(NO_CACHE_EXCLUDE))) {
            return false;
        }
        String uri = req.getRequestURI();
        for (String en : this.extNames) {
            if (!uri.endsWith(en)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

